
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <intrpt.h>

#include "1512gfx.h"


#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#endif

typedef unsigned char byte;

/* BMP header */
	
byte hdr[54] = {'B', 'M', /* [0]  Magic number */
		   54, 87, 7, 0,  /* [2]  file size */
		   0,   0, 0, 0,  /* [6]  zero */
		   54,  4, 0, 0,  /* [a]  offset to image data */
		   40,  0, 0, 0,  /* [e]  length of info area*/
		   32, 3, 0, 0,	  /* [12] width  = 800 */
		   88, 2, 0, 0,   /* [16] height = 600 */
		   1,  0,         /* [1a] planes */
		   8,  0,         /* [1c] colour depth */
		   0,  0, 0, 0,   /* [1e] no compression */
		   0, 83, 7, 0,   /* [22] picture size, 800*600 */
		   0,  0, 0, 0,   /* [26] horizontal resolution */
		   0,  0, 0, 0,   /* [2a] vertical resolution */		   		   
		   0,  0, 0, 0,   /* [2e] colours used */
		   0,  0, 0, 0,   /* [32] important colours */
};				  /* total: 54 bytes */

/* BMP palette */

byte palette[1024];

void plot(int x, int y, byte r, byte g, byte b, byte i)
{
	unsigned char far *ptr;
	unsigned int offs;
	
	if (x < 0 || y < 0 || x > 639 || y > 199) return;

	if (y & 1)
		 offs = (y / 2) * 80 + (x >> 3) + 0x2000;
	else offs = (y / 2) * 80 + (x >> 3);

	ptr = FP_CONSTRUCT(0xB800, offs);
	
	gfx_wplane(1);
	ptr[0] = b;
	gfx_wplane(2);
	ptr[0] = g;
	gfx_wplane(4);
	ptr[0] = r;
	gfx_wplane(8);
	ptr[0] = i;
	
}


void trans4(byte b, byte *rv, byte *bv, byte *gv, byte *iv)
{
	byte r1, g1, b1;
	int clr;
	
	*rv = (*rv) << 1;
	*gv = (*gv) << 1;
	*bv = (*bv) << 1;
	*iv = (*iv) << 1;

	clr = ((b >> 4) * 4);

	r1 = palette[clr + 2];
	g1 = palette[clr + 1];
	b1 = palette[clr];

	if (r1 & 0x80) *rv |= 1;
	if (g1 & 0x80) *gv |= 1;
	if (b1 & 0x80) *bv |= 1;
	if (r1 > 0xC0 || g1 > 0xc0 || b1 > 0xc0) *iv |= 1;
}



void trans8(byte b, byte *rv, byte *bv, byte *gv, byte *iv)
{
	byte r1, g1, b1;
	int clr;
	
	*rv = *rv << 1;
	*gv = *gv << 1;
	*bv = *bv << 1;
	*iv = *iv << 1;

	clr = (b * 4);

	r1 = palette[clr + 2];
	g1 = palette[clr + 1];
	b1 = palette[clr];

	if (r1 > 0x80) *rv |= 1;
	if (g1 > 0x80) *gv |= 1;
	if (b1 > 0x80) *bv |= 1;
	if (r1 | g1 | b1 > 0xc0) *iv |= 1;
}




int main(int argc, char **argv)
{
	FILE *fp;
	long ll, xx, yy, w, h;
	long ps, llen;
	int depth;
	byte rv, gv, bv, iv;
	
	if (!gfx_init()) 
	{
		fprintf(stderr,"This program requires an Amstrad PC1512 graphics adaptor.\n");
		exit(1);
	}

	if (argc < 2)
	{
		fprintf(stderr,"Syntax: 1512BMP <bmpfile> { <4plfile> }\n");
		exit(1);
	}
	fp = fopen(argv[1], "rb");
	if (!fp)
	{
		perror(argv[1]);
		exit(1);
	}
	fread(hdr, 1, 54, fp);	/* BMP header */
	
	if (hdr[0] != 'B' || hdr[1] != 'M')
	{
		fprintf(stderr, "%s: not a BMP file\n", argv[1]);
		fclose(fp);
		exit(1);
	}

	if (hdr[0x1a] > 8) 
	{
		fclose(fp);
		fprintf(stderr,"Can't display 24-bit BMP files\n");
		exit(1);
	}
	
	/* Little-Endian assumption here! */

	ll = * ((long*)(hdr + 0x0e));

	if (ll > 40) fseek(fp, ll - 40, SEEK_CUR);

	/* Load the palette */

	ll = * ((long *)(hdr + 0x0a)) - ftell(fp);

	if (ll > 1024)
		{
		fread(palette, 1, 1024, fp);
		fseek(fp, ll - 1024, SEEK_CUR);
		}
	else
		{
		fread(palette, 1, ll, fp);
		}

	/* Palette loaded */

	w = * ((long*)(hdr + 0x12));
	h = * ((long*)(hdr + 0x16));

	depth = * ((short *)(hdr + 0x1c));
	
	gfx_mode();
	
	switch(depth)
	{
		case 1:  llen = (w+7) / 8; while (llen & 3) ++llen; break;
		case 4:  llen = (w+1) / 2; while (llen & 3) ++llen; break;
		default: llen = w;     while (llen & 3) ++llen; break;
	}
/*
	fprintf(stderr, "w = %ld h = %ld llen = %lx ps = %lx d = %d\n", w, h, llen, ftell(fp), depth);
	getch();
*/	
	for(yy = h - 1; yy >= 0; --yy)
	{
		ps = ftell(fp);

		for (xx = 0; xx < w; xx += 8)
		{
			byte b;
			int n;
			switch(depth)	
			{
				case 1:	/* b/w, easy */
				b = fgetc(fp);
				plot(xx, yy, b, b, b, b);
				break;

				case 4: /* 16 colours */
				rv = gv = bv = iv = 0;
				for (n = 0; n < 4; n++)
				{
					b = fgetc(fp);
					trans4(b, &rv, &bv, &gv, &iv);
					trans4(b << 4, &rv, &bv, &gv, &iv);
				}
				plot(xx, yy, rv, gv, bv, iv);
				break;	

				case 8: /* 256 colours */
				rv = gv = bv = iv = 0;
				for (n = 0; n < 8; n++)
				{
					b = fgetc(fp);
					trans8(b, &rv, &bv, &gv, &iv);
					if (n == 3 && (xx + 4 > w)) 
					{
						rv = rv << 4;
						bv = bv << 4;
						gv = gv << 4;
						iv = iv << 4;
						break;
					}
				}
				plot(xx, yy, rv, gv, bv, iv);
				break;
			}
		}
		fseek(fp, ps, SEEK_SET);
		fseek(fp, llen, SEEK_CUR);	
	}
	fclose(fp);

	if (argc > 2)
	{
		unsigned char *plane = malloc(0x3F3F);
		int n;
		
		if (!plane)
		{
			gfx_off();
			fprintf(stderr,"Out of memory\n");
			exit(1);
		}
		
		fp = fopen(argv[2], "wb");
		if (!fp)
		{
			free(plane);
			gfx_off();
			perror(argv[2]);
			exit(1);
		}
		for (n = 0; n < 4; n++)
		{
			gfx_rplane(n);
			gfx_getplane(plane);
			fwrite(plane, 1, 0x3F3F, fp);
			if (ferror(fp))
			{
				fclose(fp);
				free(plane);
				gfx_off();
				perror(argv[2]);
				exit(1);
			}
		}
		fclose(fp);
		free(plane);	
	}

	
	ei();
	getch();
	
	gfx_off();
	cputs("Done.\n");
	return 0;	
}
