
#include <dos.h>
#include <intrpt.h>
#include "1512gfx.h"


static int inited = 0;
static int cga    = 0;
static int mode   = 0;

int  gfx_init(void)
{
	/* See if we're on a PC1512 or not... */

	union REGS ir, or;
	unsigned char v;
	ir.x.ax    = 0x06FF;
	ir.x.bx    = 0;
	ir.x.cflag = 0;

	int86(0x15, &ir, &or);

	if (or.x.bx == 0 || or.x.cflag) 
	{
		cga = 1;
		inited = 1;
		return 0;	/* Not a PC1512 */
	}
	di();
	v=inp(0x03DA);	/* See the PC1640 tech manual, P17. Test for 1512/1640: */
	v=inp(0x037A);	/* Read a CGA port; then immediately read port 0x37A */
	ei();			/* If bit 5 is set it is a PC1512 */

	inited = 1;
	if (!(v & 0x20)) 
	{
		cga = 1;
		return 0;	/* 1640 */
	}
	return 1;
}


void gfx_mode(void)
{
	unsigned char far *ptr = FP_CONSTRUCT(0x40, 0x65);
	unsigned char v;
	union REGS ir, or;
	
	if (!inited) return;

	ir.x.ax    = 0x0F00;
	int86(0x10, &ir, &or);
	mode       = or.h.al;
	
	ir.x.ax=0x06;
	int86(0x10, &ir, &ir);	/* CGA 640x200 */

	if (cga) return;
	
	gfx_flyback(1);	/* Wait for frame flyback */
	di();
	v    = (*ptr | 0x10);	/* Special graphics mode bit */
	*ptr = v;
	outp(0x3D8, v);
	outp(0x3D9, 0x0F);
	ptr[1] = 0x0F;
	
	ei();
}


void gfx_off(void)
{
	union REGS ir;

	if (!inited) return;
	
	ir.x.ax = mode;
	int86(0x10, &ir, &ir);
}


void gfx_wplane(unsigned char plane)
{
	if (!inited || cga) return;
	outp(0x3DD, plane & 0x0f);
}


void gfx_rplane(unsigned char plane)
{
	if (!inited || cga) return;
	outp(0x3DE, plane & 3);
}



int  gfx_flyback(int wait)
{
	volatile unsigned v;
	
	if (!inited) return 0;
	if (!wait) return (inp(0x03DA) & 0x8);

	v = 0x8;
	while (v & 0x8)    v = inp(0x03DA) & 0x8;
	while (!(v & 0x8)) v = inp(0x03DA) & 0x8;
	return 0;
}


void gfx_border(int bdr)
{
	if (!cga) outp(0x3DF, bdr);
}


void gfx_getplane(unsigned char *plane)
{
	unsigned char far *scr = FP_CONSTRUCT(0xB800, 0);
	register short n;

	for (n = 0; n < 0x3F3F; n++)
	{
		*plane = *scr;
		++plane;
		++scr;
	}
	

}



void gfx_putplane(unsigned char *plane)
{
	unsigned char far *scr = FP_CONSTRUCT(0xB800, 0);
	register short n;

	for (n = 0; n < 0x3F3F; n++)
	{
		*scr = *plane;
		++plane;
		++scr;
	}
}



