
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <intrpt.h>

#include "1512gfx.h"


#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#endif

typedef unsigned char byte;


int main(int argc, char **argv)
{
	FILE *fp;
	byte *plane;
	int n;
	
	if (!gfx_init()) 
	{
		fprintf(stderr,"This program requires an Amstrad PC1512 graphics adaptor.\n");
		exit(1);
	}

	if (argc < 2)
	{
		fprintf(stderr,"Syntax: LOAD4PL <4plfile>\n");
		exit(1);
	}
	fp = fopen(argv[1], "rb");
	if (!fp)
	{
		perror(argv[1]);
		exit(1);
	}

	plane = malloc(0x3F3F);
		
	if (!plane)
	{
		fclose(fp);
		fprintf(stderr,"Out of memory\n");
		exit(1);
	}

	gfx_mode();
	
	for (n = 1; n < 0x10; n = (n << 1))
	{
		fread(plane, 1, 0x3F3F, fp);
		if (ferror(fp))
		{
			free(plane);
			gfx_off();
			perror(argv[1]);
			exit(1);
		}
		gfx_wplane(n);
		gfx_putplane(plane);
	}
	fclose(fp);
	free(plane);	

	ei();
	getch();
	
	gfx_off();
	return 0;	
}
