
 
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."
 
         TITLE 'PHASE II - SUPPORT SET ATTRIBUTE OPCODES '
 
;----------------------------------------------------------------------------*
;        Revision : NOV. 14, 1982    File : "DOATTRMX.ASM"  Version 1.1      *
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            *
;  11/14  1. Character height CHRHT = NDTXSZ * 8                             *
;         2. Character Width  CHRSZ = NDTXSZ * 6                             *
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            ;
;----------------------------------------------------------------------------*
 
	 EXTRN  NDLNSZ, NDTXSZ, NDMKSZ, NDTXRT
	 EXTRN  WKID, NDLNTY, NDLNCO, NDMKTY, NDMKCO, NDTXTY, NDTXCO
	 EXTRN  NDINTY, NDFITY, NDFICO
         EXTRN  LSTYLE, CHRSZ, CHRHT
         EXTRN  CONTRL, INTIN, PTSIN, INTOUT, PTSOUT
 
         PUBLIC SELNTY, SELNSZ, SELNCO, SEMKTY, SEMKSZ, SEMKCO
         PUBLIC SETXSZ, SETXRT, SETXTY, SETXCO
         PUBLIC SEFITY, SEFINX, SEFICO, SEWRMOD
 
         EXTRN  GETNXT
	 EXTRN	LINEMODE, LINEBIT, FILLMODE, FILLBIT
	 EXTRN	TEXTMODE, TEXTBIT, MARKMODE, MARKBIT, BGMODE, BGBIT
	 EXTRN	NDWRMOD, ZBACKG, DRAWMODE, DRAWBIT
 
;----------------------------------------------------------------------------+
; Set Char Height    Opcode = 12                                             +
;----------------------------------------------------------------------------+
 
SETXSZ
;        Get Character size Indicator (1-16) from OBJLST
 
         CALL   GETNXT           ;Returns NDTXSZ in <a>
 
         STA    NDTXSZ
         MOV    B,A
         RAL
         RAL
         RAL
         STA    CHRHT            ;Character height : NDTXSZ * 8
         sub    b
         sub    b                ;Character width : NDTXSZ * 6
         sta    CHRSZ
         RET
 
 
;----------------------------------------------------------------------------+
; Set Char Up Vector Opcode = 13                                             +
;----------------------------------------------------------------------------+
 
SETXRT
;        Get Character rotation indicator (0-3) from OBJLST
 
         CALL    GETNXT          ;Returns NDTXRT in <a>
 
         STA     NDTXRT
         RET
 
;----------------------------------------------------------------------------+
; Set Color Rep      Opcode = 14
;----------------------------------------------------------------------------+
 
;*** NOACT    RET
 
;----------------------------------------------------------------------------+
; Set Polyline Type  Opcode = 15
;----------------------------------------------------------------------------+
 
SELNTY
;        Get Line style bit pattern No. from OBJLST
 
         CALL   GETNXT
         STA    NDLNTY           ;Current Device Line Style requested
 
;        Set up requested Line Style Pattern in LSTYLE

;;; [DDFXHR8] Presumed to have been done when the metafile was created
;;; 
;;;         CPI    5
;;;         JC     SELN01
;;;         MVI    A,     0
SELN01
         LXI    H,     LNTBL
         MOV    E,     A
         MVI    D,     0
         DAD    D
         DAD    D
         MOV    E,     M
         INX    H
         MOV    D,     M
         XCHG
         SHLD   LSTYLE
 
         RET
 
;        0 - SOLID, 1 - DASHED, 2 - DOTTE, 3 - DASHED-DOTTED, 4 - LONG DASH
;        Bit patterns : 1-short dash = F0F0, 5-long dash   = FF00,
;                       2-dotted     = 8888, 3-dash dotted = FC30,
;                       4-dash dot dot = F088
LNTBL
         DW     0FFFFH           ;SOLID
         DW     0F8F8H           ;SHORT DASH
         DW     8888H            ;DOTTED
         DW     0FC30H           ;DASH DOTTED
         DW     0FFE0H           ;LONG DASH
         DW     0FCCCH           ;DASH DOT DOT
 
;----------------------------------------------------------------------------+
; Set Polyline Width Opcode = 16
;----------------------------------------------------------------------------+
 
SELNSZ
;        Get Line Size Indicator from Objlst
 
;***         CALL   GETNXT
;***         STA    NDLNSZ
 
         RET
 
;----------------------------------------------------------------------------+
; Set Polyline Color Opcode = 17
;----------------------------------------------------------------------------+
 
SELNCO
;        Get the Color Index from OBJLST
 
         CALL   GETNXT
         STA    NDLNCO
	 ORA	A	;[DDFXHR8] If colour is 0 select background 
	 JNZ	SLCJ01	;          pen
	 INR	A
	 STA	LINEMODE ; Else select foreground pen
	 CMA
	 JMP	SLCJ02

SLCJ01	 LDA	BGMODE
	 STA	LINEMODE
	 LDA	BGBIT
SLCJ02	 STA	LINEBIT
         RET
 
;----------------------------------------------------------------------------+
; Set Polymarker Typ Opcode = 18
;----------------------------------------------------------------------------+
 
SEMKTY
;        Get ASCII MAKER SYMBOL from OBJLST
 
         CALL   GETNXT
         STA    NDMKTY
         RET
 
;----------------------------------------------------------------------------+
; Set Polymarker Scl Opcode = 19
;----------------------------------------------------------------------------+
 
SEMKSZ
;        Get Maker Size factor from OBJLST
 
         CALL   GETNXT
         STA    NDMKSZ
         RET
 
;----------------------------------------------------------------------------+
; Set Polymarker Clr Opcode = 20
;----------------------------------------------------------------------------+
 
SEMKCO
         CALL   GETNXT
         STA    NDMKCO
	 ORA	A	;[DDFXHR8] If colour is 0 select background 
	 JNZ	SMCJ01	;          pen
	 INR	A
	 STA	MARKMODE ; Else select foreground pen
	 CMA
	 JMP	SMCJ02

SMCJ01	 LDA	BGMODE
	 STA	MARKMODE
	 LDA	BGBIT
SMCJ02	 STA	MARKBIT
         RET
 
;----------------------------------------------------------------------------+
; Set Text Font      Opcode = 21
;----------------------------------------------------------------------------+
 
SETXTY
;***         CALL   GETNXT
;***         STA    NDTXTP
 
         RET
 
;----------------------------------------------------------------------------+
; Set Text Color     Opcode = 22
;----------------------------------------------------------------------------+
 
SETXCO
         CALL   GETNXT
         STA    NDTXCO
	 ORA	A	;[DDFXHR8] If colour is 0 select background 
	 JNZ	STCJ01	;          pen
	 INR	A
	 STA	TEXTMODE ; Else select foreground pen
	 CMA
	 JMP	STCJ02

STCJ01	 LDA	BGMODE
	 STA	TEXTMODE
	 LDA	BGBIT
STCJ02	 STA	TEXTBIT
         RET
 
;----------------------------------------------------------------------------+
; Set Fill Int Style Opcode = 23
;----------------------------------------------------------------------------+
 
SEFITY
         CALL   GETNXT
         STA    NDFITY
         RET
 
;----------------------------------------------------------------------------+
; Set Fill Sty Index Opcode = 24
;----------------------------------------------------------------------------+
 
SEFINX
         CALL    GETNXT
         STA     NDINTY
         RET
 
;----------------------------------------------------------------------------+
; Set Fill Color     Opcode = 25
;----------------------------------------------------------------------------+
 
SEFICO
         CALL   GETNXT
         STA    NDFICO
	 ORA	A	;[DDFXHR8] If colour is 0 select background 
	 JNZ	SFCJ01	;          pen
	 INR	A
	 STA	FILLMODE ; Else select foreground pen
	 CMA
	 JMP	SFCJ02

SFCJ01	 LDA	BGMODE
	 STA	FILLMODE
	 LDA	BGBIT
SFCJ02	 STA	FILLBIT
         RET
 
;----------------------------------------------------------------------------+
; Inq Color Rep      Opcode = 26
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Inq Cell Array     Opcode = 27
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Input Locator      Opcode = 28                                             +
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Input Valuator     Opcode = 29
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Input Choice       Opcode = 30
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Input String       Opcode = 31
;----------------------------------------------------------------------------+
 
;----------------------------------------------------------------------------+
; Set Writing Mode   Opcode = 32
;----------------------------------------------------------------------------+

SEWRMOD
	CALL	GETNXT
	STA	NDWRMOD
	ORA	A
	JNZ	SEWJ01
	STA	ZBACKG
	JMP	SEWJ02

SEWJ01	MOV	B,A
	MVI	A,1
	STA	ZBACKG
	MOV	A,B
	CPI	2	;XOR mode?
	JNC	SEWJ03

SEWJ02	MVI	A,1
	STA	BGBIT
	XRA	A
	JMP	SEWJ05

SEWJ03	
	CPI	3	;Erase mode?
	JNC	SEWJ04
	DCR	A
	STA	BGBIT
	MVI	A,0FFh
	JMP	SEWJ05

SEWJ04
	MVI	A,0FEh
	STA	BGBIT
	CMA
SEWJ05
	STA	BGMODE
	STA	DRAWMODE
	STA	LINEMODE
	STA	MARKMODE
	STA	TEXTMODE
	STA	FILLMODE
	LDA	BGBIT
	STA	DRAWBIT
	STA	LINEBIT
	STA	MARKBIT
	STA	TEXTBIT
	STA	FILLBIT
	RET
 
;----------------------------------------------------------------------------+
; Set Input Mode     Opcode = 33
;----------------------------------------------------------------------------+
 
         RET
 
         END
 
