
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."

         TITLE  'DOBAR - BAR GENERALIZED DRAWING PRIMITIVE'
 
; ****************************************************************************
; *                                                                          *
; *  DOBAR  : DRAW A FILLED BAR          - MAIN MODULE                       *
; *                                                                          *
; *                                                                          *
; ****************************************************************************
;                                                                            *
;  Revision : Nov. 10, 1982   File "DOBAR.ASM"     Version 1.4               *
;                                                                            *
;  dobar                                                                     *
;                                                                            *
;  Input    :                                                                *
;                                                                            *
;  Output   :                                                                *
;                                                                            *
;  Calls    :  GETXY - Get x,y point of the next point in the object list    *
;              CLIPIT - Clip line to printer plot strip                      *
;              DRAWXY - Raster convert vector to pixel values                *
;              ADDR
;              SETBIT
;                                                                            *
;*****************************************************************************

;
; This is very much abbreviated from the version in DDMX80, because 
; almost everything is handed off to the general filled-shape handler
; in DOFILL
; 
	PUBLIC  DOBAR, DOCELL
	EXTRN	DOBOX, GETNXT, NDLNTY, DOLINE, GDPOP

CLSTYLE	DW	0	;Line style saved through DOCELL
 
DOBAR
	;  Get the GDP opcode, it should be a one - a bar
	CALL    GETNXT
	DCR	A
	RNZ			; It was not 1
	INR	A
	STA	GDPOP
	CALL	DOBOX
	RET

DOCELL	LDA	NDLNTY		; Save line drawing style
	STA	CLSTYLE
	XRA	A
	STA	NDLNTY		; Select line style 0 (solid)
	CALL	DOLINE		; Draw the border as a polyline
	LDA	CLSTYLE
	STA	NDLNTY		; Restore line drawing style
	RET

	END
	
