
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."

         TITLE 'DOFILL - DRAW POLYGON OUTLINE'

;
; DDMX80 can't do filled areas, so this file is almost entirely new to the 
; DDFX drivers. It's based on disassembly and is very lightly commented; as
; long as it assembles to the same code as the original, I haven't bothered
; to study how it works.
;
 
; ****************************************************************************
; *                                                                          *
; *      DOFILL : Generate Polygon Outlines                                  *
; *                                                                          *
; ****************************************************************************
;                                                                            *
;  Revision : NOV. 10, 1982      File "DOFILL.ASM"   Version 1.0             *
;                                                                            ;
;***** MODE NOTES :  *********************************************************
;                                                                            *
;      1) LINE STYLE SUPPORT VARIABLES IN PUBLIC :                           *
;         LINE ENDPOINTS -  X0, Y0, XN, YN, SPECIL                           *
;         FILTER Y AND SET BIT FLAGS - ABOVE, INSIDE, ZONED                  *
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            ;
;  Calls    :                                                                *
;                                                                            *
;  GETXY  - Get the x,y coordinates of the next point in OBJLST (4 Bytes)    *
;  DRAWIT - Raster convert vector to pixel values, maps pixel                *
;                      to bitmap address and 'sets' the bit                  *
;                                                                            *
;  GETPT  : Get pt. coord. from PTSIN array (2 bytes)                        *
;  PUTPT  : Put pt. coord. into OBJLST buffer (2 bytes)                      *
;  PUTBYT : Put 1 byte into OBJLST buffer                                    *
;  GETBYT : Get 1 byte from OBJLST buffer                                    *
;  GETMIN : Returns in <hl> the smaller of <hl>, <de> values                 *
;  GETMAX : Retruns in <de> the larger of Values in <hl> and <de>            *
;                                                                            *
;*****************************************************************************
 
         PUBLIC DOFILL,PLINE2,GDPOP,DOBOX
         EXTRN  GETXY, GETNXT, RSTAT
         EXTRN  DRAWIT
         EXTRN  BNEXT
	 EXTRN  BYTNDX	
	 EXTRN  NDLNTY
	 EXTRN	BSKIP
	 EXTRN	HATCHES
	 EXTRN	NDLNCO, NDFICO, NDFITY, LSTYLE, BOTY, TOPY, NDINTY
	 EXTRN	FILLMODE, DRAWMODE, FILLBIT, DRAWBIT
	 EXTRN	CMPDH, MUL8, SUBDH, MUL32, NEGHL, DIV32
	 EXTRN  X0, X1, X2, XN, Y0, Y1, Y2, YN, ABOVE, SPECIL, DRAWXY
 
;        EXTRN   ABSHL, NEGHL, CMPDH, CMPS, SUBDH, MIDH, DIDH, IMOD
 
 


 
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;        Polygon (Fill Area)                                                 +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 
DOFILL

	XRA	A
	STA	GDPOP
DOBOX
	LDA	NDLNCO	;Save line colour
	STA	SLNCO
	LDA	NDFICO	;Set line colour to fill colour
	STA	NDLNCO	
 
;----------------------------------------------------------------------------+
;        Take care of Attributes - Linestyle, color                          +
;        Save Current polyline linetype, linecolor                           +
;        Set linestyle to SOLID, color to Current Fill area color            +
;----------------------------------------------------------------------------+
 
         LDA    NDLNTY
         STA    LNTY
;;         XRA    A
;;         STA    NDLNTY
 
;----------------------------------------------------------------------------+
;        Save NPT                                                            +
;----------------------------------------------------------------------------+
 
         CALL   GETNXT
         STA    NPT
         INR    A	;[DDFXHR8 does this after the store rather than before]
	 LHLD	BNEXT
	 SHLD	BNEXT1	;Save position in metafile
	 LHLD	BYTNDX
	 SHLD	BYTND1
	 MOV	L,A
	 MVI	H,0	
	 DAD	H	;*2
	 DAD	H	;*4
	 CALL	BSKIP	;Skip over the coordinates of the polygon edge
			;(MX80 drew border before fill, FX80 does it after)
 
;----------------------------------------------------------------------------+
;        Output Polygon edge, Call Polyline routine                          +
;----------------------------------------------------------------------------+
 
;;;         CALL   DRAWIT           ;Returns Pointer to next entry in <hl>
 
;----------------------------------------------------------------------------+
;        Get Polygon Minimum/Maximum extents                                 +
;----------------------------------------------------------------------------+
 
         CALL   GETXY            ;Get Minimum polygon extent xpmin, ypmin
         XCHG                    ;Returns <de> = xpmin, <bc> = ypmin,
	 SHLD	X1MIN
	 SHLD	X1MIN2
	 MOV	H, B
	 MOV	L, C
	 SHLD	Y1MIN
	 CALL	GETXY
	 XCHG
	 SHLD	X2MAX
	 SHLD	X2MAX2
         MOV    H, B
         MOV    L, C
         SHLD   Y2MAX
	 LHLD	BNEXT		 ;Save current position in metafile
	 SHLD	BNEXT2
	 LHLD	BYTNDX
	 SHLD	BYTND2
	 
;----------------------------------------------------------------------------+
;        Polygon outside of current Plot Strip ?                             +
;----------------------------------------------------------------------------+
 
	 LHLD	Y2MAX
	 XCHG
	 LHLD	BOTY	;Below current strip
	 CALL	CMPDH
	 JC	DOFJ99
	 LHLD	TOPY
	 XCHG
	 LHLD	Y1MIN
	 CALL	CMPDH
	 JC	DOFJ99
;----------------------------------------------------------------------------+
;        Determine fill pattern to use                                       +
;----------------------------------------------------------------------------+
	LDA	NDFITY
	ORA	A
	JZ	DOFBDR	; Hollow. Just draw the border.
	LHLD	LSTYLE
	SHLD	SLSTYLE	; Save line style (it will be used for fill pattern)
	LDA	FILLMODE
	STA	DRAWMODE
	LDA	FILLBIT
	STA	DRAWBIT
	LXI	H,0
	LDA	NDFITY
	STA	NDLNTY
	DCR	A
	JZ	DOFJ02	;Solid -> hatch 0
	LHLD	NDINTY	;HL -> patterns
	CPI	2
	JZ	DOFJ01
	LXI	D,6	
	DAD	D	;HL -> hatches
DOFJ01	CALL	MUL8
DOFJ02	LXI	D,HATCHES
	DAD	D
	SHLD	FHATCH
;
; Work out the number of lines covered by the intersection of the filled
; shape and this band
;
	LHLD	TOPY
	SHLD	FTOPY
	LHLD	BOTY
	SHLD	FBOTY
	XCHG
	LHLD	Y1MIN
	CALL	CMPDH
	JNC	DOFJ03
	SHLD	FBOTY	;Bottom Y - either bottom of band or bottom of shape
DOFJ03
	LHLD	FTOPY
	XCHG
	LHLD	Y2MAX
	CALL	CMPDH
	JC	DOFJ04
	SHLD	FTOPY	
	XCHG
DOFJ04
	LHLD	FBOTY
	SHLD	FILLY
	CALL	SUBDH
	INX	H
	SHLD	FILLH	
;
; Do the fill calculation for each line
;
DOFL01
	LDA	GDPOP
	ORA	A
	JZ	DOFJ05	;GDP bar, so all lines the same width
	MVI	A,1
	STA	B24DE
	JMP	DOFJ11
;
DOFJ05
	XRA	A
	STA	W24D6
	LDA	NPT
	STA	NPT1
	LHLD	BNEXT1
	SHLD	BNEXT
	LHLD	BYTND1
	SHLD	BYTNDX
	CALL	GETXY
	XCHG
	SHLD	FBARX1
	MOV	H,B
	MOV	L,C
	SHLD	FBARY
DOFL02
	CALL	GETXY
	XCHG
	SHLD	FBARX2
	MOV	D,B
	MOV	E,C
	LHLD	FILLY
	XCHG
	SHLD	FBARY2
	CALL	SUBDH	;Height of bar
	SHLD	FBARH
	RAR
	ANI	80h
	STA	B24EE
	LHLD	FILLY
	XCHG
	LHLD	FBARY
	CALL	SUBDH
	RAR
	ANI	80h
	MOV	B,A
	LDA	B24EE
	CMP	B
	JZ	DOFJ10
	LHLD	FBARY
	XCHG
	LHLD	FBARY2
	CALL	SUBDH
	SHLD	W24EC
	MOV	A,H
	ORA	L
	JZ	DOFJ10
	LHLD	FBARX1
	XCHG
	LHLD	FBARX2
	CALL	SUBDH
	RAR
	ANI	80h
	MOV	B,A
	JZ	DOFJ06
	CALL	NEGHL
DOFJ06
	SHLD	FBARW
	LHLD	FBARH
	MOV	A,H
	ANI	80h
	JZ	DOFJ07
	XRA	B
	MOV	B,A
	CALL	NEGHL
DOFJ07
	PUSH	B
	MOV	B,H
	MOV	C,L
	LHLD	FBARW
	PUSH	H
	CALL	MUL32
	POP	B
	PUSH	H
	LHLD	W24EC
	MOV	A,H
	ANI	80h
	JZ	DOFJ08
	XRA	B
	MOV	B,A
	CALL	NEGHL
DOFJ08
	PUSH	B
	MOV	B,H
	MOV	C,L
	XCHG
	DAD	H
	XCHG
	POP	H
	XTHL
	MOV	A,L
	ADC	A
	MOV	L,A
	MOV	A,H
	ADC	A
	MOV	H,A
	INX	D
	CALL	DIV32
	XRA	A
	MOV	A,D
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	XCHG
	POP	B
	MOV	A,B
	ORA	A
	JZ	DOFJ09
	CALL	NEGHL
DOFJ09
	XCHG
	LHLD	FBARX2
	DAD	D
	XCHG
	LHLD	W24D6
	INX	H
	SHLD	W24D6
	DCX	H
	DAD	H
	LXI	B,X1MIN2
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
DOFJ10
	LDA	NPT1
	DCR	A
	STA	NPT1
	LHLD	FBARX2
	SHLD	FBARX1
	LHLD	FBARY2
	SHLD	FBARY
	JNZ	DOFL02
	LDA	W24D6	;Count of intersections?
	CPI	2
	JC	DOFJ16
	CALL	X14AB	
	LDA	W24D6
	INR	A
	ANI	0FEh
	RRC	
	STA	B24DE
DOFJ11
	LXI	H,X1MIN2
DOFJ12
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	PUSH	H
	MOV	H,B
	MOV	L,C
	CALL	CMPDH
	JNC	DOFJ15
	SHLD	X2
	SHLD	XN
	XCHG
	SHLD	X1
	SHLD	X0
	MOV	A,L
	STA	B24E8
	LHLD	FILLY
	SHLD	Y0
	SHLD	Y1
	SHLD	Y2
	SHLD	YN
	MOV	A,L	;Look up correct row of pattern
	ANI	7
	MOV	L,A	;based on current Y coordinate
	MVI	H,0
	XCHG
	LHLD	FHATCH
	DAD	D
	MOV	A,M
	STA	FSHADE
	LDA	B24E8
	ANI	7
	ORA	A
	MOV	C,A
	LDA	FSHADE
	JZ	DOFJ14
DOFJ13
	RLC
	DCR	C
	JNZ	DOFJ13
DOFJ14
	MOV	H,A
	MOV	L,A
	SHLD	LSTYLE
	SHLD	SPECIL
	XRA	A
	STA	ABOVE
	CALL	DRAWXY
DOFJ15
	POP	H
	LDA	B24DE
	DCR	A
	STA	B24DE
	JNZ	DOFJ12
DOFJ16
	LHLD	FILLY
	INX	H
	SHLD	FILLY
	LDA	FILLH
	DCR	A
	STA	FILLH
	JNZ	DOFL01	

;----------------------------------------------------------------------------+
;        Draw fill border                                                    +
;----------------------------------------------------------------------------+
DOFBDR
	LDA	FILLMODE	;Draw solid lines in fill colour
	STA	DRAWMODE
	LDA	FILLBIT
	STA	DRAWBIT
	XRA	A
	STA	NDLNTY
	LHLD	BNEXT1		;Rewind metafile to the points for the 
	SHLD	BNEXT		;border
	LHLD	BYTND1
	SHLD	BYTNDX
	LDA	NPT
	INR	A
	CALL	DRAWIT		;Draw the border
	LHLD	BNEXT2		;Return metafile to previous position
	SHLD	BNEXT	
	LHLD	BYTND2
	SHLD	BYTNDX

	

;----------------------------------------------------------------------------+
;        Restore Line style & colour                                         +
;----------------------------------------------------------------------------+
DOFJ99
         LDA	SLNCO
	 STA	NDLNCO
	 LDA    LNTY
         STA    NDLNTY
	 LHLD	SLSTYLE
	 SHLD	LSTYLE	
         RET

X14AB
	DCR	A
	STA	B24D8
L14AF
	MVI	A,1
	STA	B24DA
	LXI	H,X1MIN2
	SHLD	W24EA
L14BA
	LHLD	W24EA
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	CALL	CMPDH
	JC	L14DC
	XCHG
	PUSH	H
	LHLD	W24EA
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	DCX	H
	JMP	L14E1
L14DC
	LHLD	W24EA
	INX	H	
	INX	H	
L14E1
	SHLD	W24EA
	LDA	B24DA
	INR	A
	STA	B24DA
	MOV	B,A
	LDA	B24D8
	CMP	B
	JNC	L14BA
	DCR	A
	STA	B24D8
	JNZ	L14AF
	RET

	 dseg
GDPOP	 ds	01
PLINE2	 ds	02
X1MIN2	 ds	02
X2MAX2	 ds	200

NPT      DS     1                ;No. of points
	 DS	1
X1MIN	 DS	2		 ;Polygon Min/Max Extents
Y1MIN	 DS	2
X2MAX	 DS	2
Y2MAX	 DS	2
FILLH	 DS	2		 ;Height of area to fill
BNEXT1	 DS	2		 ;Save positions in the metafile
BNEXT2	 DS	2
BYTND1	 DS	2
BYTND2	 DS	2
SLSTYLE	 DS	2
SLNCO	 DS	2
FILLY	 DS	2
FBOTY	 DS	2		;Bottom line of area to fill
FTOPY	 DS	2		;Top line of area to fill
FBARX1	 DS	2
FBARY	 DS	2
FBARX2	 DS	2
FBARY2	 DS 	2
W24D6	 DS	2
B24D8	 DS	2
B24DA	 DS 	2
NPT1	 DS	2
B24DE	 DS	2
FHATCH	 DS	2
FBARH	 DS	2
FBARW	 DS	2
FSHADE	 DS	2
B24E8	 DS	2
W24EA	 DS	2
W24EC	 DS	2
B24EE	 DS	1
LNTY     DS     1
	cseg 
 
         END

