
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."

	TITLE	'MATHEMATICS SUBROUTINES'

	PUBLIC	MUL32,DIV32

;
; [DDFHXHR8] These functions are not present in DDMX
;
; MUL32 multiplies two 16-bit numbers together (in BC and at top of stack)
; and returns a 32-bit result in HLDE.
;
MUL32	
	POP	H
	XTHL		;Shuffle the stack so parameter is below return address
	PUSH	H
	MVI	A,16	;Process 16 bits of arguments
	STA	M32BITS
	XRA	A	;Start off with carry 0
	LXI	H,0
	LXI	D,0	;And result 0
M32L01
	MOV	A,B	;Rotate BC to the right.
	RAR		
	MOV	B,A
	MOV	A,C
	RAR
	MOV	C,A	;If the lowest bit was set...
	JNC	M32J02
			;Then add the word on top of the stack to the 
			;high word of the result. Thus:
			;At start: HL=total_h  DE=total_l  SP->argument
	XCHG		;          HL=total_l  DE=total_h  SP->argument
	XTHL		;          HL=argument DE=total_h  SP->total_l 
	XCHG		;          HL=total_h  DE=argument SP->total_l
	DAD	D	;          HL=newtotal DE=argument SP->total_l
	XCHG		;          HL=argument DE=newtotal SP->total_l
	XTHL		;	   HL=total_l  DE=newtotal SP->argument
	XCHG		;	   HL=newtotal DE=total_l  SP->argument
M32J02
	MOV	A,H	;Now rotate HLDE right, with any carry from the add
	RAR		;moving into HL at the top
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	MOV	A,D
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	LDA	M32BITS	;And do that over 16 bits
	DCR	A
	STA	M32BITS
	JNZ	M32L01
	INX	SP	;Finally discard the multiplicand from the stack
	INX	SP
	RET
;
; Divide ?HLDE by BC. 
;
DIV32
	MOV	A,C
	ORA	B
	JNZ	D32J01	
	JMP	D32J99	;Can't divide by zero
;
D32J01
	MOV	A,B	;Let BC = -BC
	CMA
	MOV	B,A
	MOV	A,C
	CMA
	MOV	C,A
	INX	B	;2s complement
	MVI	A,17	;16 bits and one carry
D32L01
	DCR	A
	JNZ	D32J02
	XCHG		;Um, why? D32J98 just reverses this swap
	JMP	D32J98
;
D32J02
	DAD	H	;Rotate DEHL to the left
	JC	D32J05
	XCHG		;No carry from HL, so can double DE without
	DAD	H	;worrying about carry
	XCHG
	JNC	D32J03
	INR	L	;Bring the top bit of D into the bottom of L
D32J03	
	PUSH	H
	DAD	B
	JC	D32J04
	POP	H	;No overflow.
	JMP	D32L01
D32J04
	INR	E	;Overflow. Increase quotient
	INX	SP	;And discard altered HL
	INX	SP	
	JMP	D32L01

D32J05
	XCHG
	DAD	H
	XCHG
	JNC	D32J06
	INR	L
D32J06
	DAD	B
	INR	E
	JMP	D32L01

D32J98	XCHG	
D32J99	RET

	DSEG
M32BITS	DS	2	;Bit counter for 32-bit multiplication
	CSEG


