
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."
 
         TITLE   'BITMAP SCAN AND DISPLAY OUTPUT PROCESSOR'
 
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ;                                                                          ;
; ;  SCANER : SCAN AND OUTPUT one 'PLOT STRIP' from BITMAP to PRINTER        ;
; ;                                                                          ;
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Revision : NOV. 14, 1982    File "SCANMX80.ASM"  Version 1.0              ;
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            *
;      1) BITMAP BUFFER EMPTY FLAG  11/3                                     *
;      2) Check BITMAP EMPTY FLAG : If set, then Call GLF (<cr><lf>)         *
;      3) Zero the 8th bit in graphic byte for Epson                         *
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            ;
;  Scaner (pline, xw)                                                        ;
;                                                                            ;
;  Function : SCAN and OUTPUT entire 'PLOT STRIP' from BITMAP to PRINTER.    ;
;                                                                            ;
;             Actually sets up the bit patterns in graphic byte              ;
;             format and output to the printer byte by byte                  ;
;                                                                            ;
;               for j = 1 to pline   ;loop to output one strip               ;
;                 {for i = 1 to xw   ;  loop to output one line              ;
;                   { call bytout }  ;      transpose and output one byte    ;
;                  output GLF }      ;  Graphic LineFeed                     ;
;                                                                            ;
;  Input   : PLINE  - No. of print lines per plot strip                      ;
;            XW     - No. of bytes per print line                            ;
;            LSIZE  - Offset to the start of next line to output in Bitmap   ;
;                                                                            ;
;  Output  : None                                                            ;
;                                                                            ;
;  Calls   : BYTOUT - Transpose and output one byte to printer               ;
;            POUT   - Output one byte to printer port (CALL BDOS)            ;
;                                                                            ;
;----------------------------------------------------------------------------;
;
;  CALL SCANER
;  RET
;
         PUBLIC SCANER
         EXTRN  POUT, GENTER, GLF1, GLF2
         EXTRN  ABSHL, NEGHL, SUBDH, CMPS, CMPDH, MIDH, DIDH, IMOD
 
         EXTRN  BITMAP, MAPEND, MPTY, GLINEW
         EXTRN  XW, XW8, NEGXW, YW, PLINE, NSTRIP, LSIZE
         EXTRN  XMAX, YMAX, XMIN, YMIN, NEGXW8
 
;----------------------------------------------------------------------------+
;        PRINTER CONSTANTS (EPSON FX-80)
;----------------------------------------------------------------------------+
 
PIXL     EQU    8                ;8 pixels printed per graphic byte
ESC      EQU    1BH              ;Escape Code
         page

LINEW	 DS	04
PPASS0	 DS	02
PPASS1	 DS	02
PPASS2	 DS	02
PPASS	 DS	01
 
SCANER
	 LHLD	NEGXW		; [DDFXHR8] This is all new, because of the
	 DAD	H		; 2-pass printing method
	 SHLD	PPASS1
	 XCHG
	 LHLD	NEGXW8
	 DAD	H
	 XCHG
	 CALL	SUBDH
	 SHLD	PPASS2
	 MVI	A,2
	 STA	PPASS		;Print 2 passes
         LHLD   MAPEND           ;<HL> = first byte address in bitmap
                                 ;       to start scanning bit pattern
         MOV    B,     H         ;PLINE = Outer loop count
         MOV    C,     L
         LHLD   PLINE            ;No. of Print Lines per Strip

;        for j = 1 to pline
 
JLOOP
;        If BITMAP is EMPTY, SKIP SCANNING ENTIRE LINE
	 PUSH	H 
         LDA    MPTY
         ORA    A
         JNZ    ILOOP0
         CALL   PBEGIN
         JMP    JLOOP9
 
ILOOP0
	 LHLD	XW8
	 SHLD	LINEW
	 PUSH	B
	 LHLD	LINEW
	 SHLD	GLINEW
         CALL   GENTER           ;Tell the Printer No. of Graphic Bytes
                                 ;to Expect
         LHLD   XW               ;No. of bytes per single pixel Print Line
         POP	D                ;XW = Inner loop count
;        for i = 1 to xw
 
ILOOP    PUSH   H                ;Save byte count
         CALL   BYTOUT           ;Invert and Print one byte, byte address in D
         POP    H
         INX    D                ;Point to next byte in BITMAP
;                                  ** BYTOUT returns DE unchanged **
         DCX    H                ;Decrement byte count
         MOV    A,     H         ;Any more bytes ?
         ORA    L
         JNZ    ILOOP            ;Yes, Do next byte
	 MOV	B,D
	 MOV	C,E
	 CALL	PBEGIN 
JLOOP9
         POP    H                ;Get Line count
         DCX    H                ;Decrement line count, Done yet?
         MOV    A,     H
         ORA    L
         RZ                      ;Yes, Return
	 
;        No, Update the BITMAP address pointer to start of next Print Line
	
	 XCHG
	 LHLD	PPASS0
	 DAD	B
	 MOV	B,H
	 MOV	C,L 
         XCHG                    ;Address pointer in DE
         JMP    JLOOP            ;Go do another line
;
; Start of a pass
;
PBEGIN	LDA	PPASS
	DCR	A
	STA	PPASS
	JZ	PBGJ01
	CALL	GLF2
	LHLD	PPASS1
	JMP	PBGJ02

PBGJ01	CALL	GLF1
	MVI	A,2
	STA	PPASS
	LHLD	PPASS2
PBGJ02	
	SHLD	PPASS0
	RET

 
         page
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ;                                                                          ;
; ;  BYTOUT : SCAN OUTPUT one BYTE from BITMAP to PRINTER                    ;
; ;                                                                          ;
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  bytout (nbyt)                                                             ;
;                                                                            ;
;  Function : SCAN and OUTPUT one BYTE from BITMAP to PRINTER                ;
;                                                                            ;
;             Mask out PIXL bytes of bit pattern from BITMAP (starting       ;
;             at NBYT) into graphic byte format befor output to printer      ;
;                                                                            ;
;             PIXL = No. of bits printed in each graphic byte                ;
;                    Datasouth = 6, Prism = 7                                ;
;               for i= 1 to 8 {                                              ;
;                   set mask                                                 ;
;                   call mskout(mask,byte)                                   ;
;                   output byte }                                            ;
;                                                                            ;
;  Input    : NBYT  - Starting byte position in BITMAP buffer                ;
;                                                                            ;
;  Calls    : MSKOUT - Get the desired bits from BITMAP                      ;
;             POUT   - Output one byte to printer port (BDOS function)       ;
;                                                                            ;
;----------------------------------------------------------------------------;
;
;  CALL BYTOUT
;    DE = NBYT, start address in BITMAP
;  RET
;    DE = Unchanged
;
BYTOUT
          LXI  H,   0801H     ;H=loop count, L=shift count
                              ;  shift count used by MSKOUT to rotate
                              ;  the result to printer print wire position
 
          MVI  B,   80H       ;Initialize the bit mask
 
REPEAT    MVI  C,   PIXL      ;No. of bits to Mask out
 
          PUSH D              ;Save BITMAP start address pointer NBYT
          PUSH H              ;Save counters
          CALL MSKOUT         ;Get the desired bits from BITMAP
          CALL POUT           ;Output the byte to printer
          POP  H
          POP  D              ;Restore the address pointer for MSKOUT
 
          MOV  A,   B         ;Update the bit mask to next bit position
          RRC
          MOV  B,   A
          INR  L              ;Update the shift correction count
          DCR  H              ;One more byte moved
          JNZ  REPEAT         ;Done yet ?
          RET                 ;Yes
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Mskout (nbyt, nbit, result)                                               ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Function : Mask out PIXL bits from BITMAP Buffer into one                 ;
;             printer output byte (RESULT)                                   ;
;             one bit is masked out of bytes BITMAP(nbyt), BITMAP(nbyt-      ;
;             XW*1),..., BITMAP(nbyt-XW*PIXL)                                ;
;             PIXL = No. of bits printed in each graphic byte                ;
;                   Datasouth = 6, Prism = 7                                 ;
;               for i = 1 to pixl {                                          ;
;                 bit = bitmap(nbyt) ^ mask                                  ;
;                 byte = (byte v bit)                                        ;
;                 shift byte left to make room for next bit                  ;
;                 nbyt = nbyt - (xw * pixl)  }                               ;
;                                                                            ;
;  Input    : NBYT   - Byte position to start transposing                    ;
;             NBIT   - Bit position to transpose from BITMAP                 ;
;             XW     - No. of bytes per print line (row order in buffer)     ;
;                      used to calculate offset to the same byte in next line;
;             PIXL   - No. of bits to transpose until final result           ;
;                                                                            ;
;  Output   : RESULT - Printer graphic byte with bit pattern transposed      ;
;                      from BITMAP                                           ;
;                                                                            ;
;  Calls    : None                                                           ;
;                                                                            ;
;----------------------------------------------------------------------------;
;
;  CALL MSKOUT
;    DE = NBYT, start address
;    B  = NBIT, mask
;    C  = PIXL, loop count
;    L  = Count to shift bits into correct print wire position
;  RET
;    A  = RESULT, on 'RETURN'
;    B  = unchanged mask
;    All other reg clubbered
;
;
MSKOUT
          PUSH H              ;Save away shift counter
          XCHG                ;HL points to NBYT address
          XRA  A              ;Clear work reg
 
AGAIN     RLC                 ;Make room for next bit
          MOV  E,   A         ;Save temp result
 
          MOV  A,   M         ;Get next byte from BITMAP
          ANA  B              ;Leave only the desired bit
          ORA  E              ;Combine with temp result
          XCHG                ;Current NBYT address pointer in DE
 
          LHLD PPASS1         ;Get Offset to same byte in next line
          DAD  D              ;HL Points to next byte
          DCR  C              ;Done yet ?
          JNZ  AGAIN          ;No, continue
;
;  The resulting bit pattern still needs to be rotated into correct
;  Printer wire position : LSB bits
;
          POP  H              ;Get the shift count
ROTA      RLC                 ;Rotate bits until correct position
          DCR  L
          JNZ  ROTA           ;Done yet ?
;;; [DDFXHR8 doesn't]
;;;          ani  7fh            ;Zero 8th Bit
 
          RET                 ;Return with result in A
 
          END
 
