;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."

         TITLE 'GENERALIZED DRAWING PRIMITIVE: BAR'
 
;*****************************************************************************
;                                                                            *
;        GDP      : Increment Object Count, Update XMAX and YMAX and         *
;                   Store Opcode, Npt, Px and Py in Object List Buffer       *
;                                                                            *
;*****************************************************************************
;                                                                            *
;  REVISION : NOV.  09, 1982      File "ZGDP.ASM"                            *
;                                                                            *
;  Zgdp                                                                      *
;                                                                            *
;  Description :                                                             *
;                                                                            *
;    1) Get Opcode from Contrl array and store in OBJLST Buffer              *
;                                                                            *
;    2) Increment OBJCNT                                                     *
;                                                                            *
;    3) Get Points from PTSIN array, Update Max/Min Plot extent XMAX,YMAX    *
;                                                                            *
;    4) Store the Points in OBJLST Buffer                                    *
;                                                                            *
;                                                                            *
;  Input :                                                                   *
;        contrl(1) - opcode =  11                                            *
;        contrl(2) - no. of (x,y) pairs in polyline (npt)                    *
;        ptsin     - corners of the bar in pixel space                       *
;                    ptsin(1,2) = x1,y1                                      *
;                    ptsin(3,4) = x2,y2                                      *
;                                                                            *
;  Output :                                                                  *
;        contrl(3) - 0                                                       *
;                                                                            *
;  CALL ZGDP                                                                 *
;                                                                            *
;  Program Variables :                                                       *
;        XMAX   - Maximum Plot extent x-axis                                 *
;        YMAX   - Maximum Plot extent y-axis                                 *
;        OBJCNT - Count of Object in the Object List Buffer                  *
;        OBJLST - Object List Buffer                                         *
;                                                                            *
;  Calls :                                                                   *
;        GETPT  - Get coord. from PTSIN array                                *
;        PUTPT  - Put coord. into OBJLST buffer                              *
;        PUTBYT - Puts byte into the OBJLST buffer                           *
;        GETMAX - Returns the larger value of the <hl>, <de> in <hl>         *
;                                                                            *
;*****************************************************************************
 
         PUBLIC ZBAR, ZRECT
         EXTRN  GETPT, PUTPT, CMPDH, GETMAX, PUTBYT
         EXTRN  CONTRL, INTIN, PTSIN, INTOUT, PTSOUT
         EXTRN  XMAX, YMAX, OBJCNT, OBJLST, PTADDR
	 EXTRN	FCOL 

ZBAR
	 LDA 	FCOL		 ; Would bar be drawn?
	 ORA	A
	 RZ

	 MVI	A,11		 ; Bar opcode
	 CALL	PUTBYT
	 MVI	A,1
	 CALL	PUTBYT
	 MVI	A,4		 ; 4 points giving the corners
	 CALL	PUTBYT
	 MVI	A,1Ch
ZRECT
	 STA	BARTYP
         LHLD   OBJCNT           ;Increment OBJCNT
         INX    H
         SHLD   OBJCNT
 
;----------------------------------------------------------------------------+
;        Get the vertices from PTSIN array                                   +
;        Update XMAX,YMAX and store the points in OBJLST                     +
;----------------------------------------------------------------------------+
 
;        Get the Address of PTSIN array
 
;        <a> = No. of points in PTSIN
 
         LHLD   PTSIN
         SHLD   PTADDR
	 LXI	H,RECTBF	 ;[DDFXHR8] Buffer for temporary rect
	 SHLD	RECTPX
 
         MVI    A,    2          ; Get two points
ZPLL01   PUSH   PSW              ;Save Npt on stack
         CALL   GETPT            ;Returns <de> = X-coord.
         LHLD   XMAX
         CALL   GETMAX
         SHLD   XMAX             ;<HL> = XMAX
 
ZPLJ01   CALL   RECTPT            ;Store x-coord. into OBJLST
 
         CALL   GETPT            ;Returns <de> = Y-coord.
                                 ;<bc> = address of next point in PTSIN
         LHLD   YMAX
         CALL   GETMAX
         SHLD   YMAX             ;YMAX = <HL>
 
ZPLJ02   CALL   RECTPT           ;Store y-coord. into OBJLST, returns
                                 ;NXTOBJ points to next location in OBJLST
         POP    PSW
         DCR    A
         JNZ    ZPLL01           ;There are more points in PTSIN
;
; Now generate the coordinates of all four corners in RECTBF2
;
	 LHLD	RECTBF
	 MOV	E,H
	 MOV	D,L
	 LXI	H,RECTBF2
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	B,RECTBF2
	 LXI	H,12
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,16
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,20
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 
	 LHLD	RECTBF+2
	 MOV	E,H
	 MOV	D,L
	 LXI	H,2
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,6
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,18
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,22
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E

	 LHLD	RECTBF+4
	 MOV	E,H
	 MOV	D,L
	 LXI	H,4
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,8
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,24
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E

	 LHLD	RECTBF+6
	 MOV	E,H
	 MOV	D,L
	 LXI	H,10
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,14
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E
	 LXI	H,26
	 DAD	B
	 MOV	M,D
	 INX	H
	 MOV	M,E

	 LXI	H,RECTBF2 ;Now the five coordinate pairs have been generated,
	 SHLD	RECTPX	  ;write them out to the metafile
;
ZPLL02:	 LHLD	RECTPX
	 MOV	A,M
	 INX	H
	 SHLD	RECTPX
	 CALL	PUTBYT
	 LDA	BARTYP
	 DCR	A
	 STA	BARTYP
	 JNZ	ZPLL02
         RET
;
RECTPT
	LHLD	RECTPX		;Store value DE in the buffer at RECTPX
	MOV	M,D		;and advance RECTPX
	INX	H
	MOV	M,E
	INX	H
	SHLD	RECTPX
	RET

	DSEG
RECTBF	DS	8
RECTBF2	DS	30
BARTYP	DS	2
RECTPX	DS	2
	CSEG 
 
         END
 
 
 
 
