 
;
; Open source per <http://www.cpm.z80.de/license.html>:
;
; "Let this paragraph represent a right to use, distribute, modify, enhance, 
; and otherwise make available in a nonexclusive manner CP/M and its 
; derivatives. This right comes from the company, DRDOS, Inc.'s purchase of 
; Digital Research, the company and all assets, dating back to the mid-1990's. 
; DRDOS, Inc. and I, Bryan Sparks, President of DRDOS, Inc. as its 
; representative, is the owner of CP/M and the successor in interest of 
; Digital Research assets."

         TITLE 'CELL ARRAY'
 
;*****************************************************************************
;                                                                            *
;        GDP      : Increment Object Count, Update XMAX and YMAX and         *
;                   Store Opcode, Px1, Py1, px2, py2 in Object List Buffer   *
;                                                                            *
;*****************************************************************************
;                                                                            *
;  REVISION : NOV.  10, 1982      File "ZCELL.ASM"                           *
;                                                                            *
;  ZCELL                                                                     *
;                                                                            *
;  Description :                                                             *
;                                                                            *
;    1) Get Opcode from Contrl array and store in OBJLST Buffer              *
;                                                                            *
;    2) Increment OBJCNT                                                     *
;                                                                            *
;    3) Get Points from PTSIN array, Update Max/Min Plot extent XMAX,YMAX    *
;                                                                            *
;    4) Store the Points in OBJLST Buffer                                    *
;                                                                            *
;                                                                            *
;  Input :                                                                   *
;        contrl(1) - opcode =  11                                            *
;        ptsin     - corners of the Cell array in pixel space                *
;                    ptsin(1,2) = x1,y1                                      *
;                    ptsin(3,4) = x2,y2                                      *
;                                                                            *
;  Output :                                                                  *
;        contrl(3) - 0                                                       *
;                                                                            *
;  CALL ZCELL                                                                *
;                                                                            *
;  Program Variables :                                                       *
;        XMAX   - Maximum Plot extent x-axis                                 *
;        YMAX   - Maximum Plot extent y-axis                                 *
;        OBJCNT - Count of Object in the Object List Buffer                  *
;        OBJLST - Object List Buffer                                         *
;                                                                            *
;  Calls :                                                                   *
;        PUTBYT - Puts byte into the OBJLST buffer                           *
;        ZRECT  - Common code for GDP bar and cell array bar                 *
;                                                                            *
;*****************************************************************************
 
         PUBLIC ZCELL
         EXTRN  ZRECT,LCOL,PUTBYT
 
;----------------------------------------------------------------------------+
;        Increment OBJCNT                                                    +
;        Store Opcode and Npt in OBJLST                                      +
;----------------------------------------------------------------------------+
 
ZCELL
;        Get Opcode, Contrl = Address of Contrl array

	 LDA	LCOL
	 ORA	A
	 RZ
	 MVI	A,10 
         CALL   PUTBYT          ; Store the Cell opcode away
	 MVI	A,5		; 5 points giving an outline
	 CALL	PUTBYT		; [DDFXHR8] Now share common rectangle code
	 MVI	A,20		; with the bar
	 CALL	ZRECT
	 RET
 
         END
