/* EXEBODGE v1.00 by John Elliott, 11 October 2003. Public Domain Software. */

#include <stdio.h>
#include <string.h>

typedef unsigned char byte;

byte exe_header[32];
char *fnin, *fnout;
FILE *fpin, *fpout;

int transfer(unsigned long count)
{
	while (count)
	{
		int c = fgetc(fpin);
		if (c == EOF) 
		{
			fprintf(stderr, "%s: Unexpected end of file\n", fnin);
			return 1;
		}
		c = fputc(c, fpout);
		if (c == EOF)
		{
			fprintf(stderr, "%s: Error writing to file\n", fnout);
			return 2;
		}
		--count;
	}
	return 0;
}


unsigned peek(int n)
{
	unsigned r = exe_header[n+1];
	r = r << 8 | exe_header[n];
	return r;
}

void poke(int n, unsigned v)
{
	exe_header[n+1] = (v >> 8) & 0xFF;
	exe_header[n]   = v & 0xFF;
}


int convert(void)
{
	unsigned long exe_size;
	unsigned correction;
	unsigned header_paras, old_header_paras;
	int r;
	
	if (fread(exe_header, 1, sizeof(exe_header), fpin) < (int)sizeof(exe_header) 
    || (memcmp(exe_header, "MZ", 2) && memcmp(exe_header, "ZM", 2)))
	{
		fprintf(stderr, "%s: File is not in EXE format\n", fnin);
		return 1;
	}
	/* Workaround for broken MS-LINK versions */
	if (peek(2) == 4) poke(2, 0);	
	/* Get file size */
	exe_size = 512L * peek(4);
	if (peek(2)) exe_size -= (512 - (peek(2) & 0x1FF));

	/* Work out correction */
	header_paras = peek(8);
	old_header_paras = header_paras;
	correction = 0;
	while (header_paras & 0x1F)
	{
		correction += 16;
		++header_paras;
		exe_size += 16;
	}
	/* Write back new header */
	poke(4, (exe_size + 511L) / 512L);
	poke(2, (exe_size % 512));
	if (peek(2) == 4) poke(2,5);
	poke(8, header_paras);
	if (fwrite(exe_header, 1, sizeof(exe_header), fpout) < (int)sizeof(exe_header))
	{
		fprintf(stderr, "%s: Write error\n", fnout);
		return 2;
	}
	/* Copy the old header */
	r = transfer(16 * (old_header_paras - 2));
	if (r) return r;
	/* Packing bytes */
	while (correction)
	{
		if (fputc(0, fpout) == EOF)
		{
			fprintf(stderr, "%s: Error writing to file\n", fnout);
			return 2;
		}
		--correction;
	}
	/* Copy all remaining bytes */
	while ((r = fgetc(fpin)) != EOF)
	{
		if (fputc(r, fpout) == EOF)
		{
			fprintf(stderr, "%s: Error writing to file\n", fnout);
			return 2;
		}		
	}
	return 0;
}



int main(int argc, char **argv)
{
	int r;

#ifdef __PACIFIC__
	if (argc < 3)
	{
		fprintf(stderr, "Syntax: EXEBODGE infile.EXE outfile.EXE\n");
		return 1;
	}
#endif
	if (argc < 2) 
	{
		fpin = stdin;
		fnin = "Standard input";
	}
	else
	{
		fnin = argv[1];
		fpin = fopen(fnin, "rb");
		if (!fpin)
		{
			perror(fnin);
			return 1;
		}
	}
	if (argc < 3) 
	{
		fpout = stdout;
		fnout = "Standard output";
	}
	else
	{
		fnout = argv[2];
		fpout = fopen(fnout, "wb");
		if (!fpout)
		{
			perror(fnout);
			fclose(fpin);
			return 2;
		}
	}
	r = convert();
	fclose(fpout);
	fclose(fpin);
	return r; 
}

