;
; EXEFIX: A TSR that patches the EXE loader in DOS Plus, so that it supports
; executables produced by PKLITE, Pacific C, etc.
;
; This is a TSR, so it has to be run in the DOS subsystem of DOS Plus. For
; economy of storage space, it needs to be a .COM file.
;
; EXEFIX is public domain software.
;
; The toolchain this was built with is:
;
; Arrowsoft Assembler
; Microsoft Linker
; DRDOS EXE2BIN
;
; because:
; * EXEs generated with RASM86/LINKEXE are really CMD files wrapped in an EXE 
;  loader. This loader does not seem to get on well with DOSPLUS, because
;  ES ends up pointed at a CP/M Zero Page rather than a DOS PSP. That's a 
;  topic for another day. Plus that's serious bloat when you want a minimal
;  TSR.
;
; * VAL (the companion linker to Arrowsoft ASM) does not seem to be fully
;  DOSPLUS compatible, so MS-Link was used.
;
; * EXE2BIN is PKLITE-compressed, so DOS Plus can't actually load it without
;  this patch being present (chicken and egg situation). I therefore modified
;  my copy with EXEBODGE 
;  <http://www.seasip.demon.co.uk/cpm/software/cpm86.html> so that it can 
;  be loaded on an unpatched DOS Plus.
;
; The build commands are:
; 
;; asm.exe exefix exefix nul nul
;; link exefix,,,,
;; exe2bin exefix
;
cr	equ	0dh
lf	equ	0Ah

CodeSeg	SEGMENT
	ASSUME	CS:CodeSeg, DS:CodeSeg, ES:CodeSeg

	org	02Ch
environ	label	word	;Environment segment
	
	org	0100h
;
; Jump over the resident portion to the initialisation code.
;
begin	proc	near
	jmp	init
begin	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; BEGINNING OF TSR SECTION
;
; What's wrong with the DOSPLUS EXE loader: 
; 
; The DOSPLUS EXE loader works out the size of the EXE header in 128-byte 
; records (so we're sunk in the case of EXEs with headers that aren't an 
; exact multiple of 128 bytes). But it gets worse than that. It actually 
; divides the header size by 512 and then multiplies by 4. 
;
; The code that does this is at DOS_CS:026Ch:
;
;	AX = header size, paras
;	mov	dx,10h
;	mul	dx	;header size, bytes
;	mov	cx,200h	
;	div	cx	;header size, pages
;	mov	cx,4
;	mul	cx	;header size, records
;
; (byte pattern: BA 10 00 F7 E2 B9 00 02 F7 F1 B9 04 00 F7 E1)
;
; Fix number 0: Stop losing accuracy in the conversion from paras to 
; records. Replace the last 4 lines with:
;
;	mov	cx,80h
;	div	cx
;	nop!nop!nop!nop!nop
;
; (byte pattern: BA 10 F7 E2 B9 80 00 F7 F1 90 90 90 90 90)
;
; Fix number 0 can be done in-place, and does not need resident code. 
;
; Fix number 1: For EXEs whose headers are not an exact multiple of 128
; bytes, the last (header_size % 128) bytes of the header have been 
; loaded. Therefore after the EXE image has loaded, remove these bytes by 
; copying the memory image down over them. Patch the code at DOS_CS:02D5h,
; which is run after EXE load but before relocations are done:
;
;	mov	word ptr [0226h],1
;
; and add a routine to do the memory move. This is where the TSR comes in.
;
patch1	proc	far
	mov	ax,exe_head_paras
	and	ax,07h			;NB: If we had not done fix number 0,
					;this would be AND AX,1Fh
	jz	noround			;If header is a multiple of 128 bytes, 
					;then no relocation
	mov	bx,exe_body_base	;Segment at which file was loaded
	add	ax,bx			;BX = destination segment
					;AX = source segment
	mov	cx,exe_body_paras	;CX = count of paragraphs to shift
	push	ds
	push	es			;Saving these registers may not be
	push	si			;necessary, but I'll do it anyway.
	push	di
	mov	ds,ax
	mov	si,0 			;DS:SI -> current program position
	mov	es,bx
	mov	di,0			;ES:DI -> where it should be
	cld				;For the MOVSW below

shift:	push	cx			;Move CX paragraphs
	mov	cx,8
	rep	movsw			;Move 1 paragraph
	pop	cx
	loop	shift

	pop	di			;Restore saved registers
	pop	si	
	pop	es
	pop	ds	
	
noround:
	mov	dos_exe_recno, 1	;Original code that was replaced
	ret				;with a call to this patch
patch1	endp
;
; Fix number 2: The amount of memory allocated for the program the does not 
; include whatever header fragment is being loaded. The simple (if wasteful) 
; solution is to patch the memory allocation code as well, and make it take 
; the size of the header into account. The only other approach would be to 
; replace the loader wholesale with one that loads by paragraphs rather 
; than records, so that it doesn't overshoot the memory allocation.
;
; The memory allocation code we want is at DOS_CS:1B4h:
;
;	ADD	AX,BX		;AX = paragraphs in entire exe file
;	SUB	AX,[01A3h]	;    subtract paragraphs in header
;
; To get enough room for a far call, both of these instructions have to be
; replaced. 
;
patch2	proc	far
	add	ax,bx		;First original instruction
	push	bx
	mov	bx,exe_head_paras
;
; Only subtract those paragraphs which won't be loaded at all.
;
	and	bx,0FFF8h	;NB: If we had not done fix number 0,
				;this would be AND BX,0FFE0h
	sub	ax,bx
	pop	bx
	ret
patch2	endp
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CODE BELOW THIS LINE DOES NOT STAY RESIDENT
;
init	proc	near
;
; Our first challenge is to be sure we are running on a real DOS Plus, 
; since blindly patching the kernel of any other DOS is not likely to be 
; successful.
;
; Since DOS Plus claims to be MS-DOS 2.11, try the DOS version number first. 
;
	mov	ax,03000h
	int	21h
	cmp	ax,0B02h	; If not MS-DOS 2.11
	jnz	notdp		; then bail
;
; Now check if this is real MS-DOS, by looking for the InDOS flag. MS-DOS 
; has one; DOS Plus does not (it leaves all registers unchanged). 
;
	mov	bx,0
	mov	es,bx		; Initialise ES:BX to 0.

	mov	ah,34h		; Get address of InDOS flag
	int	21h
	mov	ax,es		; Is ES:BX still 0?
	or	ax,bx	
	jnz	notdp		; If not, this is real MS-DOS. 
;
; OK, it's not a real MS-DOS. Assume it's a DRI emulated DOS, and that we
; can use INT 0E0h. Check that the version numbers are those reported by
; DOS Plus v1.2.
;
; This also means, by the way, that if you are changing the DOS module of DOS
; Plus 1.x, I'd appreciate it if you would bump the MP/M version number.
;
	mov	cl,0Ch    	; Get CP/M version number
	int	0E0h        
	cmp	ax,1041h  	; BDOS version must match exactly
	jnz	notdp
    
	mov	cl,0A3h 	; Get MP/M version number
	int	0E0h	
	cmp	ax,1012h	; DOS Plus v1.2
	jz	isdp		
;
notdp:	mov	dx,offset notdpm
	mov	ah,9		; Not DOS Plus. We don't know if it's MS-DOS 1
	int	21h		; or 2 or what, so terminate using the DOS 1
	int	20h		; method.
;
; OK; it's DOS Plus. Find out where its DOS emulation module is. We know
; there is one (ie, that this isn't Personal CP/M-86 v2.0) because otherwise
; a .COM file like this wouldn't be in memory in the first place.
;
; But first, free the environment block. We don't need it and we don't want
; it left hanging around when we go resident.
;
isdp:
	call	freeenv		; Reduce environment

	mov	cl,9Ah          ; Get system data address
	int	0E0h            ; ES:BX -> System data
	mov	ax,es:42h[bx]   ; Get DOS code segment
;
; Check if there's already a jump to EXEFIX in the code. If so, assume that
; EXEFIX is already loaded and don't let it load another copy.
;
	mov	es,ax
	mov	al,es:[02D5h]
	cmp	al,09Ah		; See if our patch code is already in
	jz	ispatched
	mov	ax,cs		; Poke our code segment into the far call
	mov	fixcs1,ax	; instructions that we will use.
	mov	fixcs2,ax
;
; Apply fix 0: Calculate header size in records, not paras
;
	mov	di,0271h
	mov	si,offset fix0
	mov	cx,offset fix0e - offset fix0
	cld
	rep	movsb	;Copied patch into DOSPLUS

;
; Apply fix 1: relocate segments after load
;
	mov	di,02D5h
	mov	si,offset fix1
	mov	cx,offset fix1e - offset fix1
	rep	movsb	;Copied patch into DOSPLUS
;
; Apply fix 2: memory allocation
;
	mov	di,01B4h
	mov	si,offset fix2
	mov	cx,offset fix2e - offset fix2
	rep	movsb	
;
; All patches applied. Say so.
;
	mov	dx,offset okay
	mov	ah,9
	int	21h
;
; Calculate the size of the resident portion.
;
	mov	ax,offset init	;AX = size in bytes
	add	ax,0Fh
	ror	ax,1
	ror	ax,1
	ror	ax,1
	ror	ax,1
	and	ax,0FFFh	;AX = size in paragraphs
	mov	dx,ax
	mov	ax,3100h	;Terminate and Stay Resident
	int	21h
;
; Error exit: EXEFIX already loaded.
;
ispatched:
	mov	dx,offset isp
	mov	ah,9
	int	21h
	int	20h
;
init	endp
;
; Free the environment block. Then create a minimal environment containing
; the program name (in case MAPMEM happens to work under DOS Plus).
;
; (based on code in TSRINT by Robert Curtis Davis)
;
; NB: Under DOS Plus, both of these memory calls will in fact fail, because
; of the way the DOS memory management system is implemented on top of the 
; CP/M-86 memory management system. The environment, rather than being 
; allocated using DOS calls, is stored in the vestigial CP/M CCP, with
; a Memory Control Block of type 'm' or 'z' (as opposed to 'M' or 'Z')
; before it. Therefore attempts to free it will fail with error 7 
; (broken MCB). According to the Interrupt List, genuine MS-DOS never 
; returns this error, so that's another way to detect DOS Plus.
;
; The second (allocate) call fails because all the memory is already allocated
; to the COM file, and the first call didn't free anything up. 
;
freeenv	proc	near
	mov	es,environ
	mov	ah,49h
	int	21h		; Free existing environment
	jc	noenv

	mov	bx,1		; Allocate new environment
	mov	ah,48h
	int	21h
	jc	noenv		; Allocation failed

	mov	es,ax		; ES = new environment
	mov	si,offset envdata
	mov	di,0
	mov	cx,offset ede - offset envdata
	cld
	rep	movsb		;Initialised new environment
	mov	environ,es
noenv:	ret
freeenv	endp
;
; The false environment
;
envdata	db	' ',0,0,1,0,'EXEFIX',0
ede:
;
; The code that will be copied to the DOS Plus kernel.
;
fix0:	db	0B9h, 080h, 00h	;271: MOV CX,200h
	db	0F7h, 0F1h	;274: DIV CX
	db	090h, 090h	;276: NOP NOP
	db	090h, 090h, 90h	;278: NOP NOP NOP
fix0e:

fix1:
	db	09Ah		;2D5: CALL FAR
	dw	offset patch1	;2D6: patch1
fixcs1	dw	0		;2D8: Code segment
	db	90h		;2DA
fix1e:

fix2:
	db	09Ah		;1B4: CALL FAR
	dw	offset patch2	;1B5: patch2
fixcs2	dw	0		;1B7: Code segment
	db	90h		;1B9
fix2e:
;
; Messages
;
notdpm	db	'This program requires DOS Plus v1.2',cr,lf,'$'
isp	db	'EXEFIX is already loaded.',cr,lf,'$'
okay	db	'EXEFIX v1.00 - 11 October 2003, John Elliott.',cr,lf
	db	'The DOS Plus EXE loader has been successfully patched.',cr,lf
	db	'$'
;
; Addresses within the DOS emulator module:
;
		org	0192h
dos_exe_ss	label	word	;Initial SS
		org	0194h
dos_exe_cs	label	word	;Initial SP

		org	01A3h
exe_head_paras	label	word	;Number of paragraphs in EXE header

		org	0222h
exe_body_paras	label	word	;EXE length, paragraphs

		org	0224h
exe_body_base	label	word	;Load address of EXE

		org	0226h
dos_exe_recno	label	word	;Current CP/M record number
				;within EXE file

CodeSeg	ends
	end	begin

