;    Small-model C library startup code for CP/M-86 CMD files
;    Copyright (C) 2003  John Elliott <jce@seasip.demon.co.uk>
;
;    This library is free software; you can redistribute it and/or
;    modify it under the terms of the GNU Library General Public
;    License as published by the Free Software Foundation; either
;    version 2 of the License, or (at your option) any later version.
;
;    This library is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;    Library General Public License for more details.
;
;    You should have received a copy of the GNU Library General Public
;    License along with this library; if not, write to the Free
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;

	.psect	_TEXT,class=CODE,reloc=16,global
	.globl	start
	.globl	__Lbss
	.globl	__Hbss
	.globl	__Bstack
	.globl	__Bdata
	.globl	_main
;
; Start of the code segment. This must be the first thing in the file for 
; EXE2CMD to work properly.
;
small_code:
small_data:
_start:
start:	cli		
	cld			
	mov	ax,#seg(__Ldata)	;This will be replaced by EXE2CMD
					;with MOV AX,DS. It is here to 
					;generate the single necessary fixup
					;record so that EXE2CMD can find
					;the data segment.
	mov	ds,ax
	mov	es,ax
	mov	ss,ax
;
; Get length of data segment and put SP at the top. 
;
	mov	bx,#0FFFEh
	mov	al,dglenh	;Data group length > FFFF?
	or	al,al		;If so, put stack at DS:FFFE.
	jnz	sp_at_top
	and	bx,dglenl	;Data group length < FFFF, put stack at top.
sp_at_top:
	mov	sp,bx
	sti			;Re-enable interrupts.
;
; Clear the BSS area.
;
	mov	cx,#__Lbss
	mov	ax,#__Hbss
	sub	ax,cx
	mov	cx,ax
	mov	di,#__Lbss
	xor	ax,ax
	rep	stosb
;
; Don't init the FPU.
;
;	finit
;
; Don't init the environment, because there isn't one.
;
; TO DO: Fun and games with argv / argc. 
; TO DO: Initialise stdio library
;
	call	_main
;
; TO DO: Clean up stdio, run atexit()s etc.
;
___exit:
	mov	cl,#0
	mov	dl,#0
	int	#0xE0
;
;Other psects
;
	.psect	ldata,class=LDATA
	.psect	bss,class=BSS
	.psect	lbss,class=LBSS
	.psect	nvram,class=NVRAM
	.psect	text,class=TEXT
	.psect	stack,class=STACK
;
;Start of data
;
	.psect	data,class=DATA,reloc=16,global
	.globl	__sysfcb
	.globl	__cmdline
	.globl	__Ldata
	.globl	_errno
	.globl	small_code
	.globl	small_data
	.align	16
;
; The CP/M-86 zero page, containing the load addresses of various groups.
;
	.loc	0
zeropage:
cglenl:	.word	0
cglenh:	.byte	0
cgbase:	.word	0
cgtype:	.byte	0

dglenl:	.word	0
dglenh:	.byte	0
dgbase:	.word	0
dgtype:	.byte	0

	.blkb	050h	;6 more group descriptors, plus data load details
__sysfcb:
	.blkb	024h
__cmdline:
	.blkb	080h
_errno:	
	.word	0

	.end	_start



