

#include <stdio.h>
#include <stdlib.h>

FILE *fp1, *fp2, *fp3;
char *n1, *n2;

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

#ifdef __PACIFIC__
#define AV0 "LIOSMERG"
#else
#define AV0 argv[0]
#endif

long offset = 0;

void copy_data(FILE *src, long len, char *desc)
{
	int ch;

	fseek(src, offset, SEEK_SET);
	offset += len;
	printf("Copying %4lx bytes from %s\n", len, (src == fp1) ? n1 : n2);
	while (len)
	{
		ch = fgetc(src);
		if (ch == EOF)
		{
			fprintf(stderr, "Unexpected EOF on file %s\n", 
					(src == fp1) ? n1 : n2);
			exit(1);
		}
		fputc(ch, fp3);
		--len;
	}
}

int main(int argc, char **argv)
{
	if (argc < 4)
	{
		fprintf(stderr, "Syntax: %s oldlogo.cmd patch.cmd "
				"newlogo.cmd\n", AV0);
		return 1;
	}
	n1 = argv[1];
	n2 = argv[2];
	fp1 = fopen(argv[1], "rb");
	if (!fp1)
	{
		perror(argv[1]);
		return 1;
	}
	fp2 = fopen(argv[2], "rb");
	if (!fp2)
	{
		perror(argv[2]);
		return 1;
	}
	fp3 = fopen(argv[3], "wb");
	if (!fp3)
	{
		perror(argv[3]);
		return 1;
	}
	copy_data(fp1,   128,          "Header");
	copy_data(fp1, 0x1E8,          "C runtime");
	copy_data(fp2, 0xDD4  - 0x1E8, "LIOS code");
	copy_data(fp1, 0xD070 - 0xDD4, "LOGO code");
	copy_data(fp2, 0x434,          "LIOS data");
	copy_data(fp1, 0x2010 - 0x434, "LOGO data");
	fclose(fp3);
	fclose(fp2);
	fclose(fp1);
	return 0;
}
