/*
Copyright (c) 2008 John Elliott

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#define MAGIC "\003\000VGA LIOS patch"


void setmode(int mode)
{
	union REGS rg;

	rg.x.ax = mode;
	int86(0x10, &rg, &rg);
}

int getmode()
{
	union REGS rg;
	rg.h.ah = 0x0f;
	int86(0x10, &rg, &rg);
	return rg.h.al;
}

unsigned char buf[128];

int main(int argc, char **argv)
{
	FILE *fp;
	unsigned char far *dest;
	int m = getmode();
	int c;

	if (argc < 2)
	{
		fprintf(stderr, "Syntax: loadpc0 <filename>\n\n"
				"Copyright 2008 John Elliott, MIT/X11 licence\n");
		return 1;
	}

	fp = fopen(argv[1], "rb");
	if (!fp)
	{
		perror(argv[1]);
		return 1;
	}
	if (fread(buf, 1, sizeof(buf), fp) < (int)sizeof(buf) ||
			memcmp(buf, MAGIC, sizeof(MAGIC)-1))
	{
		fprintf(stderr, "%s is not in DR Logo format\n", argv[1]);
		fclose(fp);
		return 1;
	}
/* Since the PC0 file format is just a straight dump of the VGA framebuffer,
 * it's a simple matter to unpack it. */	
	dest = MK_FP(0xA000, 0);
	setmode(0x13);
	if (getmode() != 0x13)
	{
		setmode(m);
		fprintf(stderr, "Cannot select VGA 320x200x256 mode\n");
		return 1;
	}
	while ((c = fgetc(fp)) != EOF)
	{
		*dest++ = c;
	}
	fclose(fp);
	getch();
	setmode(m);
	return 0;
}
