	
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	STRBLT.ASM
;
;   This module contains the strblt function and the ExtendedTextOut
;   function.
;
; Created: 17-Mar-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Strblt
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


FIXED_PITCH_ON = 1			;en/disables smartfix code


;	This function will perform private stack checking.  In order for
;	private stack checking to occur, two symbols must be defined
;	prior to the inclusion of cmacros.inc.	?CHKSTK must be defined
;	if the cmacros are to perform stack checking on procedures with
;	local parameters.  ?CHKSTKPROC must be defined if private stack
;	checking will be used.
;
;	The actual macro body for ?CHKSTKPROC will be defined later.


?CHKSTK = 1
?CHKSTKPROC	macro
		endm


	.xlist
	include cmacros.inc
incFont 	= 1			;Include control for gdidefs.inc
incDrawMode	= 1			;Include control for gdidefs.inc
	include gdidefs.inc
	include display.inc
	include sigma.inc
	include macros.mac
	include strblt.inc
	include fontseg.inc
	.list


	??_out	strblt


;	Link time constants describing the size and color format
;	that the EGA will be running in.

	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA SCREEN_WIDTH		;Screen width in pixels
	externA COLOR_FORMAT		;Color format (0103h or 0104h)

	extrn	ega_saved:word

;	Other functions required for strblt.

ifdef	 EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif

	externB	planereg

sBegin	Code
assumes cs,Code
page
;--------------------------Exported-Routine-----------------------------;
; Strblt
;
; This is the old strblt entry point.  Null parameters are pushed
; for the ExtTextOut's extra parameters, and control given to
; ExtTextOut.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX = Y extent of string if extent call
;	AX = X extent of string if extent call
;	EGA registers in default state
; Error Returns:
;	DX:AX = 8000:0000H
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	See ExtTextOut
; History:
;	Thu 09-Apr-1987 13:36:08 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


	assumes ds,Data
	assumes es,nothing

;
; WIN1 In Windows 1, STRBLT now becomes live!
;
cProc	Strblt,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Destination device
	parmW	x			;Left origin of string
	parmW	y			;Top  origin of string
	parmD	lp_clip_rect		;Clipping rectangle
	parmD	lp_string		;The string itself
	parmW	count			;Number of characters in the string
	parmD	lp_font 		;Font to use
	parmD	lp_draw_mode		;Drawmode structure to use
	parmD	lp_xform		;Current text transform

;	ExtTextOut parameters we have to dummy up.
;
;	parmD	lp_dx			;Widths for the characters
;	parmD	lp_opaque_rect		;Opaquing rectangle
;	parmW	eto_options		;ExtTextOut options

	localW	bp4
	localW	abs_count		;*[bp-6] WIN1
	localW 	local_str		;*[bp-8] WIN1
	localW	next_scan		;*[bp-0a] Index to get to next scan line
	localW	y_step			;*[bp-0c] Y step
	localW	back_step		;*[bp-0e] Y backstep
	localW	draw_func		;*[bp-10]
	localB	num_planes		;Number of planes in a bitmap
	localB	opaque_routine		;Routine which does actual opaquing
	localW	colors			;Text/background colors
;		^--- this is probably actually opaque_routine
	localW	next_plane		;Index to get to next plane
	localW	fontw_bytes		;*[bp-18h] Source font width (bytes)
	localW	opaque_height		;Height of opaque box (sometimes)
	localW	clip_left		;*[bp-1c] WIN1
	localW	clip_right		; [bp-1e] WIN1
;;;	localD	lp_surface		;Pointer to first byte of destination
	localW	temp_off_lp_bits	;Intermediate pointer to dev surface
	localW	scan_start		;Delta from start of scan
	localW	clipped_font_height	;Actual height of bits to be drawn
;
; BP-24h
;
;;;	localW	tot_brk_extra		;Total break extra
	localW	df_pixel_w		; WIN1 font pixel width
	localW	brk_extra		;*# extra pixels to add each break char
	localW	brk_err 		;*Justification DDA error term
	localW	brk_rem 		;*  extra pixels are distributed
	localW	brk_count		;*DDA - # breaks into which BrkRem
	localW	char_xtra		;*# extra pixels to add each char


	localW	amt_clipped_on_top	;# of font scans clipped off top

	localW	cell_adjust		;Delta to get from one column to next
	localW	buffer			;Offset of buffer on the stack
	localW	null_char_offset	;Offset of the special null character
	localW	num_null_pixels 	;Number of pixels to add
	localW	fix_total_bytes 	;Total bytes of a fixed pitch char

;	localW	clear_stack		;SP value used to clean up stack
;	localW	min_stack		;SP where we run out of stack
;	localW	build_proc		;Procedure which builds stack data

	localW	phase
;	localW	x2
;	localW	inner_loop

;	localW	clipped_table		;Dispatch table for clipped characters
;	localW	non_clipped_table	;Dispatch table for non-clipped chars
;	localW	inner_byte_count	;Number of whole dest bytes altered

;	localW	current_lhs		;LHS of current sub-string
;	localW	current_rhs		;RHS of current sub-string
;	localW	wc_opaque_lhs		;Left  side opaqued by worst case code
;	localW	wc_opaque_rhs		;Right side opaqued by worst case code

;	localW	string_start_bias	;# chars skipped at start of string
;	localW	ret_addr		;Fixed pitch draw routine return addr
;	localW	unrolled_entry_point	;Start addr for unrolled loops

;	localW	vect_one_in_first	;Dispatch vectors for fixed pitch code
;	localW	vect_two_in_first
;	localW	vect_one_in_middle
;	localW	vect_two_in_middle
;	localW	vect_one_in_last
;	localW	vect_two_in_last

;	localV	lfd,%(size local_font_def)
;	localV	clip,%(size RECT)
;	localV	text_bbox,%(size RECT)
;	localV	o_rect,%(size RECT)

;	localV	ss_save_area,16
;	localW	ret_addr_2
;	localW	ega_oc_saved_data
;	localB	special_bm_opaque_color ;Used for opauqe mode bitmaps
;	localB	left_clip_mask		;lhs clip mask (00 if no partial left)

cBegin
	if	???			;Do test only if locals
	jc	j_exit_strblt		;No room for locals, return now
	endif

	mov	ax, count
	cwd
	xor	ax,dx			;Force positive
	shl	ax, 1			;Check that there's room on the stack
	shl	ax, 1			;for the string
	add	ax, 20h			;at 4 bytes / character + 32 overhead
	mov	cx, ax
	call	my_check_stack
	jnc	strblt_01
j_exit_strblt:
	jmp	exit_strblt
;
strblt_01:
	add	sp, cx
	mov	local_str, sp	
	lds	si, lp_clip_rect
	les	di, lp_font
	
;;;	mov	al,enabled_flag 	;Save enabled_flag incase we need it
;;;	mov	local_enabled_flag,al

;;;	call	get_mode		;Get data from drawmode, set flags
;;;	call	get_font		;Get font data (aborts if invalid)


;	If the character count is negative, then the extent of the
;	string should be calculated.  If positive, then the string
;	should be drawn.

	mov	ax,count
	or	ax,ax
	jz	j_only_draw		;No chars, might have opaque rect
	jg	strblt_02		;Positive count, output string
	neg	ax
	xor	bx, bx
	mov	word ptr lp_clip_rect, bx
strblt_02:
	mov	abs_count, ax
	mov	cx, es:[di].dfWidthBytes
	mov	fontw_bytes, cx
	mov	ax, es:[di].dfPixWidth
	mov	df_pixel_w, ax
	or	si, si			;Clip rectangle present?
	jz	strblt_05
	mov	ax, [si].top
	mov	dx, ax
	sub	ax, y
	mov	bx, ax
	jge	strblt_03
	sub	dx, bx
	xor	bx, bx
strblt_03:
	mov	temp_off_lp_bits,dx
	mov	scan_start,dx
	mov	dx, es:[di].dfPixHeight
	cmp	bx, dx
	jge	j_only_draw
	mov	ax, [si].bottom
	sub	ax, y
	cmp	ax, dx
	jl	strblt_04
	mov	ax, dx
strblt_04:
	or	ax, ax
	jle	j_only_draw
	cmp	ax, bx
	jle	j_only_draw
	jmp	short strblt_06
	nop

j_only_draw:
	jmp	only_draw


strblt_05:
	mov	bx, y
	mov	temp_off_lp_bits,bx
	mov	scan_start,bx
	xor	bx, bx
	mov	ax, es:[di].dfPixHeight
strblt_06:
	sub	ax, bx
	mov	clipped_font_height,ax
	add	scan_start, ax
	add	ax, bx
	mul	cx
	mov	dx,es:[di].dfBitsPointer
	add	ax, dx
	dec	ax
	mov	opaque_height, ax
	mov	ax, bx
	mov	si, bx
	mov	bx, dx
	mul	cx
	add	ax, bx
	dec	ax
	mov	next_plane,ax
	mov	ax, si
	lds	si, lp_draw_mode
	mov	brk_err, 0
	cmp	word ptr es:[di].dfPixWidth, 0
	jz	strblt_08
	mov	dx, offset X152D
	mov	opaque_routine,dx		
	cmp	[si].TBreakExtra,0
	jz	strblt_07
	mov	dx, offset X1553
	mov	opaque_routine,dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_07:
	mov	dx, [si].CharExtra
	mov	si, offset X1511
	or	dx, dx
	jz	strblt_10
	mov	si, offset X150B
	mov	char_xtra,dx
	xor	dx, dx
	mov	df_pixel_w, dx
	jmp	short strblt_10
	nop
;
strblt_08:
	mov	dx, offset X158E
	mov	opaque_routine, dx
	cmp	[si].TBreakExtra, 0
	jz	strblt_09
	mov	dx, offset X153F
	mov	opaque_routine, dx
	mov	dx, [si].BreakExtra
	mov	brk_extra,dx
	mov	dx, [si].BreakRem
	mov	brk_rem,dx
	mov	dx, [si].BreakErr
	mov	brk_err,dx
	mov	dx, [si].BreakCount
	mov	brk_count,dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_09:	
	mov	dx, [si].CharExtra
	mov	si, offset X1576
	or	dx, dx
	jz	strblt_10
	mov	si, offset X1570
	mov	char_xtra, dx
	xor	dx, dx
	mov	df_pixel_w, dx
strblt_10:
	mov	draw_func, si
	xor	si, offset X15AF
	mov	colors, si		;XXX
	lds	si, lp_device
	mov	dx, [si].bmWidthBytes
	add	ax, y
	xor	cx, cx
	mov	bx, dx
	xor	di, di
	cmp	[si].bmType, cx		;Main memory bitmap?
	jz	strblt_10b		;If so, no funny step between lines
	mov	bx, Y_STEP
	mov	cx, STEPBACK
	shr	ax, 1
	jnc	strblt_10a
	add	di, Y_STEP	
strblt_10a:
	shr	ax, 1
	jnc	strblt_10b
	add	di, Y_STEP+Y_STEP
strblt_10b:
	mul	dx
	add	ax, di
	mov	y_step, bx		; XXX y_step and back_step are 
	mov	back_step, cx		; correct here... which means 
	lds	si, lp_clip_rect	; previous references are incorrect
	mov	bx, x
	or	si, si
	jz	strblt_15
	mov	cx, [si].left
	mov	clip_left, cx
	mov	di, bx
	mov	dx, [si].right
	mov	clip_right, dx
	sub	dx, cx
	sub	bx, cx
	jl	strblt_11
	mov	clip_left, di
	mov	cx, di
	sub	dx, bx
	xor	bx, bx
strblt_11:
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di		;XXX
	shr	cx, 1
	shr	cx, 1
	shr	cx, 1
	add	ax, cx
	mov	next_scan, ax	;XXX
	cmp	bx, dx
	jge	j2_only_draw
	lds	si, lp_string
	les	di, lp_font
strblt_12:
	call	word ptr draw_func
	jle	strblt_12
	or	ax, ax
	jz	strblt_14
	add	ax, cx
	sub	ax, bx
	mov	cx, bx
	sub	bx, dx
strblt_13:
	jge	strblt_21
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	call	word ptr draw_func
	jmp	short strblt_13
;
strblt_14:
	add	ax, cx
	sub	ax, bx
	and	ax, 7
	mov	cx, bx
	sub	bx, dx
	jmp	short strblt_13
;
strblt_15:
	mov	clip_left, bx
	mov	clip_right, bx
	mov	cx, bx
	mov	di, cx
	and	di, word ptr 7
	sub	di, 8
	neg	di
	mov	bp4, di	;XXX
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	add	ax, bx
	mov	next_scan, ax	;XXX
	lds	si, lp_string
	les	di, lp_font
	xor	bx, bx
strblt_16:
	call	word ptr draw_func
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
	jmp	short strblt_16
;
j2_only_draw:	
	jmp	only_draw

strblt_20:
	pop	dx
	pop	si
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	push	si
	push	dx
	jmp	short strblt_23
	nop
;
strblt_21:
	sub	cx, bx
	jle	strblt_22
	mov	ch, cl
	mov	cl, al
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	push	ax
	and	cl, 7
	push	cx
strblt_22:
	cmp	sp, local_str
	jz	j2_only_draw
	cmp	df_pixel_w, 8
	jz	strblt_20
strblt_23:
	xor	ax, ax
	push	ax
	dec	ax
	push	ax
	mov	cx, count
	or	cx, cx
	jg	strblt_25
	mov	cx, brk_err
	jcxz	strblt_24
	lds	si, lp_draw_mode
	mov	[si].BreakErr, ax
strblt_24:
	mov	ax, clip_right
	sub	ax, clip_left
	mov	dx, scan_start
	sub	dx, temp_off_lp_bits
	jmp	only_draw
;
strblt_25:
	lds	si, lp_device
	mov	cx, [si].bmType
	jcxz	strblt_27
	mov	cx, clip_left
	mov	dx, temp_off_lp_bits
	mov	si, clip_right
	mov	di, scan_start
	call	exclude
	lds	si, lp_draw_mode
	mov	ax, [si].TextColor
	mov	[bp-3Eh], ax	;XXX
	mov	ax, [si].TextColor + 2
	mov	[bp-3Ch], ax	;XXX
	xor	ax,ax
	mov	[bp-34h], ax	;XXX
	mov	[bp-36h], ax	;XXX	
	mov	dx, offset write_to_planes
	cmp	word ptr [si].bkMode, 1
	jz	strblt_26
	mov	ax, [si].bkColor
	mov	[bp-3Ah], ax	;XXX
	mov	ax, [si].bkColor + 2
	mov	[bp-38h], ax	;XXX
	mov	cx, offset strblt_38
	jmp	short strblt_29
;
strblt_26:	
	mov	[bp-32h], dx	;XXX
	jmp	strblt_42
;
strblt_27:
	mov	ax, [si].BreakExtra
	cmp	word ptr [si].TextColor, 103h
	lds	si, lp_draw_mode
	jz	strblt_28
	mov	al, [si].TextColor + 3
	shl	al, 1
	cbw
	mov	[bp-3Eh], ah	;XXX
	mov	dx, offset write_to_mono
	cmp	word ptr [si].bkMode, 1
	jz	strblt_26
	mov	al, [si].bkColor + 3
	shl	al, 1
	cbw
	mov	[bp-3Ah], ah
	mov	cx, offset strblt_35
	jmp	short strblt_29
;
strblt_28:
	mov	[bp-34h], ax	;XXX
	mov	bx, ax
	add	ax, ax
	add	ax, bx
	mov	[bp-36h],ax	;XXX
	mov	dx, offset write_to_cbitmap
	mov	ax, [si].TextColor
	mov	[bp-3Eh], ax	;XXX
	mov	ax, [si].TextColor+2
	mov	[bp-3Ch], ax	;XXX
	cmp	word ptr [si].bkMode, 1
	jz	strblt_26
	mov	ax, [si].bkColor
	mov	[bp-3Ah], ax	;XXX = bk_color
	mov	ax, [si].bkColor+2
	mov	[bp-38h], ax	;XXX
	mov	cx, offset strblt_38
strblt_29:
	mov	[bp-32h], dx
	push	cx
	mov	cx, clip_left
	mov	ax, cx
	shr	ax, 1
	shr	ax, 1
	shr	ax, 1
	mov	dl, 0FFh
	and	cx, word ptr 7
	shr	dl, cl		;Left fringe
	mov	cx, clip_right
	dec	cx
	mov	bx, cx
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	mov	dh, 0FFh
	and	cx, word ptr 7
	sub	cx, 7
	neg	cx
	shl	dh, cl		;Right fringe
	inc	ax
	sub	bx, ax
	jge	strblt_30
	and	dl, dh	;Left fringe = right fringe
strblt_30:	
	mov	clip_left, bx
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan	
	retn
;
strblt_35:
	mov	ah, [bp-3Ah]
	mov	si, y_step
	sub	si, bx
	dec	si
	mov	bx, [bp-24h]	;XXX
strblt_36:
	mov	al, es:[di]
	xor	al, ah
	and	al, dl
	xor	es:[di], al
	inc	di
	mov	cx, clip_left
	or	cx, cx
	jl	strblt_37
	mov	al, ah
	rep	stosb
	mov	al, es:[di]
	xor	al, ah
	and	al, dh
	xor	es:[di], al
strblt_37:
	add	di, si
	dec	bx
	jg	strblt_36
	jmp	short strblt_42
;
strblt_38:
	mov	ax, [bp-34h]	;XXX
	add	ax, ax
	add	di, ax
strblt_39:
	mov	si, 2
strblt_40:
	push	dx
	mov	ax, si
	mov	dx, PLANEPORT
	mov	cs:planereg, al
	out	dx, al
	pop	dx
	
	mov	bx, di	
	mov	ah, [bp+si-3Ah]	;XXX
	mov	al, es:[di]
	xor	al, ah
	and	al, dl		;Left fringe
	xor	es:[di], al
	inc	di
	mov	cx, clip_left
	or	cx, cx
	js	strblt_41	;No middle or right
	mov	al, ah
	rep	stosb
	mov	al, es:[di]
	xor	al, ah
	and	al, dh
	xor	es:[di], al
strblt_41:
	mov	di, bx
	sub	di, [bp-34h]	;XXX
	dec	si
	jns	strblt_40
	dec	word ptr [bp-24h]
	jle	strblt_42
	add	di, [bp-36h]	;XXX
	add	di, y_step
	jns	strblt_39
	sub	di, back_step
	jmp	short strblt_39

strblt_42:
	lds	si, lp_font
	lds	si, [si].dfBitsPointer
	les	di, lp_device
	les	di, es:[di].bmBits
	add	di, next_scan
	mov	next_scan, di
	jmp	strblt_52
;
strblt_43:
	add	cl, dh
	shl	ax, cl
	mov	cl, dh
	call	word ptr [bp-32h]	;XXX
	mov	dh, 8
	neg	cl
	jz	strblt_45
strblt_44:
	sub	dh, cl
	jle	strblt_43
	shl	ax, cl
strblt_45:
	cmp	ch, 8
	ja	strblt_47
	or	ch, ch
	jz	strblt_49
	xor	al, al
	or	si, si
	jz	strblt_46
	lodsb
strblt_46:
	mov	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_47:
	xor	al, al
	or	si, si
	jz	strblt_48
	lodsb
strblt_48:
	mov	cl, 8
	sub	ch, cl
	jmp	short strblt_44
strblt_49:
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	dec	bx
	dec	bx
	mov	cx, ss:[bx]
	or	cl, cl
	js	strblt_51
	xor	al, al
	or	si, si
	jz	strblt_50
	add	si, next_plane
	lodsb
strblt_50:
	shl	al, cl
	sub	cl, 8
	neg	cl
	sub	ch, cl
	jnc	strblt_44
	add	cl, ch
	xor	ch, ch
	jmp	short strblt_44
;
strblt_51:
	add	si, next_plane
	mov	cl, dh
	shl	ah, cl
	call	word ptr [bp-32h]	;XXX
	mov	si, next_plane
	add	si, fontw_bytes
	cmp	si, opaque_height
	jnc	strblt_53
	mov	next_plane, si
	mov	di, next_scan
	add	di, y_step	;XXX
	jns	strblt_51a
	sub	di, back_step
strblt_51a:
	mov	next_scan, di	;XXX
strblt_52:
	mov	bx, local_str
	xor	ax, ax
	mov	dh, bptr bp4	;XXX
	cmp	df_pixel_w, 8
	jz	strblt_54
	jmp	short strblt_49
;
strblt_53:
	jmp	short only_draw
	nop
strblt_54:
	xor	cx, cx
	mov	cl, dh
	dec	bx
	dec	bx
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	add	si, next_plane
	mov	cx, ss:[bx-2]
	lodsb
	xchg	ah, al
	shl	ah, cl
	sub	cl, 8
	neg	cl		;Right fringe
	cmp	dh, cl
	jg	strblt_55
	xchg	cl, dh
	rol	ax, cl
	sub	cl, dh
	jnz	strblt_59
	mov	cl, 8
	jmp	short strblt_57
	nop
;
strblt_55:
	rol	ax, cl
	sub	cl, dh
	jmp	short strblt_60
	nop

strblt_56:
	add	si, next_plane
	lodsb
strblt_57:
	xchg	al, ah
	call	word ptr [bp-32h]	;XXX
	xchg	al, ah
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jz	strblt_61
	jmp	short strblt_56
;
strblt_58:
	add	si, next_plane
	mov	ah, [si]
	rol	ax, cl
	sub	cl, 8
strblt_59:
	neg	cl
	xchg	al, ah
	call	word ptr [bp-32h]	;XXX
	xchg	al, ah
	rol	ax, cl
	sub	cl, 8
strblt_60:
	neg	cl
	sub	bx, 4
	mov	si, ss:[bx]
	or	si, si
	jnz	strblt_58
strblt_61:	
	dec	bx
	dec	bx
	mov	ah, al
	mov	dh, cl
	jmp	strblt_49
;
only_draw:
	mov	sp, local_str
	call	unexclude
exit_strblt:

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	1Eh
	page
;

X1505:	mov	al, es:[di].dfDefaultChar
	jmp	short X1523
	nop
;
X150B:	mov	cx,colors
	xor	draw_func,cx
X1511:	lodsb
	dec	abs_count
	jl	X1535
	cmp	al, es:[di].dfLastChar
	ja	X1505
	sub	al, es:[di].dfFirstChar
	jb	X1505
X1523:	mov	cx, es:[di].dfPixWidth
	cmp	al, es:[di].dfBreakChar
	jz	X153C
X152D:	mul	cl
	add	ax, 8
	add	bx, cx
	ret
;
X1535:	add	clip_right, bx
	pop	ax
	jmp	strblt_22
;
X153C:	jmp	wptr opaque_routine
;
X153F:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	pop	bx
	jz	X1576
X1553:	add	cx, brk_extra
	mov	ax, brk_err
	sub	ax, brk_rem
	jg	X1562
	add	ax, brk_count
	inc	cx
X1562:	mov	brk_err, ax
	xor	ax, ax
	add	bx, cx
	ret
;
X156A:	mov	al, es:[di].dfDefaultChar
	jmp	short X1588
	nop

X1570:	mov	cx, colors
	xor	draw_func, cx
X1576:	lodsb
	dec	abs_count
	jl	X15A8
	cmp	al, es:[di].dfLastChar
	ja	X156A
	sub	al, es:[di].dfFirstChar
	jc	X156A
X1588:	cmp	al, es:[di].dfBreakChar
	jz	X153C
X158E:	xor	ah, ah
	shl	ax, 1
	push	bx
	mov	bx, ax
	mov	ax, es:[bx+di].dfCharOffset
	mov	cx, es:[bx+di].dfCharOffset+2
	sub	cx, ax
	add	ax, 8
	pop	bx
	jz	X1576
	add	bx, cx
	ret

X15A8:
	add	clip_right, bx
	pop	ax
	jmp	strblt_22

X15AF:
	mov	cx, colors
	xor	draw_func, cx
	mov	cx, char_xtra
	xor	ax, ax
	add	bx, cx
	ret
;
; Write to a multiplane display
;
write_to_planes:
	push	bx
	push	ax
	mov	al, 0
	mov	dx, PLANEPORT
	cli
	out	dx, al
	mov	bl, es:[di]	;Update plane 0
	xor	bl, [bp-3Eh]	;XXX
	and	bl, ah
	xor	es:[di],bl
	inc	al
	out	dx, al
	mov	bl, es:[di]	;Update plane 1
	xor	bl, [bp-3Dh]
	and	bl, ah
	xor	es:[di], bl
	inc	al
	out	dx, al
	mov	bl, es:[di]	;Update plane 2
	xor	bl, [bp-3Ch]
	and	bl, ah
	xor	es:[di], bl
	sti
	inc	di
	pop	ax
	pop	bx
	ret
;
; Write to a multiplane bitmap
;
write_to_cbitmap:
	push	bx
	mov	bx, [bp-34h]
	mov	dl, es:[di]
	xor	dl, [bp-3Eh]
	and	dl, ah
	xor	es:[di], dl
	mov	dl, es:[bx+di]
	xor	dl, [bp-3Dh]
	and	dl, ah
	xor	es:[bx+di],dl
	add	bx,bx
	mov	dl, es:[bx+di]
	xor	dl, [bp-3Ch]
	and	dl, ah
	xor	es:[bx+di], dl
	inc	di
	pop	bx
	ret

write_to_mono:
	mov	dl, es:[di]
	xor	dl, [bp-3Eh]	;XXX
	and	dl, ah
	xor	es:[di], dl
	inc	di
	ret

sEnd	Code
	end
