/************************************************************************

    SHOWKEYS v1.0.0 - Display keyboard input under Windows

    Copyright (C) 2011  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "stdafx.h"
#include "showkeys.h"
#include "lbox.h"

// This list box displays all WM_KEYDOWN / WM_KEYUP / WM_SYSKEY*  messages
// that it receives. Where possible, it tries to interpret the VK_ codes
// as text.
//

CCustomListBox::CCustomListBox()
{

}


CCustomListBox::~CCustomListBox()
{

}                

IMPLEMENT_DYNCREATE(CCustomListBox, CListBox)


BEGIN_MESSAGE_MAP(CCustomListBox, CListBox)
	//{{AFX_MSG_MAP(CCustomListBox)
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_CHAR()
	ON_WM_GETDLGCODE()
	ON_WM_SYSKEYDOWN()
	ON_WM_SYSKEYUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()                 


// Convert nChar to a textual VK_ virtual key. Key numbers used are based on
// the Windows 2000 DDK; since this has more VK_ macros than the Windows 3.x
// SDK headers that we're using here, the other ones are done as constants.
//
LPCTSTR KeyName(UINT nChar)
{    
	static TCHAR szBuf[20];

	// Digits, letters and function keys are all done in a nice neat
	// sequence.	
	if ((nChar >= '0' && nChar <= '9') || (nChar >= 'A' && nChar <= 'Z'))
	{
		_stprintf(szBuf, TEXT("VK_%c"), nChar);
		return szBuf;
	}          
	if (nChar >= VK_F1 && nChar <= VK_F24)
	{
		_stprintf(szBuf, TEXT("VK_F%d"), (nChar - VK_F1 + 1));
		return szBuf;
	}          
	if (nChar >= VK_NUMPAD0 && nChar <= VK_NUMPAD9)
	{
		_stprintf(szBuf, TEXT("VK_NUMPAD%d"), (nChar - VK_NUMPAD0));
		return szBuf;
	}          

	// The other ones.
	switch(nChar)
	{
	    case VK_LBUTTON:   return TEXT("VK_LBUTTON");
	    case VK_RBUTTON:   return TEXT("VK_RBUTTON");
	    case VK_CANCEL:    return TEXT("VK_CANCEL");
	    case VK_MBUTTON:   return TEXT("VK_MBUTTON");
	    case 0x05:		   return TEXT("VK_XBUTTON1");
	    case 0x06:		   return TEXT("VK_XBUTTON2");
// 0x07 unassigned
	    case VK_BACK:      return TEXT("VK_BACK");
	    case VK_TAB:       return TEXT("VK_TAB");
// 0x0A-0x0B reserved
	    case VK_CLEAR:     return TEXT("VK_CLEAR");
	    case VK_RETURN:    return TEXT("VK_RETURN");
	    case VK_SHIFT:     return TEXT("VK_SHIFT");
	    case VK_CONTROL:   return TEXT("VK_CONTROL");
	    case VK_MENU:      return TEXT("VK_MENU");
	    case VK_PAUSE:     return TEXT("VK_PAUSE");
	    case VK_CAPITAL:   return TEXT("VK_CAPITAL");
	    case 0x15:         return TEXT("VK_KANA");
	    case 0x17:         return TEXT("VK_JUNJA");
	    case 0x18:         return TEXT("VK_FINAL");
	    case 0x19:         return TEXT("VK_KANJI");
	    case VK_ESCAPE:    return TEXT("VK_ESCAPE");
	    case 0x1C:         return TEXT("VK_CONVERT");
	    case 0x1D:         return TEXT("VK_NONCONVERT");
	    case 0x1E:         return TEXT("VK_ACCEPT");
	    case 0x1F:         return TEXT("VK_MODECHANGE");
	    case VK_SPACE:     return TEXT("VK_SPACE");
	    case VK_PRIOR:     return TEXT("VK_PRIOR");
	    case VK_NEXT:      return TEXT("VK_NEXT");
	    case VK_END:       return TEXT("VK_END");
	    case VK_HOME:      return TEXT("VK_HOME");
	    case VK_LEFT:      return TEXT("VK_LEFT");
	    case VK_UP:        return TEXT("VK_UP");
	    case VK_RIGHT:     return TEXT("VK_RIGHT");
	    case VK_DOWN:      return TEXT("VK_DOWN");
	    case VK_SELECT:    return TEXT("VK_SELECT");
	    case VK_PRINT:     return TEXT("VK_PRINT");
	    case VK_EXECUTE:   return TEXT("VK_EXECUTE");
	    case VK_SNAPSHOT:  return TEXT("VK_SNAPSHOT");
	    case VK_INSERT:    return TEXT("VK_INSERT");
	    case VK_DELETE:    return TEXT("VK_DELETE");
	    case VK_HELP:      return TEXT("VK_HELP");
// 0x30-0x39 digits
// 0x3A-0x40 unassigned
// 0x41-0x5A letters
	    case 0x5B:		   return TEXT("VK_LWIN");
	    case 0x5C:         return TEXT("VK_RWIN");
	    case 0x5D:         return TEXT("VK_APPS");		
// 0x5E reserved
	    case 0x5F:         return TEXT("VK_SLEEP");		
// 0x60-0x69 numpad keys
	    case VK_MULTIPLY:  return TEXT("VK_MULTIPLY");	    
	    case VK_ADD: 	   return TEXT("VK_ADD");	    
	    case VK_SEPARATOR: return TEXT("VK_SEPARATOR");	
	    case VK_SUBTRACT:  return TEXT("VK_SUBTRACT");	    
	    case VK_DECIMAL:   return TEXT("VK_DECIMAL");	    
	    case VK_DIVIDE:    return TEXT("VK_DIVIDE");	    
// 0x70-0x87 function keys
// 0x88-0x8F unassigned
	    case VK_NUMLOCK:   return TEXT("VK_NUMLOCK");	    
	    case VK_SCROLL:    return TEXT("VK_SCROLL");
	    case 0x92:		   return TEXT("VK_OEM_FJ_JISHO");
	    case 0x93:		   return TEXT("VK_OEM_FJ_MASSHOU");
	    case 0x94:		   return TEXT("VK_OEM_FJ_TOUROKU");
	    case 0x95:		   return TEXT("VK_OEM_FJ_LOYA");
	    case 0x96:		   return TEXT("VK_OEM_FJ_ROYA");
// 0x97-0x9F unassigned
	    case 0xA0:		   return TEXT("VK_LSHIFT");     
	    case 0xA1:		   return TEXT("VK_RSHIFT");     
	    case 0xA2:		   return TEXT("VK_LCONTROL");
	    case 0xA3:		   return TEXT("VK_RCONTROL");   
	    case 0xA4:		   return TEXT("VK_LMENU"); 
	    case 0xA5:		   return TEXT("VK_RMENU");
	    case 0xA6:		   return TEXT("VK_BROWSER_BACK");        
	    case 0xA7:		   return TEXT("VK_BROWSER_FORWARD");     
	    case 0xA8:		   return TEXT("VK_BROWSER_REFRESH");     
	    case 0xA9:		   return TEXT("VK_BROWSER_STOP");        
	    case 0xAA:		   return TEXT("VK_BROWSER_SEARCH");
	    case 0xAB:		   return TEXT("VK_BROWSER_FAVORITES");
	    case 0xAC:		   return TEXT("VK_BROWSER_HOME");        
	    case 0xAD:		   return TEXT("VK_VOLUME_MUTE");         
	    case 0xAE:		   return TEXT("VK_VOLUME_DOWN");         
	    case 0xAF:		   return TEXT("VK_VOLUME_UP");           
	    case 0xB0:		   return TEXT("VK_MEDIA_NEXT_TRACK");    
	    case 0xB1:		   return TEXT("VK_MEDIA_PREV_TRACK");    
	    case 0xB2:		   return TEXT("VK_MEDIA_STOP");          
	    case 0xB3:		   return TEXT("VK_MEDIA_PLAY_PAUSE");    
	    case 0xB4:		   return TEXT("VK_LAUNCH_MAIL");
	    case 0xB5:		   return TEXT("VK_LAUNCH_MEDIA_SELECT");
	    case 0xB6:		   return TEXT("VK_LAUNCH_APP1");         
	    case 0xB7:		   return TEXT("VK_LAUNCH_APP2");
// 0xB8-0xB9 reserved
	    case 0xBA:		   return TEXT("VK_OEM_1");        
	    case 0xBB:		   return TEXT("VK_OEM_PLUS");     
	    case 0xBC:		   return TEXT("VK_OEM_COMMA");    
	    case 0xBD:		   return TEXT("VK_OEM_MINUS"); 
	    case 0xBE:		   return TEXT("VK_OEM_PERIOD");
	    case 0xBF:		   return TEXT("VK_OEM_2");
	    case 0xC0:		   return TEXT("VK_OEM_3");     
// 0xC1-0xD7 reserved
// 0xD8-0xDA unassigned
	    case 0xDB:		   return TEXT("VK_OEM_4");    
	    case 0xDC:		   return TEXT("VK_OEM_5"); 
	    case 0xDD:		   return TEXT("VK_OEM_6");
	    case 0xDE:		   return TEXT("VK_OEM_7");
	    case 0xDF:		   return TEXT("VK_OEM_8");     
	    case 0xE1:		   return TEXT("VK_OEM_AX"); 
	    case 0xE2:		   return TEXT("VK_OEM_102");
	    case 0xE3:		   return TEXT("VK_ICO_HELP");
	    case 0xE4:		   return TEXT("VK_ICO_00");     
	    case 0xE5:		   return TEXT("VK_PROCESSKEY");     
	    case 0xE6:		   return TEXT("VK_ICO_CLEAR");     
	    case 0xE7:		   return TEXT("VK_PACKET");     
// 0xE8 unassigned
	    case 0xE9:		   return TEXT("VK_OEM_RESET");   
	    case 0xEA:		   return TEXT("VK_OEM_JUMP");
	    case 0xEB:		   return TEXT("VK_OEM_PA1");    
	    case 0xEC:		   return TEXT("VK_OEM_PA2");  
	    case 0xED:		   return TEXT("VK_OEM_PA3");   
	    case 0xEE:		   return TEXT("VK_OEM_WSCTRL");   
	    case 0xEF:		   return TEXT("VK_OEM_CUSEL");  
	    case 0xF0:		   return TEXT("VK_OEM_ATTN");   
	    case 0xF1:		   return TEXT("VK_OEM_FINISH"); 
	    case 0xF2:		   return TEXT("VK_OEM_COPY");      
	    case 0xF3:		   return TEXT("VK_OEM_AUTO");     
	    case 0xF4:		   return TEXT("VK_OEM_ENLW");     
	    case 0xF5:		   return TEXT("VK_OEM_BACKTAB");   		
	    case 0xF6:         return TEXT("VK_ATTN");
	    case 0xF7:         return TEXT("VK_CRSEL");
	    case 0xF8:         return TEXT("VK_EXSEL");
	    case 0xF9:         return TEXT("VK_EREOF");
	    case 0xFA:         return TEXT("VK_PLAY");
	    case 0xFB:         return TEXT("VK_ZOOM");
	    case 0xFC:         return TEXT("VK_NONAME");
	    case 0xFD:         return TEXT("VK_PA1");
	    case 0xFE:         return TEXT("VK_OEM_CLEAR");
		
	    default: 		   return TEXT("");
	}
}

                 
// Each Windows key up/down message causes a line to be added to the listbox.
void CCustomListBox::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	TCHAR szBuf[200];                               
	TCHAR szName[100];
	DWORD lp = (((DWORD)nFlags) << 16) | nRepCnt;                    

	if (!GetKeyNameText(lp, szName, 100))
	{
		szName[0] = 0;
	}                    
	_stprintf(szBuf, TEXT("WM_KEYDOWN    Char=0x%04x RepCnt=0x%04x Flags=0x%04x '%s' %s"), nChar, nRepCnt, nFlags, szName, KeyName(nChar));
	int nItem = AddString(szBuf);
	SetCurSel(nItem);
}

void CCustomListBox::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	TCHAR szBuf[200];
	TCHAR szName[100];
	DWORD lp = ((((DWORD)nFlags) << 16) & 0x1FF0000L);                    

	if (!GetKeyNameText(lp, szName, 100))
	{
		szName[0] = 0;
	}                    
	_stprintf(szBuf, TEXT("WM_KEYUP      Char=0x%04x RepCnt=0x%04x Flags=0x%04x '%s' %s"), nChar, nRepCnt, nFlags, szName, KeyName(nChar));
	int nItem = AddString(szBuf);
	SetCurSel(nItem);
}
                 
                 
void CCustomListBox::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
//	char szBuf[200];
//	
//	_stprintf(szBuf, "WM_CHAR    nChar=0x%04x nRepCnt=0x%04x nFlags=0x%04x '%c'", nChar, nRepCnt, nFlags, nChar);
//	int nItem = AddString(szBuf);
//	SetCurSel(nItem);
}

void CCustomListBox::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	TCHAR szBuf[200];                               
	TCHAR szName[100];
	DWORD lp = (((DWORD)nFlags) << 16) | nRepCnt;                    

	if (!GetKeyNameText(lp, szName, 100))
	{
		szName[0] = 0;
	}                    
	_stprintf(szBuf, TEXT("WM_SYSKEYDOWN Char=0x%04x RepCnt=0x%04x Flags=0x%04x '%s' %s"), nChar, nRepCnt, nFlags, szName, KeyName(nChar));
	int nItem = AddString(szBuf);
	SetCurSel(nItem);
}

void CCustomListBox::OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	TCHAR szBuf[200];                               
	TCHAR szName[100];
	DWORD lp = (((DWORD)nFlags) << 16) | nRepCnt;                    

	if (!GetKeyNameText(lp, szName, 100))
	{
		szName[0] = 0;
	}                    
	_stprintf(szBuf, TEXT("WM_SYSKEYUP   Char=0x%04x RepCnt=0x%04x Flags=0x%04x '%s' %s"), nChar, nRepCnt, nFlags, szName, KeyName(nChar));
	int nItem = AddString(szBuf);
	SetCurSel(nItem);
}


UINT CCustomListBox::OnGetDlgCode()
{
	UINT uResult = CListBox::OnGetDlgCode();

	return uResult | DLGC_WANTALLKEYS;
}

