/************************************************************************

    SHOWKEYS v1.0.0 - Display keyboard input under Windows

    Copyright (C) 2011  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

// showkvw.cpp : implementation of the CShowkeysView class
//

#include "stdafx.h"
#include "showkeys.h"

#include "showkdoc.h"
#include "showkvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShowkeysView

IMPLEMENT_DYNCREATE(CShowkeysView, CFormView)

BEGIN_MESSAGE_MAP(CShowkeysView, CFormView)
	//{{AFX_MSG_MAP(CShowkeysView)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_COMMAND(ID_ALL_KEYS, OnAllKeys)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShowkeysView construction/destruction

CShowkeysView::CShowkeysView()
	: CFormView(CShowkeysView::IDD)
{
	//{{AFX_DATA_INIT(CShowkeysView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CShowkeysView::~CShowkeysView()
{
}

void CShowkeysView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShowkeysView)
	DDX_Control(pDX, IDC_LIST1, m_list1);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CShowkeysView diagnostics

#ifdef _DEBUG
void CShowkeysView::AssertValid() const
{
	CFormView::AssertValid();
}

void CShowkeysView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CShowkeysDoc* CShowkeysView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CShowkeysDoc)));
	return (CShowkeysDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CShowkeysView message handlers
                                         
void CShowkeysView::OnInitialUpdate()
{   
	CRect rc;

// Don't display scrollbars when the form shrinks below its original size;
// the one and only control (our listbox) tracks the form size.	
	SetScrollSizes(MM_TEXT, CSize(1,1));
	GetClientRect(&rc);
	UpdateData(FALSE);

// Resize listbox to cover entire form	
	m_list1.MoveWindow(&rc);	            
}                                         
                                         
                                         
void CShowkeysView::OnSize(UINT nType, int cx, int cy)
{
	CFormView::OnSize(nType, cx, cy);
	
	if (m_list1.m_hWnd)
	{
// Resize listbox to cover entire form	
		m_list1.MoveWindow(0, 0, cx, cy);
	}	
}

// If any WM_KEYDOWN or WM_KEYUP messages come our way, pass them on to the
// list.
void CShowkeysView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{   
	m_list1.OnKeyDown(nChar, nRepCnt, nFlags);
}

void CShowkeysView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	m_list1.OnKeyUp(nChar, nRepCnt, nFlags);
}

// Call GetKeyName() on all possible scancodes, and print the ones for which
// it succeeds.
void CShowkeysView::OnAllKeys()
{
	DWORD dw = 0x10000L;
	int nSel;
	TCHAR kname[40];
	TCHAR buf[60];  
		                   
// The first 256 are normal scancodes. The second 256 are extended. 
	for (int n = 0; n < 511; n++)
	{   
		if (GetKeyNameText(dw, kname, 40))
		{
			_stprintf(buf, TEXT("%08lx %s"), dw, kname);	
			nSel = m_list1.AddString(buf);
		}			
		dw += 0x10000L;
	}          
	m_list1.SetCurSel(nSel);
}	
	
