
#define _CRT_SECURE_NO_WARNINGS
#include <SDL.h>
#include <SDL_video.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

SDL_Window *gl_window;

unsigned char sna[65536];

static unsigned char inks[] =
{
	0xC0, 0x60, 0x00,	/* Black */
	0x00, 0x00, 0xC0,	/* Blue */
	0xC0, 0x00, 0x00,	/* Red */
	0xC0, 0x00, 0xC0,	/* Magenta */
	0x00, 0xC0, 0x00,	/* Green */
	0x00, 0xC0, 0xC0,	/* Cyan */
	0xC0, 0xC0, 0x00,	/* Yellow */
	0xC0, 0xC0, 0xC0,	/* White */
	0xFF, 0x80, 0x00,	/* Black */
	0x00, 0x00, 0xFF,	/* Blue */
	0xFF, 0x00, 0x00,	/* Red */
	0xFF, 0x00, 0xFF,	/* Magenta */
	0x00, 0xFF, 0x00,	/* Green */
	0x00, 0xFF, 0xFF,	/* Cyan */
	0xFF, 0xFF, 0x00,	/* Yellow */
	0xFF, 0xFF, 0xFF,	/* White */
};

static unsigned char papers[] =
{
	0x00, 0x00, 0x00,	/* Black */
	0x00, 0x00, 0xC0,	/* Blue */
	0xC0, 0x00, 0x00,	/* Red */
	0xC0, 0x00, 0xC0,	/* Magenta */
	0x00, 0xC0, 0x00,	/* Green */
	0x00, 0xC0, 0xC0,	/* Cyan */
	0xC0, 0xC0, 0x00,	/* Yellow */
	0xC0, 0xC0, 0xC0,	/* White */
	0x00, 0x00, 0x00,	/* Black */
	0x00, 0x00, 0xFF,	/* Blue */
	0xFF, 0x00, 0x00,	/* Red */
	0xFF, 0x00, 0xFF,	/* Magenta */
	0x00, 0xFF, 0x00,	/* Green */
	0x00, 0xFF, 0xFF,	/* Cyan */
	0xFF, 0xFF, 0x00,	/* Yellow */
	0xFF, 0xFF, 0xFF,	/* White */
};


void render_sprite(int base, int ns)
{
	char spritebuf[48][65];
	char ppmbuf[48 * 192];
	int row, col, cr, cc;
	unsigned char attr, ink, paper;
	int attrbase = base - 1;
	int bitbase = base + 6;
	char filename[40];
	FILE *fp_ppm;

	sprintf(filename, "spr%04x.ppm", base);
	fp_ppm = fopen(filename, "wb");
	if (fp_ppm)
	{
		fprintf(fp_ppm, "P6 64 48 255\n");
	}

	printf("%04x: Sprite %d\n", base, ns);
	printf("    mask ");
	for (row = 0; row < 6; row++)
	{
		printf("%02x ", sna[base + row]);
	}
	putchar('\n');

	memset(spritebuf, ' ', sizeof(spritebuf));
	memset(ppmbuf, 0x80, sizeof(ppmbuf));
	for (row = 0; row < 48; row++)
	{
		spritebuf[row][64] = 0;
	}
	for (row = 0; row < 6; row++)
	{
		unsigned char rowmask = sna[base + row];
		for (col = 0; col < 8; col++)
		{
			if (rowmask & 0x80)
			{
				attr = sna[attrbase--];	// Cell attribute

				ink   = attr & 7;
				paper = (attr >> 3) & 7;

				if (attr & 0x40) 
				{
					ink |= 8;
					paper |= 8;
				}

				for (cr = 0; cr < 8; cr++)
				{
					unsigned char bits = sna[bitbase++];
					for (cc = 0; cc < 8; cc++)
					{
						spritebuf[row * 8 + cr][col * 8 + cc] = (bits & 0x80) ? '#' : '-';

						memcpy(ppmbuf + (row*8+cr) * 192 + (col*8+cc) * 3, 
							(bits & 0x80) ? inks + (ink*3) : papers + (paper * 3), 3);

						bits = bits << 1;
					}
				}
			}
			rowmask = rowmask << 1;
		}
	}
	for (row = 0; row < 48; row++)
	{
		if (strchr(spritebuf[row], '-') || strchr(spritebuf[row], '#'))
		{
			printf("    %s\n", spritebuf[row]);
		}
	}
	if (fp_ppm)
	{
		fwrite(ppmbuf, 1, sizeof(ppmbuf), fp_ppm);
		fclose(fp_ppm);
	}
	printf("    Sprite ends @ %04x", bitbase);
	putchar('\n');

}


int main(int argc, char ** argv)
{
	FILE *fp;
	int n, m;

	if (argc < 2)
	{
		fprintf(stderr, "Syntax: %s filename", argv[0]);
		return 1;
	}

	SDL_Init(SDL_INIT_VIDEO);
	gl_window = SDL_CreateWindow("Viewer", 
		SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED,
		640, 480, SDL_WINDOW_SHOWN);

	fp = fopen(argv[1], "rb");
	fread(sna + 0x3fe5, 1, 49179, fp);
	fclose(fp);

	getchar();

/*
	for (n = 0x7530; n < 0x9330; n += 30)
	{
		render_room(n);
	}

	for (n = 0; n < 11; n++)
	{
		int ptr = 0x663D + 2 * n;
		int base = sna[ptr] | (sna[ptr + 1] << 8);

		render_sprite(base, n);
	}
	for (n = 0; n < 64; n++)
	{
		int ptr = 0xEB23 + 2 * n;
		int base = sna[ptr] | (sna[ptr + 1] << 8);

		render_sprite(base, n);
	}


	for (n = 0; n <= 0x36; n++)
	{
		for (m = 0; m < 16; m++)
		{
			int c, mk;

			if (m == 0) printf("%04x: Tile %02x\n    ", 0xF90C + 32 * n, n);
			else printf("    ");

			if (m < 8) c = sna[0xF90C + 32 * n + m];
			else	   c = sna[0xF914 + 32 * n + m];

			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			if (m < 8) c = sna[0xF914 + 32 * n + m];
			else	   c = sna[0xF91C + 32 * n + m];
			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			putchar('\n');
		}
		putchar('\n');
	}

	for (n = 40; n < 80; n++)
	{
		for (m = 0; m < 8; m++)
		{
			int c, mk;

			if (m == 0) printf("%04x: Character %02x\n    ", 0xF68C + 8 * n, n);
			else printf("    ");

			c = sna[0xF68C + 8 * n + m];
			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			putchar('\n');
		}
		putchar('\n');
	}
	for (n = 0x4000; n < 0xFFFF; n++)
	{
		if (sna[n] == 0xCD && sna[n+1] == 0x10 && sna[n+2] == 0xBD)
		{
			render_str(n+3);
		}
	}
*/
	return 0;
}

