// renderfont.cpp : Defines the entry point for the console application.
//

#define _CRT_SECURE_NO_WARNINGS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char sna[65536];

void render_str(int addr)
{
	static char map[] = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ.%_";
	printf("%04x: ", addr);

	while (sna[addr] != 0xFF)
	{
		if (sna[addr] >= 40 && sna[addr] < 80)
		{
			putchar(map[sna[addr] - 40]);
		}
		else switch(sna[addr])
		{
			case 0x10: printf("<ink %d>", sna[addr+1]); ++addr; break;
			case 0x11: printf("<paper %d>", sna[addr+1]); ++addr; break;
			case 0x12: printf("<flash %d>", sna[addr+1]); ++addr; break;
			case 0x13: printf("<bright %d>", sna[addr+1]); ++addr; break;
			case 0x14: printf("<inverse %d>", sna[addr+1]); ++addr; break;
			case 0x15: printf("<over %d>", sna[addr+1]); ++addr; break;
			case 0x16: printf("<at %d,%d>", sna[addr+1], sna[addr+2]); addr += 2; break;
			case 0x17: printf("<tab %d,%d>", sna[addr+1], sna[addr+2]); addr += 2; break;

			default: printf("<%02x>", sna[addr]); break;
		}
		++addr;
	}
	putchar('\n');
}

void show_exit(int addr)
{
	static char facing[] = "SWNE";
	static char *type[8] = 
	{
		"open    ", 
		"key     ", 
		"ring    ", 
		"diamond ", 
		"timed   ", 
		"wardrobe", 
		"magic   ", 
		"?7      " };

	int x = sna[addr    ] & 0x1F;
	int y = sna[addr + 1] & 0x1F;
	int f = ((sna[addr] & 0xE0) >> 2) | (sna[addr + 1] >> 5);
	printf("    exit x=%02d y=%02d ", x, y);
	printf("facing %c ", facing[f & 3]);
	printf("type %d [%s] ", (f >> 2) & 7, type[(f >> 2) & 7]);
	printf("dest=%03d ", sna[addr+2]);
	if ((f >> 2) & 8) printf("hidden ");
	putchar('\n');
}

void render_room(int base)
{
	unsigned char obj;

	printf("%04x: Room %d\n", base, (base - 0x7530) / 30);
	printf("    x=%02x y=%02x\n", sna[base], sna[base + 1]);

	printf("    Walls: Top %01x %01x %01x  Right %01x  Bottom %01x %01x %01x  Left %01x\n", 
		sna[base + 2] >> 4, sna[base + 2] & 0x0F,
		sna[base + 3] >> 4, sna[base + 3] & 0x0F,
		sna[base + 4] >> 4, sna[base + 4] & 0x0F,
		sna[base + 5] >> 4, sna[base + 5] & 0x0F);
	printf("    Vertical adj: %02x %02x %02x %02x\n",
		(sna[base + 6] >> 4), (sna[base + 6] & 0x0F),
		(sna[base + 7] >> 4), (sna[base + 7] & 0x0F));
	show_exit(base +  8);
	show_exit(base + 11);
	show_exit(base + 14);
	show_exit(base + 17);

	printf("    Adornment: a=%02x b=%02x c=%02x\n", (sna[base + 20] & 0x1F), (sna[base + 21] & 0x1F), (sna[base + 21] >> 5) | ((sna[base+20] & 0xE0) >> 2));
	printf("    Scenery 1: x=%02x y=%02x sprite=%02x\n", (sna[base + 22] & 0x1F), (sna[base + 23] & 0x1F), (sna[base + 23] >> 5) | ((sna[base+22] & 0xE0) >> 2));
	printf("    Scenery 2: x=%02x y=%02x sprite=%02x\n", (sna[base + 24] & 0x1F), (sna[base + 25] & 0x1F), (sna[base + 25] >> 5) | ((sna[base+24] & 0xE0) >> 2));
	obj = sna[base + 26];

	switch (obj)
	{
		case 0x7B: printf("    7B cross\n"); break;
		case 0x7C: printf("    7C lion 1\n"); break;
		case 0x7D: printf("    7D lion 2\n"); break;
		case 0x7E: printf("    7E lion 3\n"); break;
		case 0x7F: printf("    7F lion 4\n"); break;
		default:
			if (obj < 0x7B) printf("    %02x Trapdoor to %d\n", 
				obj, 2 * obj);
			else 		printf("    %02x Randon object\n", obj);
	}
	printf("    %02x visited / random seed\n", sna[base + 27]);
	printf("    %02x RM1C style\n", sna[base + 28]);
	printf("    %02x RM1D\n", sna[base + 29]);

}

static unsigned char inks[] =
{
	0xC0, 0x60, 0x00,	/* Black */
	0x00, 0x00, 0xC0,	/* Blue */
	0xC0, 0x00, 0x00,	/* Red */
	0xC0, 0x00, 0xC0,	/* Magenta */
	0x00, 0xC0, 0x00,	/* Green */
	0x00, 0xC0, 0xC0,	/* Cyan */
	0xC0, 0xC0, 0x00,	/* Yellow */
	0xC0, 0xC0, 0xC0,	/* White */
	0xFF, 0x80, 0x00,	/* Black */
	0x00, 0x00, 0xFF,	/* Blue */
	0xFF, 0x00, 0x00,	/* Red */
	0xFF, 0x00, 0xFF,	/* Magenta */
	0x00, 0xFF, 0x00,	/* Green */
	0x00, 0xFF, 0xFF,	/* Cyan */
	0xFF, 0xFF, 0x00,	/* Yellow */
	0xFF, 0xFF, 0xFF,	/* White */
};

static unsigned char papers[] =
{
	0x00, 0x00, 0x00,	/* Black */
	0x00, 0x00, 0xC0,	/* Blue */
	0xC0, 0x00, 0x00,	/* Red */
	0xC0, 0x00, 0xC0,	/* Magenta */
	0x00, 0xC0, 0x00,	/* Green */
	0x00, 0xC0, 0xC0,	/* Cyan */
	0xC0, 0xC0, 0x00,	/* Yellow */
	0xC0, 0xC0, 0xC0,	/* White */
	0x00, 0x00, 0x00,	/* Black */
	0x00, 0x00, 0xFF,	/* Blue */
	0xFF, 0x00, 0x00,	/* Red */
	0xFF, 0x00, 0xFF,	/* Magenta */
	0x00, 0xFF, 0x00,	/* Green */
	0x00, 0xFF, 0xFF,	/* Cyan */
	0xFF, 0xFF, 0x00,	/* Yellow */
	0xFF, 0xFF, 0xFF,	/* White */
};


void render_sprite(int base, int ns)
{
	char spritebuf[48][65];
	char ppmbuf[48 * 192];
	int row, col, cr, cc;
	unsigned char attr, ink, paper;
	int attrbase = base - 1;
	int bitbase = base + 6;
	char filename[40];
	FILE *fp_ppm;

	sprintf(filename, "spr%04x.ppm", base);
	fp_ppm = fopen(filename, "wb");
	if (fp_ppm)
	{
		fprintf(fp_ppm, "P6 64 48 255\n");
	}

	printf("%04x: Sprite %d\n", base, ns);
	printf("    mask ");
	for (row = 0; row < 6; row++)
	{
		printf("%02x ", sna[base + row]);
	}
	putchar('\n');

	memset(spritebuf, ' ', sizeof(spritebuf));
	memset(ppmbuf, 0x80, sizeof(ppmbuf));
	for (row = 0; row < 48; row++)
	{
		spritebuf[row][64] = 0;
	}
	for (row = 0; row < 6; row++)
	{
		unsigned char rowmask = sna[base + row];
		for (col = 0; col < 8; col++)
		{
			if (rowmask & 0x80)
			{
				attr = sna[attrbase--];	// Cell attribute

				ink   = attr & 7;
				paper = (attr >> 3) & 7;

				if (attr & 0x40) 
				{
					ink |= 8;
					paper |= 8;
				}

				for (cr = 0; cr < 8; cr++)
				{
					unsigned char bits = sna[bitbase++];
					for (cc = 0; cc < 8; cc++)
					{
						spritebuf[row * 8 + cr][col * 8 + cc] = (bits & 0x80) ? '#' : '-';

						memcpy(ppmbuf + (row*8+cr) * 192 + (col*8+cc) * 3, 
							(bits & 0x80) ? inks + (ink*3) : papers + (paper * 3), 3);

						bits = bits << 1;
					}
				}
			}
			rowmask = rowmask << 1;
		}
	}
	for (row = 0; row < 48; row++)
	{
		if (strchr(spritebuf[row], '-') || strchr(spritebuf[row], '#'))
		{
			printf("    %s\n", spritebuf[row]);
		}
	}
	if (fp_ppm)
	{
		fwrite(ppmbuf, 1, sizeof(ppmbuf), fp_ppm);
		fclose(fp_ppm);
	}
	printf("    Sprite ends @ %04x", bitbase);
	putchar('\n');

}


int main(int argc, char ** argv)
{
	FILE *fp;
	int n, m;

	if (argc < 2)
	{
		fprintf(stderr, "Syntax: %s filename", argv[0]);
		return 1;
	}

	fp = fopen(argv[1], "rb");
	fread(sna + 0x3fe5, 1, 49179, fp);

	for (n = 0x7530; n < 0x9330; n += 30)
	{
		render_room(n);
	}

	for (n = 0; n < 11; n++)
	{
		int ptr = 0x663D + 2 * n;
		int base = sna[ptr] | (sna[ptr + 1] << 8);

		render_sprite(base, n);
	}
	for (n = 0; n < 64; n++)
	{
		int ptr = 0xEB23 + 2 * n;
		int base = sna[ptr] | (sna[ptr + 1] << 8);

		render_sprite(base, n);
	}


	for (n = 0; n <= 0x36; n++)
	{
		for (m = 0; m < 16; m++)
		{
			int c, mk;

			if (m == 0) printf("%04x: Tile %02x\n    ", 0xF90C + 32 * n, n);
			else printf("    ");

			if (m < 8) c = sna[0xF90C + 32 * n + m];
			else	   c = sna[0xF914 + 32 * n + m];

			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			if (m < 8) c = sna[0xF914 + 32 * n + m];
			else	   c = sna[0xF91C + 32 * n + m];
			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			putchar('\n');
		}
		putchar('\n');
	}

	for (n = 40; n < 80; n++)
	{
		for (m = 0; m < 8; m++)
		{
			int c, mk;

			if (m == 0) printf("%04x: Character %02x\n    ", 0xF68C + 8 * n, n);
			else printf("    ");

			c = sna[0xF68C + 8 * n + m];
			for (mk = 0x80; mk != 0; mk = mk >> 1)
			{
				if (c & mk) putchar('#');
				else putchar('-');
			}
			putchar('\n');
		}
		putchar('\n');
	}
	for (n = 0x4000; n < 0xFFFF; n++)
	{
		if (sna[n] == 0xCD && sna[n+1] == 0x10 && sna[n+2] == 0xBD)
		{
			render_str(n+3);
		}
	}

	return 0;
}

