        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.ASM
;
;   This module contains functions and definitions specific to
;   the IBM CGA Monochrome Display Driver.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	physical_enable
;			physical_disable
;
; Public Data:
;		PHYS_DEVICE_SIZE		info_table_base
;		BW_THRESHOLD			physical_device
;		COLOR_FORMAT			interlace_adjust
;		SCREEN_W_BYTES			rot_bit_tbl
;		SCREEN_WIDTH			color_table
;		SCREEN_HEIGHT			ScreenSelector
;		COLOR_TBL_SIZE			BlueMoonSeg_colo_table
;		Y_SHIFT_COUNT			PixelSeg_interlace_adjust
;		EVEN_SCAN_INC			LineSeg_interlace_adjust
;		ODD_SCAN_INC			ScanlineSeg_interlace_adjust
;		TOGGLE_EVEN_ODD 		BlueMoonSeg_interlace_adjust
;		EVEN_SCAN_INC_D
;		ODD_SCAN_INC_D
;		TOGGLE_EVEN_ODD_D
;		EVEN_INC_LESS_ODD_INC
;
;		HYPOTENUSE
;		Y_MAJOR_DIST
;		X_MAJOR_DIST
;		Y_MINOR_DIST
;		X_MINOR_DIST
;		MAX_STYLE_ERR
;
;		HERCULES_DEFINED
;
;		 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
;		 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
;		 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
;		 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
;		D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
;		D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
;		D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
;		D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
;		CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
;		CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
;		DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
;		DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include	cursor.inc
	include gdidefs.inc
	include display.inc
	include macros.mac
	include apricot.inc
	.list


	public	HERCULES_DEFINED

	public	PHYS_DEVICE_SIZE	;Number of bytes in physical device
	public	BW_THRESHOLD		;Black/white threshold
	public	COLOR_FORMAT		;Color format
	public	SCREEN_W_BYTES		;Screen width in bytes
	public	SCREEN_WIDTH		;Screen width in pixels
	public	SCREEN_HEIGHT		;Screen height in scans
	public	COLOR_TBL_SIZE		;Number of entries in color table
	public	ScreenSelector		;Segment of Regen RAM

	public	physical_enable 	;Enable routine
	public	physical_disable	;Disable

	public	physical_device 	;Physical device descriptor
	public	info_table_base 	;GDIInfo table base address

	public	HYPOTENUSE
	public	Y_MAJOR_DIST
	public	X_MAJOR_DIST
	public	Y_MINOR_DIST
	public	X_MINOR_DIST
	public	MAX_STYLE_ERR

	public	rot_bit_tbl

	public	 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
	public	 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
	public	 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
	public	 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
	public	D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
	public	D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
	public	D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
	public	D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
	public	CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
	public	CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
	public	DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
	public	DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7




;	The following label provides some error checking at link time
;	as to whether a module was compiled for the CGA or for the
;	Hercules card.  This label enables extern statements which
;	the linker will catch in case of incorrect target adapters.

HERCULES_DEFINED = 1




;-----------------------------------------------------------------------;
;	The hatched brush pattern definitions
;-----------------------------------------------------------------------;

H_HATCH_BR_0	equ	11111111b	;Horizontal Hatched brush
H_HATCH_BR_1	equ	11111111b
H_HATCH_BR_2	equ	11111111b
H_HATCH_BR_3	equ	11111111b
H_HATCH_BR_4	equ	00000000b
H_HATCH_BR_5	equ	11111111b
H_HATCH_BR_6	equ	11111111b
H_HATCH_BR_7	equ	11111111b

V_HATCH_BR_0	equ	11110111b	;Vertical Hatched brush
V_HATCH_BR_1	equ	11110111b
V_HATCH_BR_2	equ	11110111b
V_HATCH_BR_3	equ	11110111b
V_HATCH_BR_4	equ	11110111b
V_HATCH_BR_5	equ	11110111b
V_HATCH_BR_6	equ	11110111b
V_HATCH_BR_7	equ	11110111b

D1_HATCH_BR_0	equ	01111111b	;\ diagonal brush
D1_HATCH_BR_1	equ	10111111b
D1_HATCH_BR_2	equ	11011111b
D1_HATCH_BR_3	equ	11101111b
D1_HATCH_BR_4	equ	11110111b
D1_HATCH_BR_5	equ	11111011b
D1_HATCH_BR_6	equ	11111101b
D1_HATCH_BR_7	equ	11111110b

D2_HATCH_BR_0	equ	11111110b	;/ diagonal hatched brush
D2_HATCH_BR_1	equ	11111101b
D2_HATCH_BR_2	equ	11111011b
D2_HATCH_BR_3	equ	11110111b
D2_HATCH_BR_4	equ	11101111b
D2_HATCH_BR_5	equ	11011111b
D2_HATCH_BR_6	equ	10111111b
D2_HATCH_BR_7	equ	01111111b

CR_HATCH_BR_0	equ	11110111b	;+ hatched brush
CR_HATCH_BR_1	equ	11110111b
CR_HATCH_BR_2	equ	11110111b
CR_HATCH_BR_3	equ	11110111b
CR_HATCH_BR_4	equ	00000000b
CR_HATCH_BR_5	equ	11110111b
CR_HATCH_BR_6	equ	11110111b
CR_HATCH_BR_7	equ	11110111b

DC_HATCH_BR_0	equ	01111110b	;X hatched brush
DC_HATCH_BR_1	equ	10111101b
DC_HATCH_BR_2	equ	11011011b
DC_HATCH_BR_3	equ	11100111b
DC_HATCH_BR_4	equ	11100111b
DC_HATCH_BR_5	equ	11011011b
DC_HATCH_BR_6	equ	10111101b
DC_HATCH_BR_7	equ	01111110b




;-----------------------------------------------------------------------;
;	Line style definitions
;
;	Since the style update code in the line DDA checks for a sign,
;	the values chosen for distances, HYPOTENUSE, and MAX_STYLE_ERR
;	must not be bigger than 127+min(X_MAJOR_DIST,Y_MAJOR_DIST).  If
;	this condition is met, then the sign bit will always be cleared
;	on the first subtraction after every add-back.
;-----------------------------------------------------------------------;


HYPOTENUSE	=	18		;Distance moving X and Y
Y_MAJOR_DIST	=	15		;Distance moving Y only
X_MAJOR_DIST	=	10		;Distance moving X only
Y_MINOR_DIST	=	HYPOTENUSE-X_MAJOR_DIST
X_MINOR_DIST	=	HYPOTENUSE-Y_MAJOR_DIST
MAX_STYLE_ERR	=	HYPOTENUSE*2	;Max error before updating
					;  rotating bit mask



;-----------------------------------------------------------------------;
;	The black/white threshold is used to determine the split
;	between black and white when summing an RGB Triplet
;-----------------------------------------------------------------------;


BW_THRESHOLD	equ	(3*0FFh)/2
page

;	The odd row increment is the value used when incrementing from
;	an odd scan line to an even scan line, with an increasing Y.
;
;	The even row increment is the value used when incrementing from
;	an even scan line to an odd scan line, with an increasing Y.
;
;	The even-odd toggle value is the XOR mask used to toggle the
;	odd row increment to the next even row for an increasing Y.


page

sBegin	Code
assumes cs,Code


SCREEN_W_BYTES	equ	SCAN_BYTES*1	;Screen width in bytes
COLOR_FORMAT	equ	0101h


;-----------------------------------------------------------------------;
;	PhysDeviceSize is the number of bytes that the enable routine
;	is to copy into the passed PDevice block before calling the
;	physical_enable routine.  For this driver, the length is the
;	size of the bitmap structure.
;-----------------------------------------------------------------------;

PHYS_DEVICE_SIZE equ	size BITMAP



;-----------------------------------------------------------------------;
;	Allocate the physical device block for the EGA Card.
;	For this driver, physical devices will be in the same format
;	as a normal bitmap descriptor.	This is very convienient since
;	it simplifies the structures that the code must work with.
;
;	The bmWidthPlanes field will be set to zero to simplify some
;	of the three plane code.  By setting it to zero, it can be
;	added to a memory bitmap pointer without changing the pointer.
;	This allows the code to add this in regardless of the type of
;	the device.
;
;	The actual physical block will have some extra bytes stuffed on
;	the end (IntPhysDevice structure), but only the following is static
;-----------------------------------------------------------------------;

ScreenSelector	equ	0280H


;	The following constants keep the parameter list to BITMAP within
;	view on an editing display 80 chars wide.

SCRSEL		equ	ScreenSelector
P		equ	 COLOR_FORMAT AND 000FFh	;# color planes
B		equ	(COLOR_FORMAT AND 0FF00h) SHR 8	;# bits per pixel
H		equ	SCREEN_HEIGHT			;new display height
W		equ	SCREEN_WIDTH			;display width, pels
WB		equ	2				;display width, bytes
							;(Apricot oddness!)
physical_device BITMAP <SCRSEL,W,H,WB,P,B,02800000H,09C40h,0,0,0,0,0,0>

	public	Y_OFFSETS	;I think this must be left over from Hercules
				;because Apricot should not need it
Y_OFFSETS	dw	0	;Offsets to the four interleaved display
		dw	2000h	;memory segments
		dw	4000h
		dw	6000h

;-----------------------------------------------------------------------;
;	The GDIInfo data Structure.  The specifics of the Hercules
;	mode are passed to GDI via this structure.
;-----------------------------------------------------------------------;


info_table_base label byte


	dw	100h			;Version = 1.00
	errnz	dpVersion

	dw	DT_RASDISPLAY		;Device classification
	errnz	dpTechnology-dpVersion-2

	dw	210			;Horizontal size in millimeters
	errnz	dpHorzSize-dpTechnology-2

	dw	150			;Vertical size in millimeters
	errnz	dpVertSize-dpHorzSize-2

	dw	SCREEN_WIDTH		;Horizontal width in pixels
	errnz	dpHorzRes-dpVertSize-2

	dw	SCREEN_HEIGHT		;Vertical width in pixels
	errnz	dpVertRes-dpHorzRes-2

	dw	1			;Number of bits per pixel
	errnz	dpBitsPixel-dpVertRes-2

	dw	1			;Number of planes
	errnz	dpPlanes-dpBitsPixel-2

	dw	65+6+6			;Number of brushes the device has
	errnz	dpNumBrushes-dpPlanes-2 ;  (Show lots of brushes)

	dw	10			;Number of pens the device has
	errnz	dpNumPens-dpNumBrushes-2;  (2 colors * 5 styles)

	dw	0			;Reserved

	dw	0			;Number of fonts the device has
	errnz	dpNumFonts-dpNumPens-4

	dw	2			;Number of colors in color table
	errnz	dpNumColors-dpNumFonts-2

	dw	size int_phys_device	;Size required for device descriptor
	errnz	dpDEVICEsize-dpNumColors-2

	dw	CC_NONE 		;Curves capabilities
	errnz	dpCurves-dpDEVICEsize-2

	dw	LC_POLYLINE+LC_STYLED	;Line capabilities
	errnz	dpLines-dpCurves-2

	dw	PC_SCANLINE		;Polygonal capabilities
	errnz	dpPolygonals-dpLines-2

	dw	TC_CP_STROKE+TC_RA_ABLE ;Text capabilities
	errnz	dpText-dpPolygonals-2

	dw	CP_NONE 		;Clipping capabilities
	errnz	dpClip-dpText-2

					;BitBlt capabilities
;;;	dw	RC_BITBLT+RC_BITMAP64+RC_GDI20_OUTPUT+RC_SAVEBITMAP
	dw	RC_BITBLT		;WIN1 can only do RC_BITBLT
	errnz	dpRaster-dpClip-2

	dw	X_MAJOR_DIST		;Distance moving X only
	errnz	dpAspectX-dpRaster-2

	dw	Y_MAJOR_DIST		;Distance moving Y only
	errnz	dpAspectY-dpAspectX-2

	dw	HYPOTENUSE		;Distance moving X and Y
	errnz	dpAspectXY-dpAspectY-2

	dw	MAX_STYLE_ERR		;Length of segment for line styles
	errnz	dpStyleLen-dpAspectXY-2


	errnz	dpMLoWin-dpStyleLen-2	;Metric  Lo res WinX,WinY,VptX,VptY
	dw	2100			;  HorzSize * 10
	dw	1500			;  VertSize * 10
	dw	800			;  HorizRes
	dw	-400			;  -VertRes


	errnz	dpMHiWin-dpMLoWin-8	;Metric  Hi res WinX,WinY,VptX,VptY
	dw	21000			;  HorzSize * 100
	dw	15000			;  VertSize * 100
	dw	800			;  HorizRes
	dw	-400			;  -VertRes


	errnz	dpELoWin-dpMHiWin-8	;English Lo res WinX,WinY,VptX,VptY
	dw	1312			;  HorzSize * 1000 scaled(/225)
	dw	750			;  VertSize * 1000 scaled(/200)
	dw	1270			;  HorizRes * 254  scaled(/225)
	dw	-508			;  -VertRes * 254  scaled(/200)


	errnz	dpEHiWin-dpELoWin-8	;English Hi res WinX,WinY,VptX,VptY
	dw	13120			;  HorzSize * 10000 scaled(/225)
	dw	7500			;  VertSize * 10000 scaled(/400)
	dw	1270			;  HorizRes * 254   scaled(/225)
	dw	-508			;  -VertRes * 254   scaled(/400)


	errnz	dpTwpWin-dpEHiWin-8	;Twips		WinX,WinY,VptX,VptY
	dw	3024			;  HorzSize * 14400 scaled(/1000)
	dw	4320			;  VertSize * 14400 scaled(/400)
	dw	203			;  HorizRes * 254   scaled(/1000)
	dw	-203			;  -VertRes * 254   scaled(/400)


	dw	108			;Logical Pixels/inch in X
	errnz	dpLogPixelsX-dpTwpWin-8

	dw	72			;Logical Pixels/inch in Y
	errnz	dpLogPixelsY-dpLogPixelsX-2

	dw	DC_IgnoreDFNP		;dpDCManage
	errnz	dpDCManage-dpLogPixelsY-2

	dw	0			;Reserved fields
	dw	0
	dw	0
	dw	0
	dw	0


	errnz	<(offset $)-(offset info_table_base)-(size GDIINFO)>

;;; WIN1 -- was in pixel.asm in win2
rot_bit_tbl     label   byte
                db      10000000b       ;Table to map bit index into
                db      01000000b       ;  a bit mask 
                db      00100000b 
                db      00010000b
                db      00001000b 
                db      00000100b
                db      00000010b
                db      00000001b
page

X023A	db	0

;---------------------------Public-Routine------------------------------;
; physical_enable
;
;   Apricot 800x400 graphics mode is enabled.
;
; Entry:
;	ES:DI --> ipd_format in our pDevice
;	DS: = Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	AX = 0
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing

physical_enable proc near

	cld
	call	clear_vram
	mov	al, 1Bh		;Try to select Xi graphics mode using 	
	int	0F1h		;  escape code (see
	mov	al, '}'		;  <https://ansible.uk/ai/apricot/escapes.html>
	int	0F1h		;  )	
	mov	dx, 1
	call	apricot_setmode	;Try to select Xi graphics mode using BIOS
	call	setup_memptrs
	mov	cx, 24h		;I can't find any documentation about what
	mov	bl, 0FFh	;INT EC does on an Apricot, but disassembly
	int	0ECh		;suggests this is tring to manipulate 
	mov	X023A, 0	;display-related parts of the PIO.
	or	ax, ax
	jnz	phys_enable_10	;If that call returned 0, store the value
	mov	X023A, dl	;returned in DL
	mov	cx, 24h
	mov	bl, 0
	int	0ECh
phys_enable_10:
	mov	al, 1		;Report success
	ret	
	
physical_enable endp

;
; Call with DX=mode: 0=text 1=graphics
;
apricot_setmode	proc near
	mov	bx, 31h			;Screen driver
	mov	cx, 1			;Set mode
	int	0FCh
	ret
apricot_setmode	endp

clear_vram	proc near
	push	es
	push	di
	mov	di, 0
	mov	bx, ScreenSelector
	mov	es, bx
	mov	cx, 4E20h	;= framebuffer size / 2
	xor	ax, ax
	cld
	rep	stosw
	pop	di
	pop	es
	ret
clear_vram	endp
page
;
; Set up the memory pointers for Apricot graphics mode (presumably some
; BIOSes don't)
;
setup_memptrs	proc	near
	mov	ax, 0F000h
	mov	es, ax
	mov	di, 0
	mov	cx, CELLS_Y
	mov	ax, ScreenSelector/2
setup_memptrs_10:
	push	cx
	push	ax
	mov	cx, CELLS_X
setup_memptrs_20:
	stosw
	add	ax, CELLS_X/2
	loop	setup_memptrs_20
	pop	ax
	inc	ax
	pop	cx
	loop	setup_memptrs_10
	ret
setup_memptrs	endp




;---------------------------Public-Routine------------------------------;
; physical_disable
;
;   Hercules 720x348 graphics mode is exited.  The text mode of the
;   adapter is restored.
;
; Entry:
;	DS:SI --> int_phys_device
;	ES:    =  Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	None
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,nothing
	assumes es,Data

physical_disable proc near

	call	clear_vram
	mov	dx, 0
	call	apricot_setmode		;Switch back to text mode using BIOS

	mov	al, 1Bh			;Switch back to text mode using
	int	0F1h			;escapes
	mov	al, 'z'
	int	0F1h

	mov	cx, 24h			;Switch back to text modes using 
	mov	bl, X023A		;INT EC?
	int	0ECh		

	mov	al,1
	ret

physical_disable endp

sEnd	Code
page

sBegin	Code
assumes cs,Code


;-----------------------------------------------------------------------;
;	This is the same physical device structure as defined above
;	except that the number of scan lines has been increased to
;	encompass shadow memory.  We have to do this for the restore
;	operation of the SaveScreenBitmap function, because BitBLT
;	clips the source to the device extents,	meaning that the entire
;	saved rectangle would be lost.
;
;	To fake out BitBLT, add 410 to the y coordinate to get from active
;	to shadow memory.  This transformation causes the shadow mem copy
;	to be slightly offset from A8000h as compared to the original from
;	A0000h, but there is enough unused RAM at the end of shadow mem to
;	take the slop, and it's fast.
;
;	(8000h bytes per bank of RAM)/ (80 bytes per scan line) =
;		409 scan lines + 48 bytes extra  -->  offset of 410 scans
;
;	New vertical dimension of EGA = 350 + 410 = 760.
;-----------------------------------------------------------------------;

;;;WIN1 not present here
SSB_EXTRA_SCANS	equ	410
;;;NH		equ	SCREEN_HEIGHT + SSB_EXTRA_SCANS	;new display height
;;;
;;;ssb_device BITMAP <SCRSEL,W,NH,WB,P,B,0A0000000H,0,0,0,0,0,0,0>
ssb_device	label	byte

;-----------------------------------------------------------------------;
;	Palette contains the palette values for the EGA card
;	to give the desired colors.  The planes have been
;	changed from the normal EGA plane definition to be
;	C0 = red, C1 = green, C2 = blue.  The intensity bit
;	will be set for all the colors.
;-----------------------------------------------------------------------;

;;; WIN1 moved higher up
;;;Code_palette label	byte
;;;
;;;	db	00h			;Black
;;;	db	3Ch			;Red
;;;	db	3Ah			;Green
;;;	db	3Eh			;Yellow
;;;	db	39h			;Blue
;;;	db	3Dh			;Magenta
;;;	db	3Bh			;Cyan
;;;	db	3Fh			;White
;;;	db	00h			;Black
;;;	db	3Ch			;Red
;;;	db	3Ah			;Green
;;;	db	3Eh			;Yellow
;;;	db	39h			;Blue
;;;	db	3Dh			;Magenta
;;;	db	3Bh			;Cyan
;;;	db	3Fh			;White
;;;	db	0			;Overscan will be black

sEnd	Code
page

;-----------------------------------------------------------------------;
;	Color Table contains the color table definition.  The color
;	table is used for the GetColorTable Escape function and for
;	pen and brush enumeration.
;
;	This table must match the palette register values issued to
;	the EGA palette registers to get the colors in the color table.
;
;	The table is also used to take the color index which is
;	created for a GetPixel and turn it into a color which
;	sum_RGB_colors_alt can deal with.
;-----------------------------------------------------------------------;


COLOR_TBL_SIZE	equ	2		;2 entries in the table


sBegin	Code

sEnd	Code
page

sBegin	Code


dm_pen_and	label	byte
dm_pen_xor	label	byte
dm_data_r	label	byte
dm_flags	label	byte

	public	dm_pen_and, dm_pen_xor, dm_data_r, dm_flags

sEnd	Code
end
