	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	ENUM.ASM
;
;   This module contains routines which enumerate a subset of the
;   objects which the device can enumerate.
;
; Created: 16-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	Control
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   A subset of the fonts, pens, and brushes which this driver can
;   support are enumerated for the caller, until all objects of the
;   requested type have been enumerated or the caller aborts.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


;

incLogical	= 1			;Include control for gdidefs.inc
incFont 	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include macros.mac
	.list


	??_out	enum

	externA COLOR_TBL_SIZE		;# entries in the color table


sBegin	Code
assumes cs,Code

page
;--------------------------Exported-Routine-----------------------------;
; EnumDeviceFonts
;
;   Enumerate Device Fonts is called to enumerate the fonts available
;   on a given device.	For each appropriate font, the callback function
;   is called with the information for that font.  The callback function
;   is called until there are no more fonts or the callback function
;   returns zero.
;
;   Since this driver has no fonts to enumerate, all that need be done
;   is return a success flag (1).
;
; Entry:
;	None
; Returns:
;	AX = 1
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	None
; Calls:
;	None
; History:
;	Wed 12-Aug-1987 19:16:11 -by-  **** ***** [*****]
;	Made non-resident
;
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing

cProc	EnumDFonts,<FAR,PUBLIC,WIN,PASCAL>

	parmD	lp_device		;Physical device
	parmD	lp_face_name		;Face name
	parmD	lp_callback_func	;Callback function
	parmD	lp_client_data		;Data to pass the callback function

cBegin

	mov	ax,1			;This is a nop for this driver
	sub	bp,2
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	retf	10h

cEnd <nogen>
page
;--------------------------Exported-Routine-----------------------------;
; EnumObject
;
;   The given style of object is enumerated through a callback
;   facility.  Since there are only a few objects within this
;   particular driver, they will all be enumerated.
;
;   If the Callback function returns a zero, then the enumeration
;   will be terminated.
;
; Entry:
;	None
; Returns:
;	AX = last value returned from callback function.
;	AX = 1 if nothing was enumerated.
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	None
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing


cProc	EnumObj,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device
	parmW	style
	parmD	lp_callback_func
	parmD	lp_client_data

;;;	localW	old_SP
	localV	obj_area,%(size LogBrush)
	errnz	<(SIZE LogBrush)-(SIZE LogPen)-2>	;Want the biggest!

cBegin

;;;	mov	old_SP,sp		;Save SP for clean-up
	cmp	style,OBJ_PEN		;Pen?
	je	enum_pen		;  Yes
	cmp	style,OBJ_BRUSH 	;Brush?
	je	enum_brush		;  Yes
	mov	ax,1

exit_enum_obj:
;;;	mov	sp,old_SP		;Remove any return addresses from stack

	pop	di	;The Win2 cEnd is slightly different from the
	pop	si	;Win1 version
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	0Eh

cEnd <nogen>
page

;--------------------------Private-Routine------------------------------;
; enum_pen
;
;   The pens which this driver can realize are enumerated for
;   the caller until either all pens have been enumerated or
;   the user aborts.
;
;
;   This driver supports five styles of pens, in the number of
;   colors appropriate for the driver.
;
;   The NULL Pen is not enumerated.
;
; Entry:
;	None
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user's aborts enumeration
; Registers Preserved:
;	DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	do_color
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


enum_pen proc	near

	xor	si,si				;Initialize pen style
	mov	obj_area.lopnWidth.xcoord,si	;Set nominal width
	mov	obj_area.lopnWidth.ycoord,si	;Set width

enum_pen_10:
	mov	obj_area.lopnStyle,si		;Set style
	xor	di,di
enum_pen_20:
	mov	ax, di
	xor	ah, ah
	mov	wptr obj_area.lopnColor, di
	mov	wptr obj_area.lopnColor + 2, ax
	call	call_client
;;;	xor	di,wptr 0FFFFh
	db	81h, 0F7h, 0FFh, 0FFh		;Overlong XOR DI
	jnz	enum_pen_20
	inc	si				;Set next pen style
	cmp	si,LS_NOLINE			;At maximum line style?
	jb	enum_pen_10			;  No, continue

enum_pen_30:
	jmp	exit_enum_obj			;Done enumerating stuff

	errnz	LS_SOLID
	errnz	LS_DASHED-1
	errnz	LS_DOTTED-2
	errnz	LS_DOTDASHED-3
	errnz	LS_DASHDOTDOT-4
	errnz	LS_NOLINE-5			;Not enumerated
	errnz	MaxLineStyle-LS_NOLINE		;Should be no other pens

enum_pen endp
page
;--------------------------Private-Routine------------------------------;
; enum_brush
;
;   The brushes that the driver supports will be enumerated.
;
;   This driver supports 256K worth of ditherd brushes, so only
;   a few of them will enumerated.  These will be based on the
;   five grey scales defined in brush_colors.  All hatched brushes
;   will be enumerated.  The background color for hatched brushes
;   is not enumerated.
;
;   The Hollow Brush will not be enumerated.
;
; Entry:
;	None
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user's aborts enumeration
; Registers Preserved:
;	DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	do_color
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

;	The Logical colors that will be returned for the enumeration
;	of the solid brushes


	externB brush_colors 

NUMBER_GREYS equ 5

assumes ds,nothing
assumes es,nothing


enum_brush proc near

	xor	di,di
	mov	obj_area.lbStyle,di		;Set brush style
	errnz	BS_SOLID
	mov	obj_area.lbHatch,di		;Clear hatch index
	mov	di,2*NUMBER_GREYS		;Initialize blue index

enum_brush_10:
	mov	ax,wptr cs:brush_colors-2[di] 	;Get colour
	mov	wptr obj_area.lbColor[0],ax	
	xor	ah,ah
	mov	wptr obj_area.lbColor[2],ax
	call	call_client
	sub	di,2				;Out of red?
	jnz	enum_brush_10			;  No, continue


;	Now enumerate the hatched brushes.  When enumerating hatched
;	brushes, the background color is not enumerated.

	mov	obj_area.lbStyle, 2		;Set brush style
	mov	si,HS_DIAGCROSS 		;Initialize hatch index

enum_brush_40:
	mov	obj_area.lbHatch,si		;Set style
	xor	di,di
enum_brush_50:
	mov	ax, di
	xor	ah, ah
	mov	wptr obj_area.lbColor, di
	mov	wptr obj_area.lbColor + 2, ax
	call	call_client
;;;	xor	di,wptr 0FFFFh
	db	81h, 0F7h, 0FFh, 0FFh		;Overlong XOR DI
	jnz	enum_brush_50
	dec	si				;Set next hatch index
	jns	enum_brush_40			;For all hatch indexes
	jmp	enum_pen_30			;Done enumerating stuff

enum_brush endp
page
;--------------------------Private-Routine------------------------------;
; call_client
;
;   The client callback routine is called with the current
;   logical object in obj_area.
;
; Entry:
;	object in obj_area
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user aborts enumeration
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	[lp_callback_func] - user supplied callback procedure
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


call_client	proc	near

	lea	ax,obj_area
	farPtr	ptr1,ss,ax
	cCall	lp_callback_func,<ptr1,lp_client_data>
	pop	bx			;Return address
	or	ax,ax
	jz	enum_pen_30		;Client is bailing out
	jmp	bx			

call_client	endp
page

sEnd	Code

	ifdef	PUBDEFS
	include enum.pub
	endif

end
