        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.ASM
;
;   This module contains functions and definitions specific to
;   the IBM CGA Monochrome Display Driver.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	physical_enable
;			physical_disable
;
; Public Data:
;		PHYS_DEVICE_SIZE		info_table_base
;		BW_THRESHOLD			physical_device
;		COLOR_FORMAT			interlace_adjust
;		SCREEN_W_BYTES			rot_bit_tbl
;		SCREEN_WIDTH			color_table
;		SCREEN_HEIGHT			ScreenSelector
;		COLOR_TBL_SIZE			BlueMoonSeg_colo_table
;		Y_SHIFT_COUNT			PixelSeg_interlace_adjust
;		EVEN_SCAN_INC			LineSeg_interlace_adjust
;		ODD_SCAN_INC			ScanlineSeg_interlace_adjust
;		TOGGLE_EVEN_ODD 		BlueMoonSeg_interlace_adjust
;		EVEN_SCAN_INC_D
;		ODD_SCAN_INC_D
;		TOGGLE_EVEN_ODD_D
;		EVEN_INC_LESS_ODD_INC
;
;		HYPOTENUSE
;		Y_MAJOR_DIST
;		X_MAJOR_DIST
;		Y_MINOR_DIST
;		X_MINOR_DIST
;		MAX_STYLE_ERR
;
;		 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
;		 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
;		 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
;		 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
;		D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
;		D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
;		D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
;		D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
;		CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
;		CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
;		DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
;		DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include	cursor.inc
	include gdidefs.inc
	include genius.inc
	include display.inc
	include macros.mac
	include genius.inc
	.list


	public	PHYS_DEVICE_SIZE	;Number of bytes in physical device
	public	BW_THRESHOLD		;Black/white threshold
	public	COLOR_FORMAT		;Color format
	public	SCREEN_W_BYTES		;Screen width in bytes
	public	SCREEN_WIDTH		;Screen width in pixels
	public	SCREEN_HEIGHT		;Screen height in scans
	public	COLOR_TBL_SIZE		;Number of entries in color table
	public	ScreenSelector		;Segment of Regen RAM

	public	physical_enable 	;Enable routine
	public	physical_disable	;Disable

	public	physical_device 	;Physical device descriptor
	public	info_table_base 	;GDIInfo table base address

;	public	Y_SHIFT_COUNT
	public	ODD_SCAN_INC
	public	EVEN_SCAN_INC
	public	TOGGLE_EVEN_ODD
	public	ODD_SCAN_INC_D
	public	EVEN_SCAN_INC_D
	public	TOGGLE_EVEN_ODD_D
	public	EVEN_INC_LESS_ODD_INC

	public	HYPOTENUSE
	public	Y_MAJOR_DIST
	public	X_MAJOR_DIST
	public	Y_MINOR_DIST
	public	X_MINOR_DIST
	public	MAX_STYLE_ERR

	public	rot_bit_tbl

	public	 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
	public	 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
	public	 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
	public	 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
	public	D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
	public	D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
	public	D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
	public	D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
	public	CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
	public	CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
	public	DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
	public	DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7






;-----------------------------------------------------------------------;
;	The hatched brush pattern definitions
;-----------------------------------------------------------------------;

H_HATCH_BR_0	equ	11111111b	;Horizontal Hatched brush
H_HATCH_BR_1	equ	11111111b
H_HATCH_BR_2	equ	11111111b
H_HATCH_BR_3	equ	11111111b
H_HATCH_BR_4	equ	00000000b
H_HATCH_BR_5	equ	11111111b
H_HATCH_BR_6	equ	11111111b
H_HATCH_BR_7	equ	11111111b

V_HATCH_BR_0	equ	11110111b	;Vertical Hatched brush
V_HATCH_BR_1	equ	11110111b
V_HATCH_BR_2	equ	11110111b
V_HATCH_BR_3	equ	11110111b
V_HATCH_BR_4	equ	11110111b
V_HATCH_BR_5	equ	11110111b
V_HATCH_BR_6	equ	11110111b
V_HATCH_BR_7	equ	11110111b

D1_HATCH_BR_0	equ	01111111b	;\ diagonal brush
D1_HATCH_BR_1	equ	10111111b
D1_HATCH_BR_2	equ	11011111b
D1_HATCH_BR_3	equ	11101111b
D1_HATCH_BR_4	equ	11110111b
D1_HATCH_BR_5	equ	11111011b
D1_HATCH_BR_6	equ	11111101b
D1_HATCH_BR_7	equ	11111110b

D2_HATCH_BR_0	equ	11111110b	;/ diagonal hatched brush
D2_HATCH_BR_1	equ	11111101b
D2_HATCH_BR_2	equ	11111011b
D2_HATCH_BR_3	equ	11110111b
D2_HATCH_BR_4	equ	11101111b
D2_HATCH_BR_5	equ	11011111b
D2_HATCH_BR_6	equ	10111111b
D2_HATCH_BR_7	equ	01111111b

CR_HATCH_BR_0	equ	11110111b	;+ hatched brush
CR_HATCH_BR_1	equ	11110111b
CR_HATCH_BR_2	equ	11110111b
CR_HATCH_BR_3	equ	11110111b
CR_HATCH_BR_4	equ	00000000b
CR_HATCH_BR_5	equ	11110111b
CR_HATCH_BR_6	equ	11110111b
CR_HATCH_BR_7	equ	11110111b

DC_HATCH_BR_0	equ	01111110b	;X hatched brush
DC_HATCH_BR_1	equ	10111101b
DC_HATCH_BR_2	equ	11011011b
DC_HATCH_BR_3	equ	11100111b
DC_HATCH_BR_4	equ	11100111b
DC_HATCH_BR_5	equ	11011011b
DC_HATCH_BR_6	equ	10111101b
DC_HATCH_BR_7	equ	01111110b




;-----------------------------------------------------------------------;
;	Line style definitions for the EGA Card
;
;	Since the style update code in the line DDA checks for a sign,
;	the values chosen for distances, HYPOTENUSE, and MAX_STYLE_ERR
;	must not be bigger than 127+min(X_MAJOR_DIST,Y_MAJOR_DIST).  If
;	this condition is met, then the sign bit will always be cleared
;	on the first subtraction after every add-back.
;-----------------------------------------------------------------------;


HYPOTENUSE	=	20		;Distance moving X and Y
Y_MAJOR_DIST	=	14		;Distance moving Y only
X_MAJOR_DIST	=	14		;Distance moving X only
Y_MINOR_DIST	=	HYPOTENUSE-X_MAJOR_DIST
X_MINOR_DIST	=	HYPOTENUSE-Y_MAJOR_DIST
MAX_STYLE_ERR	=	HYPOTENUSE*2	;Max error before updating
					;  rotating bit mask



;-----------------------------------------------------------------------;
;	The black/white threshold is used to determine the split
;	between black and white when summing an RGB Triplet
;-----------------------------------------------------------------------;


BW_THRESHOLD	equ	(3*0FFh)/2
page

;	The odd row increment is the value used when incrementing from
;	an odd scan line to an even scan line, with an increasing Y.
;
;	The even row increment is the value used when incrementing from
;	an even scan line to an odd scan line, with an increasing Y.
;
;	The even-odd toggle value is the XOR mask used to toggle the
;	odd row increment to the next even row for an increasing Y.


EVEN_SCAN_INC		equ	02000h
ODD_SCAN_INC		equ	0E050h
TOGGLE_EVEN_ODD		equ	0C050h
EVEN_INC_LESS_ODD_INC	equ	EVEN_SCAN_INC-ODD_SCAN_INC


;	Same as above, but going down.

EVEN_SCAN_INC_D		equ	01FB0h
ODD_SCAN_INC_D		equ	0E000h
TOGGLE_EVEN_ODD_D	equ	0FFB0h

page

sBegin	Code
assumes cs,Code


SCREEN_W_BYTES	equ	SCAN_BYTES*1	;Screen width in bytes
COLOR_FORMAT	equ	0101h


;-----------------------------------------------------------------------;
;	PhysDeviceSize is the number of bytes that the enable routine
;	is to copy into the passed PDevice block before calling the
;	physical_enable routine.  For this driver, the length is the
;	size of the bitmap structure.
;-----------------------------------------------------------------------;

PHYS_DEVICE_SIZE equ	size BITMAP



;-----------------------------------------------------------------------;
;	Allocate the physical device block for the EGA Card.
;	For this driver, physical devices will be in the same format
;	as a normal bitmap descriptor.	This is very convienient since
;	it simplifies the structures that the code must work with.
;
;	The bmWidthPlanes field will be set to zero to simplify some
;	of the three plane code.  By setting it to zero, it can be
;	added to a memory bitmap pointer without changing the pointer.
;	This allows the code to add this in regardless of the type of
;	the device.
;
;	The actual physical block will have some extra bytes stuffed on
;	the end (IntPhysDevice structure), but only the following is static
;-----------------------------------------------------------------------;

ScreenSelector  equ     0A000H
SCREEN_HEIGHT   equ     1004


;	The following constants keep the parameter list to BITMAP within
;	view on an editing display 80 chars wide.

SCRSEL		equ	ScreenSelector
P		equ	 COLOR_FORMAT AND 000FFh	;# color planes
B		equ	(COLOR_FORMAT AND 0FF00h) SHR 8	;# bits per pixel
H		equ	SCREEN_HEIGHT			;new display height
W		equ	SCREEN_WIDTH			;display width, pels
WB		equ	SCREEN_W_BYTES			;display width, bytes

physical_device BITMAP <SCRSEL,W,H,WB,P,B,0A0000000H,0F600h,0,0,0,0,0,0>



;-----------------------------------------------------------------------;
;	The GDIInfo data Structure.  The specifics of the Hercules
;	mode are passed to GDI via this structure.
;-----------------------------------------------------------------------;


info_table_base label byte


	dw	100h			;Version = 1.00
	errnz	dpVersion

	dw	DT_RASDISPLAY		;Device classification
	errnz	dpTechnology-dpVersion-2

	dw	185			;Horizontal size in millimeters
	errnz	dpHorzSize-dpTechnology-2

	dw	255			;Vertical size in millimeters
	errnz	dpVertSize-dpHorzSize-2

	dw	SCREEN_WIDTH		;Horizontal width in pixels
	errnz	dpHorzRes-dpVertSize-2

	dw	SCREEN_HEIGHT		;Vertical width in pixels
	errnz	dpVertRes-dpHorzRes-2

	dw	1			;Number of bits per pixel
	errnz	dpBitsPixel-dpVertRes-2

	dw	1			;Number of planes
	errnz	dpPlanes-dpBitsPixel-2

	dw	65+6+6			;Number of brushes the device has
	errnz	dpNumBrushes-dpPlanes-2 ;  (Show lots of brushes)

	dw	10			;Number of pens the device has
	errnz	dpNumPens-dpNumBrushes-2;  (2 colors * 5 styles)

	dw	0			;Reserved

	dw	0			;Number of fonts the device has
	errnz	dpNumFonts-dpNumPens-4

	dw	2			;Number of colors in color table
	errnz	dpNumColors-dpNumFonts-2

	dw	size int_phys_device	;Size required for device descriptor
	errnz	dpDEVICEsize-dpNumColors-2

	dw	CC_NONE 		;Curves capabilities
	errnz	dpCurves-dpDEVICEsize-2

	dw	LC_POLYLINE+LC_STYLED	;Line capabilities
	errnz	dpLines-dpCurves-2

	dw	PC_SCANLINE		;Polygonal capabilities
	errnz	dpPolygonals-dpLines-2

	dw	TC_CP_STROKE+TC_RA_ABLE ;Text capabilities
	errnz	dpText-dpPolygonals-2

	dw	CP_NONE 		;Clipping capabilities
	errnz	dpClip-dpText-2

					;BitBlt capabilities
;;;	dw	RC_BITBLT+RC_BITMAP64+RC_GDI20_OUTPUT+RC_SAVEBITMAP
	dw	RC_BITBLT		;WIN1 can only do RC_BITBLT
	errnz	dpRaster-dpClip-2

	dw	X_MAJOR_DIST		;Distance moving X only
	errnz	dpAspectX-dpRaster-2

	dw	Y_MAJOR_DIST		;Distance moving Y only
	errnz	dpAspectY-dpAspectX-2

	dw	HYPOTENUSE		;Distance moving X and Y
	errnz	dpAspectXY-dpAspectY-2

	dw	MAX_STYLE_ERR		;Length of segment for line styles
	errnz	dpStyleLen-dpAspectXY-2


	errnz	dpMLoWin-dpStyleLen-2	;Metric  Lo res WinX,WinY,VptX,VptY
	dw	1850			;  HorzSize * 10
	dw	2551			;  VertSize * 10
	dw	728			;  HorizRes
	dw	-1004			;  -VertRes


	errnz	dpMHiWin-dpMLoWin-8	;Metric  Hi res WinX,WinY,VptX,VptY
	dw	18492			;  HorzSize * 100
	dw	25502			;  VertSize * 100
	dw	728			;  HorizRes
	dw	-1004			;  -VertRes


	errnz	dpELoWin-dpMHiWin-8	;English Lo res WinX,WinY,VptX,VptY
	dw	4623			;  HorzSize * 1000 scaled(/640)
	dw	2551			;  VertSize * 1000 scaled(/700)
	dw	4623			;  HorizRes * 254  scaled(/640)
	dw	-2551			;  -VertRes * 254  scaled(/700)


	errnz	dpEHiWin-dpELoWin-8	;English Hi res WinX,WinY,VptX,VptY
	dw	11557			;  HorzSize * 10000 scaled(/640)
	dw	25502			;  VertSize * 10000 scaled(/700)
	dw	1156			;  HorizRes * 254   scaled(/640)
	dw	-2551			;  -VertRes * 254   scaled(/700)


	errnz	dpTwpWin-dpEHiWin-8	;Twips		WinX,WinY,VptX,VptY
	dw	8325			;  HorzSize * 14400 scaled(/640)
	dw	18361			;  VertSize * 14400 scaled(/700)
	dw	578			;  HorizRes * 254   scaled(/640)
	dw	-1275			;  -VertRes * 254   scaled(/700)


	dw	96			;Logical Pixels/inch in X
	errnz	dpLogPixelsX-dpTwpWin-8

	dw	96			;Logical Pixels/inch in Y
	errnz	dpLogPixelsY-dpLogPixelsX-2

	dw	DC_IgnoreDFNP		;dpDCManage
	errnz	dpDCManage-dpLogPixelsY-2

	dw	0			;Reserved fields
	dw	0
	dw	0
	dw	0
	dw	0


	errnz	<(offset $)-(offset info_table_base)-(size GDIINFO)>

;;; WIN1 -- was in pixel.asm in win2
rot_bit_tbl     label   byte
                db      10000000b       ;Table to map bit index into
                db      01000000b       ;  a bit mask 
                db      00100000b 
                db      00010000b
                db      00001000b 
                db      00000100b
                db      00000010b
                db      00000001b
page
;	Constants and macro for changing the screen mode of the IBM/PC display

SET_MODE	equ	0
READ_MODE	equ	15
TEXT_MODE	equ	3
GRAPHICS_MODE	equ	0Fh

video_io	macro	func,arg
	mov	ah,func
	ifnb	<arg>
		mov	al,arg
	endif
	int	10h
endm
page

;---------------------------Public-Routine------------------------------;
; physical_enable
;
;   EGA 640x350 graphics mode is enabled.
;
; Entry:
;	ES:DI --> ipd_format in our pDevice
;	DS:    =  Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	AX = 0
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,Data
	assumes es,nothing

physical_enable proc near

	mov	ax,0F00h		;Save old mode
	int	10h
	stosb
	mov	dx, CGA_CONTROL
	mov	al, 0
	out	dx, al			;Disable graphics display
	mov	ax, 0F000h
	xor	bx, bx
	int	10h			;Check for presence of VHRBIOS
	cmp	bx, 'OK'
	jz	vhr_present
	xor	ax, ax
	ret
;
vhr_present:
	mov	dx, MDA_CONTROL
	mov	al, 0
	out	dx, al			;Disable text display
	mov	dx, GENIUS_CONTROL
	mov	al, 1			;Enable full VRAM
	out	dx, al
	call	init_vram
	mov	dx, CGA_CONTROL
	mov	al, 8			;Enable graphics display
	out	dx, al
	mov	al, 1
	ret
physical_enable endp
page

;---------------------------Public-Routine------------------------------;
; physical_disable
;
;   EGA 640x350 graphics mode is exited.  The previous mode of the
;   adapter is restored.
;
; Entry:
;	DS:SI --> int_phys_device
;	ES:    =  Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	None
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,nothing
	assumes es,Data

physical_disable proc near

	mov	dx, CGA_CONTROL
	mov	al, 0
	out	dx, al			;Disable graphics display
	call	init_vram
	mov	dx, GENIUS_CONTROL
	mov	al, 0
	out	dx, al			;Disable extra vram
	mov	al,[si].ipd_format
	xor	ah,ah
	int	10h			;Select previous mode
	mov	al,1
	ret

physical_disable endp

init_vram	proc near

	cld
	mov	di, 0B000h	;Clear text screen to spaces
	mov	ax, 2007h
	mov	cx, 4000h
	call	setmem
	mov	di, 0A000h
	call	zap_64k
	mov	di, 0B800h
zap_64k:	
	xor	ax, ax
	mov	cx, 8000h
setmem:
	mov	es, di
	xor	di, di
	rep	stosw
 	ret

init_vram	endp

sEnd	Code
page

;-----------------------------------------------------------------------;
;	Color Table contains the color table definition.  The color
;	table is used for the GetColorTable Escape function and for
;	pen and brush enumeration.
;
;	This table must match the palette register values issued to
;	the EGA palette registers to get the colors in the color table.
;
;	The table is also used to take the color index which is
;	created for a GetPixel and turn it into a color which
;	sum_RGB_colors_alt can deal with.
;-----------------------------------------------------------------------;


COLOR_TBL_SIZE	equ	2		;2 entries in the table

	public	snipflg
snipflg	label	byte
end
