        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.INC
;
; This file contains a handful of constants used by the CGA driver.
;
; Created: 27-Dec-2025
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;


STEPBACK	equ	07FA6h		;8000h - 5Ah

Y_STEP		equ	2000h

;
; The Genius framebuffer is split across two segments, A000 and B800.
;
GENIUS_SEG1	equ	0A000h
GENIUS_SEG2	equ	0B800h

GENIUS_CONTROL	equ	03B0h		;Genius control register
CGA_CONTROL	equ	03D8h		;CGA control register
MDA_CONTROL	equ	03B8h		;MDA control register

;
; These macros switch to one or other video segment.
;
SEGLOW	macro
	push	di
	mov	di, GENIUS_SEG1
	nop
	mov	ds, di
	pop	di
	endm

SEGHI	macro
	push	di
	mov	di, GENIUS_SEG2
	nop
	mov	ds, di
	pop	di
	endm

;	EGA Register Definitions.
;
;	The following definitions are the EGA registers and values
;	used by this driver.  All other registers are set up when
;	the EGA is placed into graphics mode and never altered
;	afterwards.
;
;	All unspecified bits in the following registers must be 0.


EGA_BASE	equ	300h		;Base address of the EGA (3xx)


