	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	COLORINF.ASM
;
; This module contains the color information routine.
;
; Created: 16-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	ColorInf
;
; Public Functions:	im1024_get_rgb
;
; Public Data:		none
;
; General Description:
;
;   ColorInfo is called by GDI to either convert a logical color
;   (an RGB triplet) to a physical color, or a phsyical color to
;   a logical color.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include im1024.inc
	include macros.mac
	.list


	??_out	colorinf


	ifdef	GEN_COLOR
	externA COLOR_FORMAT		;Color format (0103h or 0104h)
	endif


sBegin	Code
assumes cs,Code

	externNP	im1024_exclude
	externNP	im1024_send
	externNP	im1024_r_byte
	externNP	map_RGB_colors
	externNP	im1024_unexclude

im1024_lut8rd	dw	2
		db	IM1024_LUT8RD, 0
rgb		db	3 dup(0)


;;	externNP sum_RGB_colors_alt
page

;--------------------------Exported-Routine-----------------------------;
;
; ColorInfo
;
;   ColorInfo accepts a logical RGB color value and returns the
;   logical RGB color value that the device can most closely represent.
;   ColorInfo also returns the device dependent, physical representation
;   of bits necessary to display the specified color on the device.
;   This information will be passed back into the driver by GDI.  GDI
;   will do no interpreting of the physical color.
;
;   Colorinfo may also be requested to convert a physical color into
;   a logical RGB color.  This is indicated by a NULL lp_phys_bits.
;   Since this driver maintains logical and physical colors as one
;   in the same (i.e. logical white is xxFFFFFFH and physical white
;   is xxFFFFFFH), we can just pass the physical color back as the
;   logical color!  GDI will only call us to convert our own physical
;   color that was returned by this driver, so this is safe.
;
;   The lpDevice may be a pointer to our device or to a memory bitmap.
;   If it is to a monochrome memory bitmap, then the color must be
;   interpreted as black/white, else it must be interpreted as one of
;   the RGB colors supported in color mode.
;
; Entry:
;	None
; Returns:
;	DX:AX = physical color or logical color as appropriate
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	sum_RGB_colors_alt
; History:
;	Mon 16-Feb-1987 18:09:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing

cProc	ColorInfo,<FAR,PUBLIC,WIN,PASCAL>,<di,es>

	parmD	lp_device		;Pointer to device
	parmD	color_in		;Input color (RGB or physical)
	parmD	lp_phys_bits		;Pointer to physical bit field

cBegin
	les	ax,lp_phys_bits
	mov	dx,es
	or	ax,dx
	jz	color_info_10		;Return logical colour
	les	ax, color_in
	mov	dx, es
	call	map_RGB_colors
	les	di, lp_phys_bits
	mov	es:[di],dh
	xor	dh,dh
	jmp	short color_info_20

color_info_10:
	mov	ax,color_in
	call	im1024_get_rgb

color_info_20:
	pop	es
	pop	di
	sub	bp, 2
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	retf	0Ch

cEnd	<nogen>

	public	im1024_get_rgb

im1024_get_rgb	proc	near
	push	ds
	mov	di, cs
	mov	ds, di
	mov	es, di
assumes	ds,Code
assumes	es,Code	
	mov	bx,-1
	push	bx
	push	bx
	push	bx
	push	bx
	call	im1024_exclude
	mov	si, offset im1024_lut8rd
	mov	[si+3], al		;Read palette entry AL
	call	im1024_send
	mov	cx, 3
	mov	di, offset rgb
get_rgb_1:
	call	im1024_r_byte
	jc	get_rgb_1		;Byte not ready yet?
	mov	[di],al
	inc	di
	loop	get_rgb_1
	mov	ax, word ptr cs:rgb
	mov	dl, byte ptr cs:rgb+2
	xor	dh,dh
	call	im1024_unexclude
	pop	ds
	ret

im1024_get_rgb	endp
	

sEnd	Code
end
