	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CONTROL.ASM
;
; This module contains the escape handler for the color display
; drivers.
;
; It also contains stubs for the SetAttribute function and the
; DeviceBitmap function, both of which this driver does not
; support.
;
; Created: 16-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	Control
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Control is the routine which is called when an Escape call
;   is made to GDI.  This driver only implements two of the
;   escape functions.  These functions set and get the color
;   table.  Since the color table is not setable for the display,
;   the current value is just returned.
;
;   Support for QUERYESCSUPPORT has now been added.  This escape
;   function is required of all drivers.  It informs the caller
;   which escape functions are supported (QUERYESCSUPPORT will
;   return TRUE for QUERYESCSUPPORT!).
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incControl	=	1		;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include im1024.inc
	include macros.mac
	.list

	externNP	im1024_get_rgb
	externNP	im1024_exclude
	externNP	im1024_send
	externNP	im1024_unexclude

	??_out	Control

sBegin	Code
assumes cs,Code

im1024_lut8	dw	5
		db	IM1024_LUT8, 0, 0, 0, 0

page
;--------------------------Exported-Routine-----------------------------;
; Control
;
;   Control is defined so that device specific commands can be issued
;   that are not supported by GDI.  Some of the Control functions have
;   been defined by GDI so that devices that can perform them (and need
;   to) can do so, such as clear device.
;
;   Clear device will not be allowed.  Nobody should do that to the
;   system console!
;
;   Set/Get color table will be implemented.  GetColorTable will
;   return the color in the table for the index passed.
;
;   SetColorTable should return the color that was actually set
;   into the table.  Since this driver doesn't allow setting the
;   color table, the Set function is the same as the Get function.
;
; Entry:
;	None
; Returns:
;	AX = 1 if success
; Error Returns:
;	AX = 0 if error
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	None
; History:
;	Sun 27-Sep-1987 21:35:42 -by-  **** ***** [*****]
;	Added QUERYESCSUPPORT, which is the one required
;	escape function all drivers must support.
;
;	When queried if we support SETCOLORTABLE, we'll
;	return false.  The code will continue to return
;	current color table index if we get the SETCOLORTABLE
;	call.
;
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	made non-resident
;
;	Wed 18-Mar-1987 14:04:30 -by-  **** ***** [*****]
;	Added COLOR_TBL_SIZE so the code can be shared
;	between black/white and color drivers.
;
;	Mon 16-Feb-1987 18:09:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing

cProc	Control,<FAR,PUBLIC,WIN,PASCAL>,<si,di,es>

	parmD	lp_device
	parmW	function
	parmD	lp_in_data
	parmD	lp_out_data

cBegin
	xor	ax,ax			;Assume error
;;;	mov	bx,function
	cmp	function,SETCOLORTABLE	;Process set/get color table
	je	is_color_table
	cmp	function,GETCOLORTABLE
	jnz	exit_control
is_color_table:
	push	ds
	lds	si,lp_in_data		;Get pointer to the data
	lodsb				;Get color table index
	pop	ds			
	cmp	function,SETCOLORTABLE
	jz	set_colour
	call	im1024_get_rgb
	les	di,lp_out_data
	stosw
	mov	al,dl
	xor	ah,ah
	stosw
	mov	al, 1
	jmp	short exit_control
;
set_colour:
	push	cs
	pop	ds
	mov	bx,-1
	push	bx
	push	bx
	push	bx
	push	bx
	call	im1024_exclude
	push	ds
	lds	si,lp_out_data
	mov	bx,[si]
	mov	cl,[si+2]
	pop	ds
	mov	si, offset im1024_lut8
	mov	[si+3],al	;Ink
	mov	[si+4],bx	;RG
	mov	[si+6],cl	;B
	call	im1024_send
	call	im1024_unexclude
	mov	ax,1
exit_control:
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp	
	pop	ds
	pop	bp
	dec	bp
	retf	0Eh

cEnd	<nogen>
	





sEnd	Code

	ifdef	PUBDEFS
	include control.pub
	endif

end
