        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	ENABLE.ASM
;
; This module contains the routines to switch the IM1024 in and out of
; its 1024x800 graphics mode.
; elsewhere.
;
; Exported Functions:	DeviceMode
;			Enable
;			Disable
;
;-----------------------------------------------------------------------;

incDevice	= 1

	.xlist
	include cmacros.inc
	include windefs.inc
	include gdidefs.inc
	include im1024.inc
	include cursor.inc
	.list

sBegin	Data
		externB screen_busy
		externB	cur_flags
		externW cursor_x
		externW	cursor_y

		externB cur_needs_update
;;;		externW CUR_HEIGHT

;;;		externA CUR_ROUND_LEFT
;;;		externA	CUR_ROUND_RIGHT	

sEnd	Data

CUR_OFF 	equ	10000000b	;  Null cursor has been specified
CUR_EXCLUDED	equ	01000000b	;  Cursor has been excluded

IS_BUSY		equ	0FFh
NOT_BUSY	equ	0

RECT_PRES	equ	1
RECT_NOT_PRES	equ	0

sBegin	Code
       		externNP physical_enable        ;Enable routine
       		externNP physical_disable       ;Disable routine
	        externB  physical_device        ;Device physical data   
		externB	info_table_base		;GDIInfo table
		externA	PHYS_DEVICE_SIZE	;Size of physical device
		externW y_origin
		externNP cursor_off
		externNP im1024_move_cursor	

assumes cs,Code


	public	Enable
page
;--------------------------Exported-Routine-----------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
;
; Enable - Enable Device
;
; The given device is either initialized or the GDI information
; for the given device is returned.
;
; If style=InquireInfo, then GDI is asking that the parameters
; passed be interpreted and the appropriate GDI information
; for the device be returned in lpDevice.
;
; If style=EnableDevice, then GDI is requesting that the device
; be initialized and lpDevice be initialized with whatever
; data is needed by the device.
;
; The three other pointers passed in will be the same for both
; calls, allowing for the device to request only the minimum
; required for a device that is supported.  These will be
; ASCIIZ strings or NULL pointers if no parameter was given.
; These strings are ignored by the display drvier.
;
; For the inquire function, the number of bytes of GDIINFO placed
; into lpDevice is returned.  For the enable function, non-zero is
; returned for success.  In both cases, zero is returned for an error.
;
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	PhysicalEnable
; History:
;  Mon 21-Sep-1987 00:20:57 -by-  **** ***** [*****]
; Added call to hook_int_2Fh
;
;  Wed 12-Aug-1987 17:16:37 -by-  **** ***** [*****]
; Made non-resident.
;
;  Tue 19-May-1987 22:01:34 -by-  *** ****** [******]
; Added code to modify GDI info table if EGA doesn't have enough
; memory to make use of save_screen_bitmap
;
;  Fri 26-Jun-1987 15:00:00 -by-  *** ****** [******]
; Removed code mentioned above and put it in EGAINIT.ASM, in an INIT
; segment.  This restores the integrity of the device-dependence levels
; within the Mondo Tree Structure of Death.
;
;  Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
; Initial version
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
; {
;   if (style == inquire)
;   {
;	*(GDIINFO)lpDevice = (GDIINFO)info_table_base; //copy GDIINFO
;	return (sizeof(GDIINFO));
;   }
;
;   *lpDevice = (DEVICE)physical_device;    //Initialize Physical device
;   hook_int_2Fh();
;   return(physical_enable(lpDevice));	    //Initialize hardware
; }
;-----------------------------------------------------------------------;


;	Define _cstods.  This location will contain our data segment value.
;	Since our data segment is a single fixed data segment, this will
;	work.  Interrupt code and some other routines will need access
;	to the data segment.


	org	$+1			;The data segment value will
_cstods label	word			;  be stuffed here and kept
	org	$-1			;  current by the kernel
	public	_cstods



	assumes ds,Data
	assumes es,nothing

cProc	Enable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Physical device or GDIinfo destination
	parmW	style			;Style, Enable Device, or Inquire Info
	parmD	lp_device_type		;Device type (i.e FX80, HP7470, ...)
	parmD	lp_output_file		;DOS output file name (if applicable)
	parmD	lp_stuff		;Device specific information

cBegin
	mov	ax,cs			;Set up ds=cs
	mov	ds,ax
	assumes ds,Code

	cld
	les	di,lp_device		;--> device structure or GDIinfo dest.
	assumes es,nothing

	and	style,word ptr InquireInfo	;Is this the inquire function?

	jnz	inquire_gdi_info	;  Yes, return GDIinfo
	errnz	InquireInfo-00000001b
	errnz	EnableDevice-00000000b
	errnz	InfoContext-8000h	;Ignore infomation context flag

;	Initialize passed device block

	lea	si,physical_device	;DS:SI --> physical device to copy
	mov	cx,PHYS_DEVICE_SIZE	;Set move count
	rep	movsb
	assumes ds,Data

;;;	call	hook_int_2Fh		;Hook into multiplexed interrupt
	call	physical_enable 	;Enable device
	jmp	short exit_enable
page

;	inquire_gdi_info - Inquire Device Specific Information
;
;	The GDI device specific information is returned to the caller
;
;	The information is based on the three pointers passed in.
;	Normally this data would be interpreted and the correct
;	GDINFO returned.  This allows for dynamically returning
;	the info based on the specifics of the device actually
;	being used (i.e. a driver supporting two similar plotters
;	could return the extents of the actual plotter in use).
;
;	These parameters are ignored for display drivers.
;
;	Currently:
;		ES:DI --> where GDIINFO goes
;		DS    =   CS

inquire_gdi_info:
	lea	si,info_table_base
	mov	cx,size GDIINFO
	mov	ax,cx			;return size of GDIInfo
	rep	movsb

;;;	pop	ds
;;;	assumes ds,Data
;;;	mov	bx,ssb_mask
;;;	and	es:[di].dpRaster[-size GDIINFO],bx

exit_enable:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	12h
cEnd	<nogen>
	

page
;--------------------------Exported-Routine-----------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
;
; The display driver's physical disable routine is called to disable
; graphics and enter a character mode of operation.
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	physical_disable
; History:
;	Tue 18-Aug-1987 18:06:47 -by-  **** ***** [*****]
;	Pass ES = Data to physical disable
;
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	Made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
; {
;   physical_disable(lpPDevice);	// Do all the work here
;   return(-1); 			// Show success
; }
;-----------------------------------------------------------------------;

	public	Disable

cProc	Disable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device

cBegin

;;;	push	ds			;To break less drivers, pass
;;;	pop	es			;  DGROUP in ES instead of DS
;;;	assumes	es,Data

	lds	si,lp_device		;--> logical device
	assumes ds,nothing

;;;	push	es			;physical_disable can destroy ES
	call	physical_disable	;Restore device
;;;	pop	es			;need DGROUP in ES for restore_int_2Fh
	assumes	es,Data
;;;	call	restore_int_2Fh
	mov	ax,-1			;Show success
	
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4
cEnd	<nogen>


page
;--------------------------Exported-Routine-----------------------------;
; MoveCursor - Move Cursor To Given Coordinate
;
;   This is a private entry point within the display driver for the
;   Window Manager.
;
;   The current cursor location is set to the given coordinates.
;   If the cursor is visible, it will be moved to the new location.
;   If the cursor is off (a NULL cursor), or if the cursor has been
;   excluded, then just the cursor location will be updated.
;
;   If the cursor is on and the new cursor position will cause the
;   cursor to be excluded, it will be removed from the screen.
;
; Entry:
;	None
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude_test
;	cursor_off
;	draw_cursor
; History:
;	Sun 15-Feb-1987 16:47:15 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; void MoveCursor(abs_x,abs_y)
; SWORD abs_x;				// x coordinate of cursor
; SWORD abs_y;				// y coordinate of cursor
; {
;   WORD    old_busy;
;
;   enter_crit();			// Updating the real X,Y is
;   real_x = abs_x - hot_x;		//   a critical section
;   real_y = abs_y - hot_y;
;   old_busy = IS_BUSY; 		// Try for screen semephore
;   swap(screen_busy,old_busy);
;   leave_crit();
;
;   if (old_busy == NOT_BUSY)
;   {
;	while(cursor positions disagree)
;	{
;	    if (cursor hidden || already excluded)
;	    {
;		screen_busy = NOT_BUSY;
;		return();
;	    }
;	    if (newly excluded)
;	    {
;		cur_flags = CUR_EXCLUDED;
;		cursor_off();
;		screen_busy = NOT_BUSY;
;		return();
;	    }
;	    draw_cursor();		// can actually draw cursor
;	}
;	screen_busy = NOT_BUSY; 	// others can have the screen now
;   }
;   return();
; }
;-----------------------------------------------------------------------;


cProc	MoveCursor,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmW	abs_x			;x coordinate of cursor
	parmW	abs_y			;y coordinate of cursor

cBegin

	assumes ds,Data 		;Set by prologue
	assumes es,nothing		;Have no idea what's in it

	push	es
	push	ax
	push	bx

	EnterCrit			;Moving is a critical section

	push	word ptr screen_busy
	cmp	screen_busy, IS_BUSY
	jz	move_cur5
	mov	screen_busy, IS_BUSY
	mov	ax,abs_x		;Get the new cursor position,
	cmp	ax,0
	jg	move_cur1
	mov	ax,0			;Force it to be onscreen
move_cur1:	
	cmp	ax, SCREEN_WIDTH
	jc	move_cur2
	mov	ax, SCREEN_WIDTH-1
move_cur2:
	mov	bx, abs_y
	cmp	bx, 0
	jg	move_cur3
	mov	bx, 1
move_cur3:
	cmp	bx, SCREEN_HEIGHT
	jc	move_cur4
	mov	bx, SCREEN_HEIGHT-1
move_cur4:
	call	cursor_off
	mov	cursor_x, ax
	mov	cursor_y, bx
	call	im1024_move_cursor
	pop	word ptr screen_busy
move_cur5:
	LeaveCrit
	pop	bx
	pop	ax
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	retf	4

cEnd	<nogen>
page
;--------------------------Exported-Routine-----------------------------;
; CheckCursor - Check On The Cursor
;
;   This is a private entry point within the display driver for the
;   Window Manager.
;
;   The cursor is checked to see if it can be unexcluded, and if so
;   it is unexcluded.  This is the only routine which can cause the
;   cursor to become visible once it has become invisible (excluded
;   by a drawing operation or turned off because of a new shape being
;   set).
;
;   It is expected that this routine be called at a rate close to once
;   every quarter of a second.	This allows for a lazy redraw of the
;   cursor whenever it has become excluded.
;
;   If the screen is busy (due to a current cursor operation), the
;   cursor is turned off, or it isn't excluded, then there is nothing
;   for this routine to do.  If the cursor is excluded, then a hit test
;   will be performed against the current exclusion rectangle (if there
;   is one), and if the cursor is now visible, it will be drawn.
;
;   This routine is intended to be interrupt code.  The state of the
;   interrupts will be maintained over the entire call, but interrupts
;   will be enabled whenever the cursor is drawn.
;
;   For devices with hardware support for cursors, this routine could
;   be a nop.
;
; Entry:
;	None
; Returns:
;	None
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP,ES
; Registers Destroyed:
;	AX,BX,CX,DX,FLAGS
; Calls:
;	exclude_test
;	cursor_off
;	draw_cursor
; History:
;	Sun 15-Feb-1987 16:47:15 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; void CheckCursor();
; {
;   WORD    old_busy;
;
;   if (swap(screen_busy,old_busy) == screen_busy)
;	return();			// cannot access the screen
;
;   if (cursor is off || cursor not excluded)
;   {					// nothing to do
;	screen_busy = NOT_BUSY;
;	return();
;   }
;
;   // The cursor is currently excluded.  If it is now unexcluded,
;   // it must be drawn.
;
; test_if_unexcluded:
;
;   enter_crit();
;   if (cursor unexcluded)
;   {
;	leave_crit();
;	draw_cursor();			// draw cursor at new location
;	cur_flags = 0;			// show cursor is on and unexcluded
;	enter_crit();
;	if (cursor positions disagree)
;	    goto test_if_unexcluded;	// moved while we were drawing it.
;	screen_busy = NOT_BUSY;
;	leave_crit();
;	return();
;   }
;   leave_crit();
;
;   // Must test to see if the cursor became excluded after we
;   // just brought it back.
;
;   if (cursor is excluded)
;   {
;	cursor_off();
;	cur_flags = CUR_EXCLUDED;
;   }
;
;   screen_busy = NOT_BUSY;		// others can have the screen now
;   return();
; }
;-----------------------------------------------------------------------;


cProc	CheckCursor,<FAR,PUBLIC,WIN,PASCAL>,<si,di,es>

cBegin
	cmp	screen_busy, IS_BUSY
	jz	check_cursor_20		;Set screen busy
	cmp	cur_needs_update, 0FFh
	jnz	check_cursor_20
	mov	cur_needs_update, 0
	push	cs
	pop	ds
	call	im1024_move_cursor
check_cursor_20:
	pop	es
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf

cEnd	<nogen>


	ifdef	PUBDEFS
	include cursors.pub
	endif




sEnd	code


end
