        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	EGA.INC
;
; This file contains the definitions of the EGA registers used by
; the driver.
;
; Created: 06-Jan-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;
;	The following rules apply to the use of the EGA registers
;	for the drivers (excluding pointer code and state detection
;	code):
;
;
;	1)  Routines are allowed to alter the following registers:
;
;	    Sequencer:
;
;		SEQ_DATA		SEQ_MAP_MASK
;
;	    Graphics Controller:
;
;		GRAF_ADDR
;		GRAF_DATA		GRAF_DATA_ROT
;		GRAF_SET_RESET		GRAF_READ_MAP
;		GRAF_ENAB_SR		GRAF_MODE
;		GRAF_COL_COMP		GRAF_BIT_MASK
;		GRAF_CDC
;
;
;	2)  The following registers will always contain the indicated
;	    value.  Routines are not allowed to alter them:
;
;	    Sequencer:
;
;		SEQ_ADDR	set to point SEQ_MAP_MASK
;
;
;	3)  Rotation counts for GRAF_DATA_ROT are not allowed.
;
;
;	4)  The following EGA registers will contain the indicated
;	    value upon entry to a routine.  Any routine which alters
;	    them must restore them to the indicated state.
;
;		Map Mask	    all planes enabled
;		Enable Set/Reset    all planes disabled
;		Data Rotate	    Set, no rotation
;		Mode		    Processor write, data read
;		Bit Mask	    all bits enabled
;
;
;	5)  The Mode Register is always shadowed in EGA memory for
;	    the state detection code.  At interrupt time, the mode
;	    will be restored from the location shadowed_mode. Any
;	    routine altering the Mode Register must keep this
;	    location current.  Upon exit from the routine, this
;	    location must be set to the default along with the
;	    contents of the Mode register.
;
;
;	6)  Pointer drawing will save and restore the contents of
;	    the processor latches.
;
;
;	7)  Pointer drawing will leave GRAF_ADDR set to GRAF_BIT_MASK.
;
;
;   Enter Ye into the valley of death if you violate any of these
;   rules.  WIN386 and this driver are in bed with each other.
;
;-----------------------------------------------------------------------;

IM1024_SEGMENT		equ	0C600h
IM1024_SEGMENT_2	equ	0C640h

;
; Addresses in the IM1024's memory segment
;
IM1024_RECV_BUF		equ	0100h	;PGC receive buffer
IM1024_RECV_W		equ	0302h	;PGC receive buffer write pointer
IM1024_RECV_R		equ	0303h	;PGC receive buffer read pointer
IM1024_COLDBOOT		equ	0306h	;PGC cold boot flag
IM1024_REPERROR		equ	0308h	;PGC 'report errorrs' flag
IM1024_DISPREQ		equ	030Ch	;PGC 'display request'
IM1024_FASTMODE		equ	0330h	;Enable fast mode?
IM1024_QUEUESIZE	equ	0331h	;Space used in queue?
IM1024_TEST		equ	03DFh	;Used to test for card presence

;
; IM1024 command bytes
;
IM1024_COLOR		equ	06h	;Set drawing colour
IM1024_DOT		equ	08h	;Place single pixel
IM1024_MOVE		equ	010h	;Set current position
IM1024_DRAW		equ	028h	;Draw a line
IM1024_POLY		equ	030h	;Draw a polygon
IM1024_PLINE		equ	036h	;Draw a polyline
IM1024_IMGSIZ		equ	04Eh	;Set drawable area
IM1024_LUT8RD		equ	053h	;Read palette (8-bit R/G/B)
IM1024_READP		equ	055h	;Read pixel
IM1024_CLBEG		equ	070h	;Begin procedure definition
IM1024_CLEND		equ	071h	;End procedure definition
IM1024_CLRUN		equ	072h	;Run defined procedure
IM1024_TSIZE		equ	081h	;Set text size
IM1024_TDEFIN		equ	084h	;Define a character
IM1024_TJUST		equ	085h	;Set text alignment
IM1024_TWRITE_ROM	equ	088h	;Write text using ROM font
IM1024_TWRITE		equ	08Bh	;Write text using user font
IM1024_VWPORT		equ	0B2h
IM1024_WINDOW		equ	0B3h
IM1024_PAN		equ	0B7h	;Pan display
IM1024_DISPLAY		equ	0D0h	;Select text/graphics mode
IM1024_IMAGEW		equ	0D9h	;Write image to screen
IM1024_IMAGEX		equ	0DAh	;Write image to screen
IM1024_BLKMOV		equ	0DFh	;Screen to screen blit
IM1024_IPREC		equ	0E4h	
IM1024_LUT8		equ	0E6h	;Write palette (8-bit R/G/B)
IM1024_AREAPT		equ	0E7h	;Set fill pattern
IM1024_PRMFIL		equ	0E9h	;Set polygon fill mode
IM1024_LINPAT		equ	0EAh	;Set line draw pattern
IM1024_LINFUN		equ	0EBh	;Set write mode
IM1024_LUTINT		equ	0ECh	;Load preset palette

;
; Values for shape_type
;
SHAPE_RECT	equ	1
SHAPE_CIRCLE	equ	2
SHAPE_ELLIPSE	equ	3
SHAPE_STRING	equ	4
SHAPE_POLYGON	equ	5

