        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	IMOUTPUT.ASM
;
;   This module contains functions and definitions specific to
;   the IM1024 display driver
;
; Created: 7 January 2026
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	im1024_circle
;			im1024_ellipse
;
; Public Data:
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc
incDrawMode = 1

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include windefs.inc
	include im1024.inc
	include display.inc
	include macros.mac
	include	cursor.inc
	.list


BS_SOLID	equ	0
BS_HOLLOW	equ	1
BS_HATCHED	equ	2
BS_PATTERN	equ	3

sBegin	Code
assumes cs,Code

	public 		im1024_circle
	public 		im1024_ellipse

	externNP	im1024_send1	;Send CX bytes from SI
	externNP	im1024_send	;Send wptr [SI] bytes from SI+2
	externB		im1024_color
	externW		im1024_seg
	externD		im1024_drawmode
	externD		im1024_brush
	externW		im1024_rect
	externW		im1024_moveto
	externW		im1024_prmfil
	externW		im1024_linpat
	externW		im1024_x
	externW		im1024_y
	externW		im1024_rectw
	externW		im1024_recth
	externB		shape_type
	externW		y_origin
	externW		brush_patterns
	externW		im1024_circ
	externW		im1024_elipse

	externNP	im1024_exclude
	externNP	im1024_outline
	externNP	mkbrush
	externB		poly_rops
	externNP	X43D1	
	externNP	X44ED
	externW		info_table_base
	externW		physical_device
	externA		PHYS_DEVICE_SIZE

im1024_circle proc	near

lp_points	equ	dword ptr [bp+16]
lp_phys_pen	equ	dword ptr [bp+12]
lp_phys_brush	equ	dword ptr [bp+8]	
lp_draw_mode	equ	dword ptr [bp+4]

circle_bkmode	equ	byte ptr [bp-1]
circle_rop	equ	word ptr [bp-4]
circle_outline_ptr equ	word ptr [bp-8]
circle_x0	equ	word ptr [bp-10]
circle_y0	equ	word ptr [bp-12]
circle_x1	equ	word ptr [bp-14]
circle_y1	equ	word ptr [bp-16]
	push	bp
	mov	bp, sp
	sub	sp, 10h
	push	es
	push	ds
assumes ds,Code
	les	di,lp_draw_mode
	mov	wptr im1024_drawmode,di
	mov	wptr im1024_drawmode+2,es
	mov	ax, es:[di].Rop2
	cmp	ax, 11	;dummy ROP
	jnz	circle_1
	jmp	circle_end
;
circle_1:
	mov	circle_rop,ax
	mov	bl,es:[di].bkMode
	mov	circle_bkmode, bl
	push	ds
	lds	si, lp_points
	mov	ax, [si]
	mov	circle_x0, ax
	mov	bx, [si+4]
	mov	circle_x1, bx
	add	ax,bx
	shr	ax, 1
	mov	bx, [si+2]
	mov	circle_y0, bx
	mov	cx, [si+6]
	mov	circle_y1, cx
	add	bx,cx
	shr	bx,1
	neg	bx
	mov	cx,[si+4]
	sub	cx,ax
	mov	word ptr cs:im1024_circ+3,cx	;Radius
	pop	ds
	push	circle_x0
	push	circle_y0
	push	circle_x1
	push	circle_y1
	call	im1024_exclude
	mov	word ptr im1024_moveto+3, ax
	mov	word ptr im1024_moveto+5, bx
	cmp	word ptr lp_phys_brush+2, 0
	jnz	circle_2
	jmp	short circle_6
;
circle_2:
	les	di,lp_phys_brush
	mov	wptr im1024_brush,di
	mov	wptr im1024_brush+2,es
	cmp	byte ptr es:[di],BS_HOLLOW
	jz	circle_6
	push	ds
	mov	si, offset im1024_moveto
	call	im1024_send
	mov	shape_type, SHAPE_CIRCLE
	mov	ax, circle_rop
	dec	ax
	shl	ax,1
	shl	ax,1
	mov	si, offset poly_rops
	add	si,ax
	mov	cx,2
circle_3:
	push	cx
	lodsw
	push	si
	or	al,al
	jz	circle_5
	cmp	al,'D'
	jz	circle_4
	cmp	ah,1
	jnz	circle_4
	call	mkbrush
	jmp	short circle_5
;
circle_4:
	mov	al, ah
	call	X43D1
circle_5:
	pop	si
	pop	cx
	loop	circle_3
circle_6:
	cmp	wptr lp_phys_pen+2, 0
	jz	circle_end
	mov	wptr circle_outline_ptr, offset circle_outline
	mov	wptr circle_outline_ptr+2, ds
	mov	ax, 4
	push	wptr circle_outline_ptr+2
	push	wptr circle_outline_ptr
	push	wptr lp_points+2
	push	wptr lp_points
	push	ax
	push	wptr lp_phys_pen+2
	push	wptr lp_phys_pen
	push	wptr circle_rop
	push	wptr circle_bkmode
	call	im1024_outline
	
circle_end:	
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp	
	ret	10h
im1024_circle	endp

circle_outline	proc	near
	push	bp
	mov	bp, sp
	push	cs
	pop	ds
	mov	si, offset im1024_prmfil
	mov	byte ptr [si+3],0
	call	im1024_send
	mov	si, offset im1024_moveto
	call	im1024_send
	mov	si, offset im1024_circ
	call	im1024_send
	mov	sp, bp
	pop	bp
	retn	0Ah
circle_outline	endp

im1024_ellipse proc	near

lp_points	equ	dword ptr [bp+16]
lp_phys_pen	equ	dword ptr [bp+12]
lp_phys_brush	equ	dword ptr [bp+8]	
lp_draw_mode	equ	dword ptr [bp+4]

ellipse_bkmode	equ	byte ptr [bp-1]
ellipse_rop	equ	word ptr [bp-4]
ellipse_outline_ptr equ	word ptr [bp-8]
ellipse_x0	equ	word ptr [bp-10]
ellipse_y0	equ	word ptr [bp-12]
ellipse_x1	equ	word ptr [bp-14]
ellipse_y1	equ	word ptr [bp-16]
	push	bp
	mov	bp, sp
	sub	sp, 10h
	push	es
	push	ds
assumes ds,Code
	les	di,lp_draw_mode
	mov	wptr im1024_drawmode,di
	mov	wptr im1024_drawmode+2,es
	mov	ax, es:[di].Rop2
	cmp	ax, 11	;dummy ROP
	jnz	ellipse_1
	jmp	ellipse_end
;
ellipse_1:
	mov	ellipse_rop,ax
	mov	bl,es:[di].bkMode
	mov	ellipse_bkmode, bl
	push	ds
	lds	si, lp_points
	mov	ax, [si]
	mov	ellipse_x0, ax
	mov	bx, [si+4]
	mov	ellipse_x1, bx
	add	ax,bx
	shr	ax, 1
	mov	bx, [si+2]
	mov	ellipse_y0, bx
	mov	cx, [si+6]
	mov	ellipse_y1, cx
	add	bx,cx
	shr	bx,1
	mov	cx,[si+4]
	sub	cx,ax
	mov	word ptr cs:im1024_elipse+3,cx	;Radius X
	mov	cx,[si+6]
	sub	cx,bx
	mov	word ptr cs:im1024_elipse+5,cx	;Radius Y
	pop	ds
	push	ellipse_x0
	push	ellipse_y0
	push	ellipse_x1
	push	ellipse_y1
	call	im1024_exclude
	neg	bx
	mov	word ptr im1024_moveto+3, ax
	mov	word ptr im1024_moveto+5, bx
	cmp	word ptr lp_phys_brush+2, 0
	jnz	ellipse_2
	jmp	short ellipse_6
;
ellipse_2:
	les	di,lp_phys_brush
	mov	wptr im1024_brush,di
	mov	wptr im1024_brush+2,es
	cmp	byte ptr es:[di],BS_HOLLOW
	jz	ellipse_6
	push	ds
	mov	si, offset im1024_moveto
	call	im1024_send
	mov	shape_type, SHAPE_ELLIPSE
	mov	ax, ellipse_rop
	dec	ax
	shl	ax,1
	shl	ax,1
	mov	si, offset poly_rops
	add	si,ax
	mov	cx,2
ellipse_3:
	push	cx
	lodsw
	push	si
	or	al,al
	jz	ellipse_5
	cmp	al,'D'
	jz	ellipse_4
	cmp	ah,1
	jnz	ellipse_4
	call	mkbrush
	jmp	short ellipse_5
;
ellipse_4:
	mov	al, ah
	call	X43D1
ellipse_5:
	pop	si
	pop	cx
	loop	ellipse_3
ellipse_6:
	cmp	wptr lp_phys_pen+2, 0
	jz	ellipse_end
	mov	wptr ellipse_outline_ptr, offset ellipse_outline
	mov	wptr ellipse_outline_ptr+2, ds
	mov	ax, 4
	push	wptr ellipse_outline_ptr+2
	push	wptr ellipse_outline_ptr
	push	wptr lp_points+2
	push	wptr lp_points
	push	ax
	push	wptr lp_phys_pen+2
	push	wptr lp_phys_pen
	push	wptr ellipse_rop
	push	wptr ellipse_bkmode
	call	im1024_outline
	
ellipse_end:	
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp	
	ret	10h
im1024_ellipse	endp

ellipse_outline	proc	near
	push	bp
	mov	bp, sp
	push	cs
	pop	ds
	mov	si, offset im1024_prmfil
	mov	byte ptr [si+3],0
	call	im1024_send
	mov	si, offset im1024_moveto
	call	im1024_send
	mov	si, offset im1024_elipse
	call	im1024_send
	mov	sp, bp
	pop	bp
	retn	0Ah
ellipse_outline	endp

sEnd	Code

	end
