        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	IMOUTPUT.ASM
;
;   This module contains functions and definitions specific to
;   the IM1024 display driver
;
; Created: 7 January 2026
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	im1024_scanline
;			im1024_polygon
;			im1024_rectangle
;			im1024_polyline
;
; Public Data:		poly_rops
;			im1024_clrun
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc
incDrawMode = 1

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include windefs.inc
	include im1024.inc
	include display.inc
	include macros.mac
	include	cursor.inc
	.list


BS_SOLID	equ	0
BS_HOLLOW	equ	1
BS_HATCHED	equ	2
BS_PATTERN	equ	3

sBegin	Code
assumes cs,Code

	public 		im1024_scanline
	public 		im1024_rectangle
	public 		im1024_polyline
	public 		im1024_polygon
	public		im1024_clrun

	externNP	im1024_send1	;Send CX bytes from SI
	externNP	im1024_send	;Send wptr [SI] bytes from SI+2
	externB		im1024_color
	externW		im1024_seg
	externD		im1024_drawmode
	externD		im1024_brush
	externW		im1024_rect
	externW		im1024_moveto
	externW		im1024_prmfil
	externW		im1024_linpat
	externW		im1024_x
	externW		im1024_y
	externW		im1024_rectw
	externW		im1024_recth
	externB		shape_type
	externW		y_origin
	externW		brush_patterns

	externNP	im1024_exclude
	externNP	im1024_outline
	externNP	X43D1	
	externNP	X44ED
	externW		info_table_base
	externW		physical_device
	externA		PHYS_DEVICE_SIZE

im1024_draw	dw	5
		db	IM1024_DRAW
im1024_drawx	dw	0
im1024_drawy	dw	0
im1024_scany	dw	0
im1024_scanbk	db	0
im1024_scanpat	dw	0
B2F88		db	0
im1024_scanpen	db	6,0,0,0


im1024_scanline proc	near

scan_count	equ	dword ptr [bp+20]
lp_points	equ	dword ptr [bp+16]
lp_phys_pen	equ	dword ptr [bp+12]
lp_phys_brush	equ	dword ptr [bp+8]	
lp_draw_mode	equ	dword ptr [bp+4]

scan_rop	equ	wptr [bp-4]
scan_fgcol	equ	bptr [bp-5]
scan_bkmode	equ	bptr [bp-6]
scan_pen	equ	dword ptr [bp-0Ah]
scan_compare	equ	dword ptr [bp-0Eh]

	push	bp
	mov	bp, sp
	sub	sp, 0Eh
	push	es
	push	ds
	lds	si,lp_points
	add	si,2	;Y-coordinate
	lodsw
	push	cs
	pop	ds
	assumes	ds,Code
	mov	im1024_scany, ax
	mov	wptr scan_compare, offset X30D2
	mov	wptr scan_compare+2, ds
	les	di,lp_draw_mode
	mov	wptr im1024_drawmode,di
	mov	wptr im1024_drawmode+2,es
	mov	ax, es:[di].Rop2
	cmp	ax, 11	;dummy ROP
	jnz	scanline_1
	jmp	scanline_end
;
scanline_1:
	mov	scan_rop,ax
	mov	bl,es:[di].bkColor
	mov	im1024_scanbk, bl
	mov	bl,es:[di].TextColor
	mov	scan_fgcol, bl
	mov	bl,es:[di].bkMode
	mov	scan_bkmode, bl
	mov	B2F88,0
	cmp	wptr lp_phys_brush+2, 0
	jz	scanline_4
	les	di, lp_phys_brush
	mov	bl, es:[di+1]
	cmp	bptr es:[di], 0
	jz	scanline_2
	cmp	bptr es:[di], 1
	jz	scanline_4
	call	X304A
	mov	si, offset im1024_scanpen
	mov 	bptr [si], 6
	mov	[si+1],bl
	mov	[si+2],ax
	jmp	short scanline_3

scanline_2:
	mov	si, offset im1024_scanpen
	mov	bptr [si], 0
	mov	[si+1],bl
scanline_3:
	mov	wptr scan_pen, si
	mov	wptr scan_pen+2, ds	
	jmp	short scanline_5

scanline_4:
	mov	ax, wptr lp_phys_pen
	mov	wptr scan_pen, ax
	mov	ax, wptr lp_phys_pen+2
	mov	wptr scan_pen+2, ax
scanline_5:
	push	wptr scan_compare+2
	push	wptr scan_compare
	push	wptr lp_points+2
	push	wptr lp_points
	push	wptr scan_count
	push	wptr scan_pen+2
	push	wptr scan_pen
	push	wptr scan_rop
	push	wptr scan_bkmode
	call	im1024_outline
	
scanline_end:	
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp	
	ret	12h
im1024_scanline	endp

BS_PATTERN	equ	3

X304A	proc	near
	mov	ax,y_origin
	sub	ax,im1024_scany
	mov	bx,8
	xor	dx,dx
	div	bx
	mov	ax,dx
	push	ds
	lds	si,lp_phys_brush
	cmp	byte ptr [si], BS_PATTERN
	jnz	X3086
	mov	al,[si+1]
	mov	scan_fgcol, al
	mov	al,[si+3]
	mov	cs:im1024_scanbk, al
	mov	bl,[si+2]
	pop	ds
	xor	bh,bh
	mov	cl,5
	shl	bx,cl
	add	bx,offset brush_patterns
	shl	dx, 1
	add	bx,dx
	mov	ax, [bx]
	jmp	short	X30C6

X3086:	les	di, [si+1]
	lds	si, [si+1]
	mov	cl, [si].bmBitsPixel
	mov	bx, [si].bmWidthBytes
	lds	si, [si].bmBits
	mul	bx
	add	si,ax
	cmp	cl, 8
	jz	X30A6
	lodsb
	mov	ah,al
	not	ax
	pop	ds
	jmp	short X30C6
;
X30A6:	mov	cl, cs:im1024_scanbk
	mov	bx,8000h
X30AE:	lodsb
	cmp	al,cl
	jz	X30B5
	or	bl,bh
X30B5:	shr	bh,1
	or	bh,bh
	jnz	X30AE
	pop	ds
	mov	al,bl
	mov	ah,al
	call	X44ED
	mov	scan_fgcol, ch
X30C6:	mov	B2F88, 0FFh
	mov	bl, scan_fgcol
	mov	im1024_scanpat, ax
	ret

X304A	endp

X30D2	proc	near

param6	equ	byte ptr [bp+6]
param8	equ	word ptr [bp+8]
param10	equ	word ptr [bp+10]

	push	bp
	mov	bp,sp
	mov	cx,param8
	dec	cx
	mov	ax,im1024_scany
	neg	ax
	mov	im1024_drawy, ax
	mov	wptr im1024_moveto+5, ax
	mov	si, param10
	add	si, 4
X30EA:	push	cx
	mov	ds, word ptr param10+2
	lodsw
	push	ax
	push	cs:im1024_scany
	mov	cx,ax
	lodsw
	push	ax
	push	cs
	pop	ds
	push	im1024_scany
	call	im1024_exclude
	push	si
	cmp	B2F88, 0FFh
	jnz	X3120
	push	cx
	and	cx, wptr 0Fh
	mov	dx, cs:im1024_scanpat
	ror	dx, cl
	mov	si,offset im1024_linpat
	mov	[si+3],dx
	call	im1024_send
	pop	cx
X3120:	mov	im1024_drawx, ax
	mov	wptr im1024_moveto+3,cx
	mov	si,offset im1024_moveto
	call	im1024_send
	mov	si,offset im1024_draw
	call	im1024_send
	pop	si
	pop	cx
	cmp	param6, 2
	jnz	X3140
	push	si
	call	X3148
	pop	si
X3140:	loop	X30EA
	mov	sp, bp
	pop	bp
	retn	0Ah

X30D2	endp

X3148	proc	near
	mov	si, offset im1024_color
	mov	al, im1024_scanbk
	mov	[si+3],al
	call	im1024_send
	mov	si, offset im1024_linpat
	not	wptr [si+3]
	call	im1024_send
	mov	si, offset im1024_moveto
	call	im1024_send
	mov	si, offset im1024_draw
	call	im1024_send
	cmp	cx, 1
	jz	X3183
	mov	si, offset im1024_color
	mov	al, [bp+4]
	mov	[si+3],al
	call	im1024_send
	mov	si, offset im1024_linpat
	not	wptr [si+3]
	call	im1024_send
X3183:	ret
	
X3148	endp

im1024_poly	dw	2
		db	IM1024_POLY
		db	5 dup(0)
im1024_clbeg	dw	2
		db	IM1024_CLBEG, 0
im1024_clend	dw	1
		db	IM1024_CLEND
im1024_clrun	dw	2
		db	IM1024_CLRUN, 0

im1024_polygon	proc	near
		push	bp
		mov	bp, sp
		sub	sp, 8

poly_count	equ	word ptr  [bp+24]
poly_points	equ	dword ptr [bp+20]
poly_phys_pen	equ	dword ptr [bp+16]
poly_phys_brush	equ	dword ptr [bp+12]
poly_drawmode	equ	dword ptr [bp+8]
poly_cliprect	equ	dword ptr [bp+4]

poly_rop	equ	wptr [bp-2]
poly_bkmode	equ	bptr [bp-3]
poly_outlinefunc equ	wptr [bp-6]
poly_remaining	equ	wptr [bp-8]	;Number of points left to draw

		push	es
		push	ds
		les	di, poly_drawmode
		mov	wptr im1024_drawmode, di
		mov	wptr im1024_drawmode+2, es
		mov	ax, es:[di].Rop2
		cmp	ax, 0Bh		;No-op
		jnz	polygon_1
		jmp	polygon_end
;
polygon_1:	mov	poly_rop, ax
		mov	bl, bptr es:[di].bkMode
		mov	poly_bkmode, bl
		cmp	wptr poly_cliprect+2, 0
		jnz	polygon_2
		mov	dx, -2
		jmp	short polygon_3
;
polygon_2:	push	ds
		lds	si, poly_cliprect
		lodsw
		mov	dx, ax
		lodsw
		mov	cx, ax
		lodsw
		mov	bx, ax
		lodsw
		pop	ds
polygon_3:	push	dx
		push	cx
		push	bx
		push	ax
		call	im1024_exclude
		call	poly_cldefine
		cmp	wptr poly_phys_brush+2, 0
		jnz	polygon_4
		jmp	short polygon_8
		nop
polygon_4:
		les	di, poly_phys_brush
		mov	wptr im1024_brush, di
		mov	wptr im1024_brush+2,es
		cmp	byte ptr es:[di], BS_HOLLOW
		jz	polygon_8
		mov	ax, poly_rop
		dec	ax
		shl	ax, 1
		shl	ax, 1
		mov	si, offset poly_rops
		add	si, ax
		mov	cx, 2
polygon_5:	push	cx
		lodsw
		push	si
		or	al, al
		jz	polygon_7
		cmp	al, 'D'
		jz	polygon_6
		cmp	ah, 1
		jnz	polygon_6
		call	mkbrush
		jmp	short polygon_7
;
polygon_6:	mov	al, ah
		mov	bptr shape_type, SHAPE_POLYGON
		call	X43D1
polygon_7:	pop	si
		pop	cx
		loop	polygon_5
polygon_8:	cmp	wptr poly_phys_pen+2, 0
		jz	polygon_end
		mov	poly_outlinefunc, offset poly_outline
		push	poly_outlinefunc
		push	wptr poly_points+2
		push	wptr poly_points
		push	poly_count
		push	wptr poly_phys_pen+2
		push	wptr poly_phys_pen
		push	wptr poly_rop
		push	wptr poly_bkmode
		call	im1024_outline
polygon_end:
		pop	ds
		pop	es
		mov	sp,bp
		pop	bp
		retn	16h
im1024_polygon	endp

poly_cldefine	proc	near
		push	cs
		pop	es
		mov	si, offset im1024_clbeg
		mov	bptr [si+3], 0
		mov	bptr im1024_clrun+3, 0
		call	im1024_send
		mov	cx, poly_count
		mov	si, wptr poly_points
poly_cldefine_1:
		mov	poly_remaining, 0
		cmp	cx, 0FFh
		jbe	poly_cldefine_2
		mov	bx, 0FFh		;Do the first 255
		sub	cx, bx			;and postpone the rest
		mov	poly_remaining, cx	
		xchg	cx,bx
poly_cldefine_2:
		mov	bptr im1024_poly+3, cl	;Count
		push	si
		mov	si, offset im1024_poly
		call	im1024_send		;Write command
		pop	si
poly_cldefine_3:
		mov	di, offset im1024_poly+4
		push	ds
		mov	ds, wptr [poly_points+2]
		movsw				;Copy X-coord
		lodsw				;Get Y-coord
		neg	ax
		stosw				;Copy Y-coord
		pop	ds
		push	cx
		push	si
		mov	cx, 4
		mov	si, offset im1024_poly+4
		call	im1024_send1		;Send the point
		pop	si
		pop	cx
		loop	poly_cldefine_3		;Next point
		mov	cx, poly_remaining
		jcxz	poly_cldefine_4
		jmp	short poly_cldefine_1
;
poly_cldefine_4:
		mov	si, offset im1024_clend
		call	im1024_send
		ret
poly_cldefine	endp

poly_outline	proc	near
		push	bp
		mov	bp, sp
		mov	si, offset im1024_prmfil
		mov	byte ptr [si+3], 0
		call	im1024_send
		mov	si, offset im1024_clrun
		mov	byte ptr [si+3], 0
		call	im1024_send
		mov	sp,bp
		pop	bp
		retn	0Ah
poly_outline	endp

		public	poly_rops

poly_rops	db	'D', 6,  0,  0
		db	'P', 4, 'D', 5
		db	'P', 1, 'P', 3
		db	'P', 1, 'P', 0
		db	'D', 5, 'P', 3
		db	'D', 5,  0,  0
		db	'P', 2,  0,  0
		db	'P', 3, 'D', 5
		db	'P', 3,  0,  0
		db	'P', 2, 'D', 5
		db	 0,  0,  0,  0
		db	'P', 1, 'P', 4
		db	'P', 0,  0,  0
		db	'P', 4,  0,  0
		db	'D', 7,  0,  0
;
im1024_rectangle proc near

rect_points	equ	dword ptr [bp+16]
rect_pen	equ	dword ptr [bp+12]
rect_brush	equ	dword ptr [bp+8]
rect_drawmode	equ	dword ptr [bp+4]

rect_bkmode	equ	byte ptr [bp-1]
rect_rop	equ	word ptr [bp-4]
rect_outlinefunc equ	dword ptr [bp-8]

	push	bp
	mov	bp, sp
	sub	sp, 8
	push	es
	push	ds
	les	di,rect_drawmode
	mov	wptr im1024_drawmode, di
	mov	wptr im1024_drawmode+2, es
	mov	ax, es:[di].Rop2
	cmp	ax, 0Bh		;The no-op ROP
	mov	bl, es:[di].bkMode
	mov	rect_bkmode, bl
	jnz	rectangle_1
	jmp	rectangle_end
;
rectangle_1:
	mov	rect_rop, ax
	cmp	wptr rect_brush + 2, 0
	jnz	rectangle_2
	jmp	short rectangle_6	;No fill
	nop
rectangle_2:
	les	di, rect_brush
	mov	wptr im1024_brush, di
	mov	wptr im1024_brush+2, es
	cmp	byte ptr es:[di], BS_HOLLOW
	jz	rectangle_6
	push	ds
	lds	si, rect_points
	lodsw
	mov	dx, ax
	lodsw
	mov	cx, ax
	lodsw
	mov	bx, ax
	lodsw
	pop	ds
	push	dx
	push	cx
	push	bx
	push	ax
	call	im1024_exclude
	sub	bx, dx
	sub	ax, cx
	mov	im1024_x, dx
	mov	im1024_y, cx
	mov	im1024_rectw, bx
	mov	im1024_recth, ax
	mov	ax, rect_rop
	dec	ax
	shl	ax,1
	shl	ax,1
	mov	si,offset poly_rops
	add	si,ax
	mov	cx,2
rectangle_3:
	push	cx
	lodsw
	push	si
	or	al,al
	jz	rectangle_5
	cmp	al, 'D'
	jz	rectangle_4
	cmp	ah, 1
	jnz	rectangle_4
	call	mkbrush
	jmp	short rectangle_5

rectangle_4:
	mov	al,ah
	call	X43D1
rectangle_5:
	pop	si
	pop	cx
	loop	rectangle_3
rectangle_6:
	cmp	wptr rect_pen + 2, 0
	jz	rectangle_end
	mov	wptr rect_outlinefunc, offset rect_outline
	mov	wptr rect_outlinefunc+2, ds
	mov	ax, 2
	push	wptr rect_outlinefunc+2
	push	wptr rect_outlinefunc
	push	wptr rect_points+2
	push	wptr rect_points
	push	ax
	push	wptr rect_pen+2
	push	wptr rect_pen
	push	wptr rect_rop
	push	wptr rect_bkmode
	call	im1024_outline
	
rectangle_end:	
	pop	ds
	pop	es
	mov	sp, bp
	pop	bp
	ret	10h
im1024_rectangle endp

rect_outline	proc near
	push	bp
	mov	bp, sp
	push	cs
	pop	ds
	mov	si, offset im1024_prmfil
	mov	bptr [si+3], 0
	call	im1024_send
	push	ds
	lds	si, [bp+0Ah]	;Coordinates 
	lodsw
	mov	dx, ax
	lodsw	
	mov	cx, ax
	lodsw
	dec	ax
	mov	bx, ax
	lodsw
	dec	ax
	pop	ds
	push	dx
	push	cx
	push	bx
	push	ax
	call	im1024_exclude
	mov	si, offset im1024_moveto	;Move to top left corner 
	mov	[si+3],dx			;of rectangle
	neg	cx
	mov	[si+5],cx
	call	im1024_send
	mov	si, offset im1024_rect
	mov	[si+3],bx
	neg	ax
	mov	[si+5],ax
	call	im1024_send			;And draw the rectangle
	mov	sp, bp
	pop	bp
	ret	0Ah
rect_outline	endp

brush_3430	db	SIZE oem_brush_def dup(0)

	public	mkbrush

mkbrush	proc	near
	push	ds
	push	cs
	pop	es
	mov	di, offset brush_3430
	lds	si, [bp+2]
	lodsb
	stosb
	cmp	al, BS_HATCHED
	jnz	mkbrush_2
	mov	ax, offset brush_3430+5	;Set pattern pointer to be at brush+5
	stosw
	mov	ax, es
	stosw
	lds	si,[si]
	mov	di, offset brush_3430+5	;Copy pattern to brush+5
	movsw	
	movsw	
	movsw	
	movsw	
	movsw	
	lds	si,[si]
	mov	ax, si
	add	ax, offset brush_3430+5
	stosw
	mov	ax, es
	stosw
	mov	di, offset brush_3430+25h
	mov	cx, 40h
mkbrush_1:
	lodsb
	not	al
	stosb
	loop	mkbrush_1
	jmp	short mkbrush_3
;
mkbrush_2:
	lodsb
	not	al
	stosb
mkbrush_3:
	pop	ds
	mov	wptr im1024_brush, offset brush_3430
	mov	wptr im1024_brush+2, es
	ret
mkbrush	endp

im1024_pline	dw	2
		db	IM1024_PLINE, 0, 0, 0, 0, 0

im1024_polyline	proc	near
pline_count	equ	word ptr  [bp+20]
pline_points	equ	dword ptr [bp+16]
pline_pen	equ	dword ptr [bp+12]
pline_drawmode	equ	dword ptr [bp+8]
pline_clip	equ	dword ptr [bp+4]

pline_rop	equ	word ptr [bp-2]
pline_bkmode	equ	byte ptr [bp-3]
pline_outlinefunc equ	word ptr [bp-6]

	push	bp
	mov	bp, sp
	sub	sp, 6
	push	es
	push	ds
	les	di,pline_drawmode
	mov	wptr im1024_drawmode, di
	mov	wptr im1024_drawmode+2, es
	mov	ax, es:[di].Rop2
	cmp	ax, 0Bh		;The no-op ROP
	jnz	pline_1
	jmp	short pline_end
	nop
;
pline_1:
	mov	pline_rop, ax
	mov	bl, bptr es:[di].bkMode
	mov	pline_bkmode, bl
	cmp	wptr pline_clip+2, 0
	jnz	pline_2
	mov	dx,-2
	jmp	short pline_3
;
pline_2:
	push	ds
	lds	si, pline_clip
	lodsw
	mov	dx,ax
	lodsw
	mov	cx,ax
	lodsw	
	mov	bx,ax
	lodsw
	pop	ds
pline_3:	
	push	dx
	push	cx
	push	bx
	push	ax
	call	im1024_exclude
	mov	pline_outlinefunc, offset pline_outline
	push	pline_outlinefunc
	push	wptr pline_points+2
	push	wptr pline_points
	push	wptr pline_count
	push	wptr pline_pen+2
	push	wptr pline_pen
	push	pline_rop
	push	wptr pline_bkmode
	call	im1024_outline
pline_end:
	pop	ds
	pop	es
	mov	sp,bp
	pop	bp
	ret	12h
im1024_polyline	endp

pline_outline	proc	near
	push	bp
	mov	bp, sp

outline_remaining equ	word ptr [bp-2]

	sub	sp, 2
	mov	cx, [bp+8]	;Count of points
	mov	si, [bp+0Ah]	;Coordinates
pline_outline1:
	mov	outline_remaining, 0
	cmp	cx, 0FFh
	jbe	pline_outline2	;Can do them all in one go?
	mov	bx, 0FFh
	sub	cx, bx
	mov	outline_remaining, cx
	xchg	cx, bx		;No, draw 255 and come back later
pline_outline2:
	mov	bptr im1024_pline+3, cl
	push	si	
	mov	si, offset im1024_pline
	call	im1024_send
	pop	si
pline_outline3:
	mov	di, offset im1024_pline+4
	push	ds
	mov	ds, [bp+0Ch]	;DS:SI -> next coordinate pair to send
	movsw
	lodsw
	neg	ax
	stosw
	pop	ds
	push	cx
	push	si
	mov	cx, 4
	mov	si, offset im1024_pline+4
	call	im1024_send1	;Send coordinate pair
	pop	si
	pop	cx
	loop	pline_outline3
	mov	cx, outline_remaining
	jcxz	pline_outline_end
	jmp	short pline_outline1
;
pline_outline_end:
	mov	sp, bp
	pop	bp
	retn	0Ah

pline_outline	endp

sEnd	Code

	end

