        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	IMTEXT.ASM
;
;   This module contains functions and definitions relating to
;   IM1024 text output
;
; Created: 7 January 2026
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	
;
; Public Data:
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc
incDrawMode = 1
incFont = 1

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include windefs.inc
	include im1024.inc
	include display.inc
	include macros.mac
	include	cursor.inc
	.list

sBegin	Code
assumes cs,Code
assumes ds,Code

	externB	X086C
	externNP	im1024_send
	externNP	im1024_w_byte

	public	X3CFB
	public	im1024_tdefin

externB strblt_brkchar
externD	strblt_font

X3CCF	db	20h dup(0)
W3CEF	dw	0
avg_width	dw	0

im1024_tdefin	dw	4
		db	IM1024_TDEFIN, 0, 0, 0
font_w_bytes	dw	0

X3CFB	proc	near
	cld
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	lds	si, strblt_font
	assumes ds, nothing
	mov	ax, [si].dfAvgWidth
	mov	cs:avg_width,ax
	mov	si, word ptr [si].dfFace	;Nothing seems to use this
	mov	di, offset X3CCF
	xor	dl, dl
X3D16:	lodsb
	or	al, al
	jz	X3D25
	cmp	al, es:[di]
	stosb
	jz	X3D16
	mov	dl, 0FFh
	jmp	short X3D16
;
X3D25:	cmp	al, es:[di]
	mov	byte ptr es:[di], 0
	mov	ax, cs:avg_width
	jnz	X3D3F
	or	dl,dl
	jnz	X3D3F
	cmp	ax, cs:W3CEF
	jnz	X3D3F
	jmp	short	X3D46
;
X3D3F:	mov	cs:W3CEF, ax
	call	im1024_load_chargen
X3D46:
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
X3CFB	endp

im1024_load_chargen	proc	near
	push	cs
	pop	ds
	assumes	ds,Code
	push	ds
	lds	si, strblt_font
	assumes	ds,nothing
	mov	al,[si].dfPixWidth
	mov	ah,[si].dfPixHeight
	mov	cl,[si].dfFirstChar
	or	cl, cl			;Exclude characters 0 and 0FFh
	jnz	load_chargen_1			;since these are used to draw the 
	mov	cl,1			;mouse pointer
load_chargen_1:	
	mov	ch,[si].dfLastChar
	cmp	ch,0FFh
	jnz	load_chargen_2
	mov	ch,0FEh
load_chargen_2:
	mov	dx,[si].dfWidthBytes
	pop	ds
	assumes	ds,Code
	mov	byte ptr im1024_tdefin+5, ah	;Pixel height
	mov	byte ptr im1024_tdefin+3, cl	;Current char
	mov	font_w_bytes, dx
	or	al, al			;Pixel width (0 for variable width)
	jnz	load_chargen_3
	call	load_var_font			;Define font using variable width
	jmp	short	load_chargen_ret
;
; Define font using fixed-width chars
;
load_chargen_3:	
	mov	byte ptr im1024_tdefin+4, al	;Pixel width
	mov	X086C, al
	sub	ch, cl
	xchg	ch, cl
	xor	ch,ch
load_chargen_4:	mov	si, offset im1024_tdefin
	call	im1024_send
	push	ds
	lds	si, strblt_font
	mov	al, byte ptr cs:im1024_tdefin+3
	sub	al,[si].dfFirstChar	;Offset in form
	xor	ah, ah
	mov	bl, byte ptr cs:im1024_tdefin+4	
	xor	bh,bh
	mul	bx
	mov	bx, 8
	div	bx
	lds	si,[si].dfBitsPointer
	add	si, ax
	push	cx
	mov	cl,  byte ptr cs:im1024_tdefin+5
	xor	ch,ch
load_chargen_5:		
	push	cx
	push	dx
	push	si
	mov	cx, dx
	xor	dl, dl
load_chargen_6:	
	mov	ax, [si]
	rol	ax, cl
	mov	dh, byte ptr cs:im1024_tdefin+4
	sub	dh, dl
	push	cx
	mov	cl, 8
	sub	cl, dh
	js	load_chargen_7
	shr	al, cl
	shl	al, cl
load_chargen_7:	
	pop	cx
	call	im1024_w_byte
	add	dl, 8
	cmp	dl, cs:byte ptr im1024_tdefin+4
	jnc	load_chargen_8
	inc	si
	jmp	short load_chargen_6
load_chargen_8:	
	pop	si
	pop	dx
	pop	cx
	add	si, cs:font_w_bytes
	loop	load_chargen_5
	pop	cx
	pop	ds
	assumes	ds,Code
	inc	byte ptr im1024_tdefin+3
	loop	load_chargen_4
load_chargen_ret:
	ret
	
im1024_load_chargen	endp

load_var_font	proc	near
	push	es
	mov	es, wptr strblt_font+2
	mov	di, 33h	;Offsets table
	sub	ch, cl
	xchg	ch, cl
	xor	ch, ch
load_var_1:
	mov	ax, es:[di+2]
	sub	ax, es:[di]
	mov	im1024_tdefin+4, al
	mov	ah, strblt_brkchar
	cmp	im1024_tdefin+3, ah
	jnz	load_var_2
	mov	X086C, al
load_var_2:
	mov	si, offset im1024_tdefin
	call	im1024_send
	push	ds
	lds	si, strblt_font
	mov	ax, es:[di]
	mov	bx, 8
	xor	dx, dx
	div	bx
	lds	si, [si].dfBitsPointer
	add	si, ax
	push	cx
	mov	cl, cs:im1024_tdefin+5
	xor	ch, ch
load_var_3:
	push	cx
	push	dx
	push	si
	mov	cx, dx
	xor	dl, dl
load_var_4:
	mov	ax, [si]
	rol	ax, cl
	mov	dh, cs:im1024_tdefin+4
	sub	dh, dl
	push	cx
	mov	cl, 8
	sub	cl, dh
	js	load_var_5
	shr	al, cl
	shl	al, cl
load_var_5:
	pop	cx
	call	im1024_w_byte
	add	dl, 8
	cmp	dl, cs:im1024_tdefin+4
	jnc	load_var_6
	inc	si
	jmp	short load_var_4
;
load_var_6:
	pop	si
	pop	dx
	pop	cx
	add	si, cs:font_w_bytes
	loop	load_var_3
	pop	cx
	pop	ds
	assumes ds,Code
	inc	byte ptr im1024_tdefin+3
	add	di,2
	loop	load_var_1
	pop	es
	ret
load_var_font	endp

sEnd	Code

	end
