        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	ENABLE.ASM
;
; This module contains some fragments of CURSORS.ASM that in the PC98 
; driver appear to have been compiled separately
;
; Create   15-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1987  Microsoft Corporation
;
; Exported Functions:	Enable
;			Disable
;
; Public Functions:	
;
; Public Data:		
;
; General Description:
;
;-----------------------------------------------------------------------;

incDevice	= 1

	.xlist
	include cmacros.inc
	include windefs.inc
	include gdidefs.inc
	.list

sBegin	Code
       		externNP physical_enable        ;Enable routine
       		externNP physical_disable       ;Disable routine
	        externB  physical_device        ;Device physical data   
		externB	info_table_base		;GDIInfo table
		externA	PHYS_DEVICE_SIZE	;Size of physical device

assumes cs,Code
	externNP	exclude_test

page
;--------------------------Exported-Routine-----------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
;
; The display driver's physical disable routine is called to disable
; graphics and enter a character mode of operation.
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	physical_disable
; History:
;	Tue 18-Aug-1987 18:06:47 -by-  **** ***** [*****]
;	Pass ES = Data to physical disable
;
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	Made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
; {
;   physical_disable(lpPDevice);	// Do all the work here
;   return(-1); 			// Show success
; }
;-----------------------------------------------------------------------;

	public	Disable

cProc	Disable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device

cBegin

;;;	push	ds			;To break less drivers, pass
;;;	pop	es			;  DGROUP in ES instead of DS
;;;	assumes	es,Data

	lds	si,lp_device		;--> logical device
	assumes ds,nothing

;;;	push	es			;physical_disable can destroy ES
	call	physical_disable	;Restore device
;;;	pop	es			;need DGROUP in ES for restore_int_2Fh
	assumes	es,Data
;;;	call	restore_int_2Fh
	mov	ax,-1			;Show success
	
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4
cEnd	<nogen>

rop0:	xor	al, al
rop0_:	ret

rop2:	not	al
	and	al, ah
rop2_:	ret
;
rop3:	not	al
rop3_:	ret
;
rop4:	not	ah
	and	al, ah
	not	ah
rop4_:	ret
;
ropa:	mov	al, ah
ropa_:	ret
;
rop5:	mov	al, ah
	not	al
rop5_:	ret
;
rop6:	xor	al, ah
rop6_:	ret
;
rop9:	xor	al, ah
	not	al
rop9_:	ret
;
rop8:	and	al, ah
rop8_:	ret
;
rop7:	and	al, ah
	not	al
rop7_:	ret
;
ropb:	not	al
	or	al, ah
ropb_:	ret
;
ropd:	not	ah
	or	al, ah
	not	ah
ropd_:	ret
;
rope:	or	al, ah
rope_:	ret
;
rop1:	or	al, ah
	not	al
rop1_:	ret
;
ropf:	mov	al, 0FFh
ropf_:	ret
;
ropc:	
ropc_:	ret
;
	public	rop_indexes
	public	rop_lengths

rop_indexes	label	word
	dw	offset rop0
	dw	offset rop1
	dw	offset rop2
	dw	offset rop3
	dw	offset rop4
	dw	offset rop5
	dw	offset rop6
	dw	offset rop7
	dw	offset rop8
	dw	offset rop9
	dw	offset ropa
	dw	offset ropb
	dw	offset ropc
	dw	offset ropd
	dw	offset rope
	dw	offset ropf

rop_lengths	label	byte
	db	rop0_-rop0
	db	rop1_-rop1
	db	rop2_-rop2
	db	rop3_-rop3
	db	rop4_-rop4
	db	rop5_-rop5
	db	rop6_-rop6
	db	rop7_-rop7
	db	rop8_-rop8
	db	rop9_-rop9
	db	ropa_-ropa
	db	ropb_-ropb
	db	ropc_-ropc
	db	ropd_-ropd
	db	rope_-rope
	db	ropf_-ropf

	public	Enable
page
;--------------------------Exported-Routine-----------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
;
; Enable - Enable Device
;
; The given device is either initialized or the GDI information
; for the given device is returned.
;
; If style=InquireInfo, then GDI is asking that the parameters
; passed be interpreted and the appropriate GDI information
; for the device be returned in lpDevice.
;
; If style=EnableDevice, then GDI is requesting that the device
; be initialized and lpDevice be initialized with whatever
; data is needed by the device.
;
; The three other pointers passed in will be the same for both
; calls, allowing for the device to request only the minimum
; required for a device that is supported.  These will be
; ASCIIZ strings or NULL pointers if no parameter was given.
; These strings are ignored by the display drvier.
;
; For the inquire function, the number of bytes of GDIINFO placed
; into lpDevice is returned.  For the enable function, non-zero is
; returned for success.  In both cases, zero is returned for an error.
;
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	PhysicalEnable
; History:
;  Mon 21-Sep-1987 00:20:57 -by-  **** ***** [*****]
; Added call to hook_int_2Fh
;
;  Wed 12-Aug-1987 17:16:37 -by-  **** ***** [*****]
; Made non-resident.
;
;  Tue 19-May-1987 22:01:34 -by-  *** ****** [******]
; Added code to modify GDI info table if EGA doesn't have enough
; memory to make use of save_screen_bitmap
;
;  Fri 26-Jun-1987 15:00:00 -by-  *** ****** [******]
; Removed code mentioned above and put it in EGAINIT.ASM, in an INIT
; segment.  This restores the integrity of the device-dependence levels
; within the Mondo Tree Structure of Death.
;
;  Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
; Initial version
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
; {
;   if (style == inquire)
;   {
;	*(GDIINFO)lpDevice = (GDIINFO)info_table_base; //copy GDIINFO
;	return (sizeof(GDIINFO));
;   }
;
;   *lpDevice = (DEVICE)physical_device;    //Initialize Physical device
;   hook_int_2Fh();
;   return(physical_enable(lpDevice));	    //Initialize hardware
; }
;-----------------------------------------------------------------------;


;	Define _cstods.  This location will contain our data segment value.
;	Since our data segment is a single fixed data segment, this will
;	work.  Interrupt code and some other routines will need access
;	to the data segment.


	org	$+1			;The data segment value will
_cstods label	word			;  be stuffed here and kept
	org	$-1			;  current by the kernel
	public	_cstods



	assumes ds,Data
	assumes es,nothing

cProc	Enable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Physical device or GDIinfo destination
	parmW	style			;Style, Enable Device, or Inquire Info
	parmD	lp_device_type		;Device type (i.e FX80, HP7470, ...)
	parmD	lp_output_file		;DOS output file name (if applicable)
	parmD	lp_stuff		;Device specific information

cBegin
	mov	ax,cs			;Set up ds=cs
	mov	ds,ax
	assumes ds,Code

	cld
	les	di,lp_device		;--> device structure or GDIinfo dest.
	assumes es,nothing

	and	style,word ptr InquireInfo	;Is this the inquire function?

	jnz	inquire_gdi_info	;  Yes, return GDIinfo
	errnz	InquireInfo-00000001b
	errnz	EnableDevice-00000000b
	errnz	InfoContext-8000h	;Ignore infomation context flag

;	Initialize passed device block

	lea	si,physical_device	;DS:SI --> physical device to copy
	mov	cx,PHYS_DEVICE_SIZE	;Set move count
	rep	movsb
	assumes ds,Data

;;;	call	hook_int_2Fh		;Hook into multiplexed interrupt
	call	physical_enable 	;Enable device
	jmp	short exit_enable
page

;	inquire_gdi_info - Inquire Device Specific Information
;
;	The GDI device specific information is returned to the caller
;
;	The information is based on the three pointers passed in.
;	Normally this data would be interpreted and the correct
;	GDINFO returned.  This allows for dynamically returning
;	the info based on the specifics of the device actually
;	being used (i.e. a driver supporting two similar plotters
;	could return the extents of the actual plotter in use).
;
;	These parameters are ignored for display drivers.
;
;	Currently:
;		ES:DI --> where GDIINFO goes
;		DS    =   CS

inquire_gdi_info:
	lea	si,info_table_base
	mov	cx,size GDIINFO
	mov	ax,cx			;return size of GDIInfo
	rep	movsb

;;;	pop	ds
;;;	assumes ds,Data
;;;	mov	bx,ssb_mask
;;;	and	es:[di].dpRaster[-size GDIINFO],bx

exit_enable:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	12h
cEnd	<nogen>
	

	ifdef	PUBDEFS
	include cursors.pub
	endif


sEnd	code


end
