	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	PIXEL.ASM
;
; This module contains the Set/Get Pixel routine.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	Pixel
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Pixel is used to either set a pixel to a given color with the
;   current binary raster operation, or to return the color of the
;   the pixel at the given location.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


	??_out	Pixel

incDrawMode	= 1			;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include display.inc
	include pc98.inc
	include macros.mac
	.list


	externA ScreenSelector		;Selector to the screen
	externA SCREEN_W_BYTES		;Screen width in bytes
	externA COLOR_FORMAT		;Color format (0103h or 0104h)

	externNP sum_RGB_colors_alt	;Color mapping routine

	externB nec_wrmode
	externB nec_red
	externB nec_green
	externB nec_blue
	externB nec_busy
	externW	rop_indexes
	externW Y_OFFSETS

ifdef	EXCLUSION
	externNP exclude		;Exclude area from screen
	externNP unexclude		;Clear excluded area
endif


;	Define the type flags used to determine which type
;	of scan needs to be performed (color or mono).

COLOR_OP	equ	00000001b
MONO_OP 	equ	1
END_OP		equ	4
;END_OP		equ	MONO_BIT shl 1 + (1 shl (NUMBER_PLANES))


sBegin	Data

sEnd	Data
page

sBegin	Code
assumes cs,Code

	externB	 rot_bit_tbl
	externD  Code_color_table	;Index --> RGB mapping

	.xlist
SINGLE_OK	equ	1
	.list

;;; WIN1 this is now in egahires.asm
;;;
;;;rot_bit_tbl	label	byte
;;;		db	10000000b	;Table to map bit index into
;;;		db	01000000b	;  a bit mask
;;;		db	00100000b
;;;		db	00010000b
;;;		db	00001000b
;;;		db	00000100b
;;;		db	00000010b
;;;		db	00000001b
page

;--------------------------Exported-Routine-----------------------------;
; Pixel
;
;   Set or Get a Given Pixel
;
;   The given pixel is set to the given color or the given pixel's
;   physical color is returned.
;
;   The physical device may be the screen, a monochrome bitmap, or a
;   bitmap in our color format.
;
;   There will not be error checking to see if the bitmap is in our
;   color format.  If it isn't, then we'll treat the bitmap as monochrome.
;
;   If lp_draw_mode is NULL, then the physical color of the pixel is
;   returned.  If lp_draw_mode isn't NULL, then the pixel will be set
;   to the physical color passed in, combined with the pixel already
;   at that location according to the raster-op in lp_draw_mode.  Pixel
;   doesn't pay attention to the background mode.
;
;   No clipping of the input value is required.  GDI clips the
;   coordinate before it is passed in, for both Set and Get.
;
; Entry:
;	EGA registers in default state
; Returns:
;	DX:AX = physical color if get pixel
;	DX:AX = positive if no error and set was OK.
; Error Returns:
;	DX:AX = 8000:0000H if error occured
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	exclude_far	(far version of exclude)
;	unexclude_far	(far version of unexclude)
; History:
;	Sat 31-Oct-1987 00:21:06 -by-  **** ***** [*****]
;	Added clipping of the (X,Y)
;
;	Tue 18-Aug-1987 14:50:37 -by-  **** ***** [*****]
;	Added test of the disabled flag.
;
;	Wed 12-Aug-1987 19:55:20 -by-  **** ***** [*****]
;	Moved to _PIXEL.  Removed stack checking.
;
;	Thu 06-Aug-1987          -by-  ***** ****** [mitchl]
;	Put code into segment _LINES
;
;	Tue 03-Mar-1987 20:42:07 -by-  **** ****** [******]
;	Moved a mov instruction in EGA ROP handling code.
;
;	Sun 22-Feb-1987 16:29:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	externNP my_check_stack

	assumes ds,Data
	assumes es,nothing
;
; PIXEL seems to have been built with a different prelude macro, so I'm
; going to have to do this by hand...
;
;;cProc	Pixel,<FAR,PUBLIC,WIN,PASCAL>,<si,di>
;;
;;	parmD	lp_device		;Pointer to device
;;	parmW	x			;X coordinate of pixel
;;	parmW	y			;Y coordinate of pixel
;;	parmD	p_color 		;Physical color to set pixel to
;;	parmD	lp_draw_mode		;Drawing mode to use, or null if Get
;;
;;	localW	is_device		;set non-zero if the device

lp_device	equ	dword ptr [bp+12h]
x		equ	word ptr [bp+10h]
y		equ	word ptr [bp+0Eh]	
p_color		equ	byte ptr [bp+0Ah]
lp_draw_mode	equ	dword ptr [bp+6]
seg_lp_draw_mode equ	word ptr [bp+8]
off_lp_draw_mode equ	word ptr [bp+6]
bp03		equ	byte ptr [bp-3]

	public	Pixel
Pixel	proc	far
	mov	ax, ds
	nop
	inc	bp
	push	bp
	mov	bp,sp
	push	ds
	mov	ds, ax
	mov	ax, 2
	call	my_check_stack
	push	si
	push	di
	
	jnc	pixel_00
	jmp	pixel_exit

pixel_00:
;;;	mov	al,enabled_flag 	;Load this before trashing DS
	lds	si,lp_device		;--> physical device
	assumes ds,nothing
	mov	cx,[si].bmType		;Get device type
	jcxz	pixel_20		;Memory bitmap, skip EGA specific code

;	This is the device.  The cursor must be excluded from the pixel
;	that will be processed.  The innerloop mask for the device will
;	be set for color.  The width of a plane will be set to 1 to flag
;	to the loop code that this is the EGA (odd widths are illegal).


ifdef	EXCLUSION			;If exclusion required
	mov	cx,x			;Set left
	mov	dx,y			;    top
	mov	si,cx			;    right
	mov	di,dx			;    bottom
	call	exclude 		;Exclude the area
	lds	si, lp_device
endif

pixel_20:

;	This is a memory DC.  If this is a monochrome memory DC, set up
;	the inner loop so that it will terminate after one time through
;	and set the color to be equal to the mono bit in the physical
;	color.	If it is color, set up the inner loop for all planes,
;	same as for the display.
;
;	Also handle modifying Y for huge bitmaps is necessary.
;
;
;	Currently:
;		AX     =  Y coordinate
;		DX     =  Segment bias for huge bitmaps
;		DS:SI --> PDevice
;		CH     =  Huge bitmap flag
;			  (0 = small bitmap)

pixel_40:
	mov	cl,MONO_OP		;Assume mono loop
	cmp	wptr [si].bmPlanes, COLOR_FORMAT
	jz	pixel_60		;Not our color format, treat as mono
	mov	al, bptr p_color+3
	rol	al, 1
	cbw
	mov	bptr p_color,ah
pixel_50:
	mov	cl, END_OP		;Show color loop

pixel_60:
	mov	ax, [si].bmWidthBytes
pixel_61:
	mul	y
	mov	dx, wptr [si].bmWidthPlanes
	lds	si, [si].bmBits
	add	si, ax

;	Currently:
;		DS:DI --> the bitmap, start of the correct scan
;		DI = Index to next plane of the scan
;		     1 if the display (odd with illegal)
;		CL = looping flag

	mov	ax, x			;Get X coordinate
	mov	bx,ax
	shiftr	ax,3			;Compute byte offset from start of scan
	add	si,ax			;ds:si --> byte of pixel

	and	bx,word ptr 00000111B	;Get bit mask for bit
	mov	ch,rot_bit_tbl[bx]
	mov	di,off_lp_draw_mode	;If a drawmode was given
	mov	bx,seg_lp_draw_mode	;  then set the pixel, else
	mov	ax,bx			;  return it's physical color
	or	ax,di
	jnz	pixel_100		;Given, operation is set pixel
	jmp	pixel_200		;Not given, return pixel color




;	The operation to be performed is SetPixel.  Currently:
;
;		CH    =   bit mask
;		DS:SI --> byte bit is to be set in
;		BX:DI --> physical drawing mode
;		CL    =   loop mask
;		DX    =   Index to next plane
;			  1 if the display


pixel_100:
	mov	es,bx			;ES:DI --> drawmode
	assumes es,nothing

	mov	bx,es:[di].Rop2 	;Get drawing mode to use
	dec	bx			;Make it zero based
	and	bx,word ptr 000Fh	;Keep it valid
pixel_120:
	lea	di, p_color
	push	bp
	or	dx, dx
	jnz	pixel_129
	cmp	bx, 0
	jnz	pixel_121
	mov	al, 0
	jmp	pixel_180
;
pixel_121:
	cmp	bx, 3
	jnz	pixel_122
	jmp	pixel_195
;
pixel_122:
	cmp	bx, 0Ch
	jnz	pixel_123
	jmp	pixel_195
;
pixel_123:
	cmp	bx, 0Fh
	jnz	pixel_124
	mov	al, 0FFh
	jmp	pixel_180
;
pixel_124:
	cmp	bx, 5
	jnz	pixel_129
	mov	bp03, 1
	jmp	pixel_190

pixel_129:	
	shl	bx,1			;Set rop_indexes table address
	mov	bp, cs:rop_indexes[bx]	;  for the given rop
pixel_130:
pixel_140:
	mov	al, ss:[di]
	mov	bh, al
	mov	ah, [si]	;Load EGA latches
	call	bp
	xor	al, ah
	and	al, ch
	xor	al, ah
	mov	[si], al
	or	dx, dx
	jz	pixel_170
	add	si, dx
pixel_150:
	inc	di
	rol	cl, 1
	test	cl, 8
	jz	pixel_130
pixel_160:
	pop	bp
	jmp	pixel_300
;
pixel_170:
	push	ax
	mov	ax, ds
	add	ax, PC98_PLANE_OFFSET
	mov	ds, ax
	pop	ax
	jmp	short pixel_150
;
pixel_180:
	mov	cs:nec_red, al
	mov	cs:nec_green, al	
	mov	cs:nec_blue, al
	push	ax
	mov	al, 0C8h
	mov	cs:nec_wrmode, al
	cli
	mov	cs:nec_busy, 1
	out	PC98_WRMODE, al
	pop	ax
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	jmp	short $+2
	jmp	short $+2
	mov	[si],ch
	mov	al,0
	mov	cs:nec_busy,al
	out	PC98_WRMODE, al
	sti
	jmp	short pixel_160
;
pixel_190:
	mov	al, [si]
	not	al
	test	bp03, 1
	jz	pixel_191
	mov	cs:nec_red, al
pixel_191:
	test	bp03, 2
	jz	pixel_192
	mov	cs:nec_green, al
pixel_192:
	mov	cs:nec_blue, al
	test	bp03, 4
	jz	pixel_193
	jmp	pixel_194
;
pixel_193:
	shl	bp03, 1
	push	bp
	mov	bp, ds
	add	bp, PC98_PLANE_OFFSET
	mov	ds, bp
	pop	bp
	jmp	short pixel_190
;
pixel_194:
	mov	al, 0C8h
	mov	cs:nec_wrmode, al
	cli
	mov	cs:nec_busy, 1
	out	PC98_WRMODE, al
	mov	al, cs:nec_red
	out	PC98_WRPLANE, al
	mov	al, cs:nec_green
	out	PC98_WRPLANE, al
	mov	al, cs:nec_blue
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	jmp	short $+2
	jmp	short $+2
	mov	[si], ch
	mov	al, 0
	mov	cs:nec_busy, al
	out	PC98_WRMODE, al
	sti
	jmp	pixel_160	
;
pixel_195:
	push	cx
	mov	cx, 3
pixel_196:
	mov	al, ss:[di]
	cmp	bx, 0Ch
	jz	pixel_197
	not	al
pixel_197:
	cmp	cx, 3
	jnz	pixel_198
	mov	cs:nec_red, al
pixel_198:
	cmp	cx, 2
	jnz	pixel_199
	mov	cs:nec_green, al
pixel_199:
	mov	cs:nec_blue, al
	inc	di
	loop	pixel_196
	pop	cx
	mov	al, 0C8h
	mov	cs:nec_wrmode, al
	cli
	mov	cs:nec_busy, 1
	out	PC98_WRMODE, al
	mov	al, cs:nec_red
	out	PC98_WRPLANE, al
	mov	al, cs:nec_green
	out	PC98_WRPLANE, al
	mov	al, cs:nec_blue
	out	PC98_WRPLANE, al
	out	PC98_WRPLANE, al
	jmp	short $+2
	jmp	short $+2
	mov	[si], ch
	mov	al, 0
	mov	cs:nec_busy, al
	out	PC98_WRMODE, al
	sti
	jmp	pixel_160	
		
page

;	The operation to be performed is get pixel.  The color of the
;	pixel will be returned.  The color of the pixel will be composed
;	from all planes if a color bitmap and the result "AND"ed to
;	produce the mono bit in the physical color (this is the same
;	as bitblt when blting from color to monochrome).
;
;	If this is a monochrome bitmap, then the color will simply be
;	black or white.
;
;	Currently:
;
;		CH     =  bit mask
;		CL     =  loop mask
;		DX     =  index to next plane
;			  1 if physical device
;		DS:SI --> byte bit is to be set in


WHITE	equ	C0_BIT+C1_BIT+C2_BIT+C3_BIT+MONO_BIT+ONES_OR_ZEROS
BLACK	equ	ONES_OR_ZEROS


pixel_200:
	cmp	cl,END_OP		;Is this for a mono bitmap?
	jne	pixel_210		;  No, its for color
	xor	dx,dx			;Assume pixel is black
	xor	ax,ax
	test	[si],ch 		;Is pixel black?
	jz	pixel_300		;  It is, return color in AX:DX
	dec	ax			;  No, set AX:DX for white
	mov	dx, 47FFh	;;; WHITE*256+0FFh
	jmp	short pixel_300



;	Counter the first DEC SI which the EGA will throw in
;	if this is for the EGA.  DX will be 1 if it is.  DX
;	cannot be 0 at this point.


pixel_210:
	mov	bl, bh
	mov	bh, al
pixel_220:
	xor	ax, ax
	test	[si], ch
	jz	pixel_230
	dec	ax
pixel_230:
	or	dx, dx
	jz	pixel_260
pixel_240:
	add	si,dx			;--> next plane
pixel_250:
	rol	cl, 1			;Select next plane
	test	cl, 8			;Done with all planes?
	jz	pixel_210		;  Not yet
	jmp	short pixel_290
;
pixel_260:
	push	ax
	mov	ax, ds
	add	ax, PC98_PLANE_OFFSET
	mov	ds, ax
	pop	ax
	jmp	short pixel_250
pixel_290:
	mov	dx, ax
	mov	ax, bx
	call	sum_RGB_colors_alt 	;Get the real physical color into DX:AX

pixel_300:
ifdef	EXCLUSION
	call	unexclude		;Clear any exclude rectangle
endif
pixel_exit:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	10h

Pixel	endp

ifdef	PUBDEFS
	.xlist
	include PIXEL.PUB
	.list
endif

sEnd	Code
	end
