	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CONTROL.ASM
;
; This module contains the escape handler for the color display
; drivers.
;
; It also contains stubs for the SetAttribute function and the
; DeviceBitmap function, both of which this driver does not
; support.
;
; Created: 16-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	Control
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   Control is the routine which is called when an Escape call
;   is made to GDI.  This driver only implements two of the
;   escape functions.  These functions set and get the color
;   table.  Since the color table is not setable for the display,
;   the current value is just returned.
;
;   Support for QUERYESCSUPPORT has now been added.  This escape
;   function is required of all drivers.  It informs the caller
;   which escape functions are supported (QUERYESCSUPPORT will
;   return TRUE for QUERYESCSUPPORT!).
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incControl	=	1		;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include macros.mac
	.list


	??_out	Control

	externA COLOR_TBL_SIZE		;# entries in the color table

sBegin	Code
assumes cs,Code


page
;--------------------------Exported-Routine-----------------------------;
; Control
;
;   Control is defined so that device specific commands can be issued
;   that are not supported by GDI.  Some of the Control functions have
;   been defined by GDI so that devices that can perform them (and need
;   to) can do so, such as clear device.
;
;   Clear device will not be allowed.  Nobody should do that to the
;   system console!
;
;   Set/Get color table will be implemented.  GetColorTable will
;   return the color in the table for the index passed.
;
;   SetColorTable should return the color that was actually set
;   into the table.  Since this driver doesn't allow setting the
;   color table, the Set function is the same as the Get function.
;
; Entry:
;	None
; Returns:
;	AX = 1 if success
; Error Returns:
;	AX = 0 if error
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	None
; History:
;	Sun 27-Sep-1987 21:35:42 -by-  **** ***** [*****]
;	Added QUERYESCSUPPORT, which is the one required
;	escape function all drivers must support.
;
;	When queried if we support SETCOLORTABLE, we'll
;	return false.  The code will continue to return
;	current color table index if we get the SETCOLORTABLE
;	call.
;
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	made non-resident
;
;	Wed 18-Mar-1987 14:04:30 -by-  **** ***** [*****]
;	Added COLOR_TBL_SIZE so the code can be shared
;	between black/white and color drivers.
;
;	Mon 16-Feb-1987 18:09:09 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing

cProc	Control,<FAR,PUBLIC,WIN,PASCAL>,<di>

	parmD	lp_device
	parmW	function
	parmD	lp_in_data
	parmD	lp_out_data

cBegin
	xor	ax,ax			;Assume error
;;;	mov	bx,function
	cmp	function,SETCOLORTABLE	;Process set/get color table
	je	is_color_table
	cmp	function,GETCOLORTABLE
	jnz	exit_control
is_color_table:
	lds	di,lp_in_data		;Get pointer to the data
	assumes ds,nothing
	mov	bx, [di]		;Get color table index
	cmp	bx, bptr COLOR_TBL_SIZE-1	;Legal index?
	ja	exit_control		;Illegal index, return error
	sub	ax,bx			;Compute color table address
	les	di,lp_out_data		;--> where value is returned
	assumes es,nothing
	cld
	stosw
	xor	ah, ah
	stosw
exit_control_inc_ax:
	mov	al, 1			;Return 1 to show OK
exit_control:

	pop	di
	sub	bp, 2
	mov	sp, bp	
	pop	ds
	pop	bp
	dec	bp
;XXX	retf	0Eh
	db	0CAh, 0Eh

cEnd	<nogen>
	





sEnd	Code

	ifdef	PUBDEFS
	include control.pub
	endif

end
