	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	ENUM.ASM
;
;   This module contains routines which enumerate a subset of the
;   objects which the device can enumerate.
;
; Created: 16-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1983-1987 Microsoft Corporation
;
; Exported Functions:	Control
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
;   A subset of the fonts, pens, and brushes which this driver can
;   support are enumerated for the caller, until all objects of the
;   requested type have been enumerated or the caller aborts.
;
; Restrictions:
;
;-----------------------------------------------------------------------;


;

incLogical	= 1			;Include control for gdidefs.inc
incFont 	= 1			;Include control for gdidefs.inc
incDevice	= 1			;for GDIINFO

	.xlist
	include cmacros.inc
	include gdidefs.inc
	include windefs.inc
	include macros.mac
	.list


	??_out	enum

	externA COLOR_TBL_SIZE		;# entries in the color table
	externA PHYS_DEVICE_SIZE 

sBegin	Data
	externB	inquire_data
sEnd	Data

sBegin	Code
assumes cs,Code

	externB physical_device
	externB info_table_base
	externNP physical_enable
	externNP physical_disable

page
;--------------------------Exported-Routine-----------------------------;
; EnumDeviceFonts
;
;   Enumerate Device Fonts is called to enumerate the fonts available
;   on a given device.	For each appropriate font, the callback function
;   is called with the information for that font.  The callback function
;   is called until there are no more fonts or the callback function
;   returns zero.
;
;   Since this driver has no fonts to enumerate, all that need be done
;   is return a success flag (1).
;
; Entry:
;	None
; Returns:
;	AX = 1
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	None
; Calls:
;	None
; History:
;	Wed 12-Aug-1987 19:16:11 -by-  **** ***** [*****]
;	Made non-resident
;
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing


cProc	EnumDFonts,<FAR,PUBLIC,WIN,PASCAL>

	parmD	lp_device		;Physical device
	parmD	lp_face_name		;Face name
	parmD	lp_callback_func	;Callback function
	parmD	lp_client_data		;Data to pass the callback function

cBegin

	mov	ax,1			;This is a nop for this driver
	sub	bp,2
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	retf	10h

cEnd <nogen>
page
;--------------------------Exported-Routine-----------------------------;
; EnumObject
;
;   The given style of object is enumerated through a callback
;   facility.  Since there are only a few objects within this
;   particular driver, they will all be enumerated.
;
;   If the Callback function returns a zero, then the enumeration
;   will be terminated.
;
; Entry:
;	None
; Returns:
;	AX = last value returned from callback function.
;	AX = 1 if nothing was enumerated.
; Error Returns:
;	None
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	None
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,Data
assumes es,nothing


cProc	EnumObj,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device
	parmW	style
	parmD	lp_callback_func
	parmD	lp_client_data

;;;	localW	old_SP
	localV	obj_area,%(size LogBrush)
	errnz	<(SIZE LogBrush)-(SIZE LogPen)-2>	;Want the biggest!

cBegin

;;;	mov	old_SP,sp		;Save SP for clean-up
	cmp	style,OBJ_PEN		;Pen?
	je	enum_pen		;  Yes
	cmp	style,OBJ_BRUSH 	;Brush?
	je	enum_brush		;  Yes
	mov	ax,1

exit_enum_obj:
;;;	mov	sp,old_SP		;Remove any return addresses from stack

	pop	di	;The Win2 cEnd is slightly different from the
	pop	si	;Win1 version
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	0Eh

cEnd <nogen>
page

;--------------------------Private-Routine------------------------------;
; enum_pen
;
;   The pens which this driver can realize are enumerated for
;   the caller until either all pens have been enumerated or
;   the user aborts.
;
;
;   This driver supports five styles of pens, in the number of
;   colors appropriate for the driver.
;
;   The NULL Pen is not enumerated.
;
; Entry:
;	None
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user's aborts enumeration
; Registers Preserved:
;	DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	do_color
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


enum_pen proc	near

	xor	si,si				;Initialize pen style
	mov	obj_area.lopnWidth.xcoord,si	;Set nominal width
	mov	obj_area.lopnWidth.ycoord,si	;Set width

enum_pen_10:
	mov	obj_area.lopnStyle,si		;Set style
	xor	di,di
enum_pen_20:
	mov	ax, di
	xor	ah, ah
	mov	wptr obj_area.lopnColor, di
	mov	wptr obj_area.lopnColor + 2, ax
	call	call_client
;;;	xor	di,wptr 0FFFFh
	db	81h, 0F7h, 0FFh, 0FFh		;Overlong XOR DI
	jnz	enum_pen_20
	inc	si				;Set next pen style
	cmp	si,LS_NOLINE			;At maximum line style?
	jb	enum_pen_10			;  No, continue

enum_pen_30:
	jmp	exit_enum_obj			;Done enumerating stuff

	errnz	LS_SOLID
	errnz	LS_DASHED-1
	errnz	LS_DOTTED-2
	errnz	LS_DOTDASHED-3
	errnz	LS_DASHDOTDOT-4
	errnz	LS_NOLINE-5			;Not enumerated
	errnz	MaxLineStyle-LS_NOLINE		;Should be no other pens

enum_pen endp
page
;--------------------------Private-Routine------------------------------;
; enum_brush
;
;   The brushes that the driver supports will be enumerated.
;
;   This driver supports 256K worth of ditherd brushes, so only
;   a few of them will enumerated.  These will be based on the
;   five grey scales defined in brush_colors.  All hatched brushes
;   will be enumerated.  The background color for hatched brushes
;   is not enumerated.
;
;   The Hollow Brush will not be enumerated.
;
; Entry:
;	None
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user's aborts enumeration
; Registers Preserved:
;	DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,FLAGS
; Calls:
;	do_color
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

;	The Logical colors that will be returned for the enumeration
;	of the solid brushes


	externB brush_colors 

NUMBER_GREYS equ 5

assumes ds,nothing
assumes es,nothing


enum_brush proc near

	xor	di,di
	mov	obj_area.lbStyle,di		;Set brush style
	errnz	BS_SOLID
	mov	obj_area.lbHatch,di		;Clear hatch index
	mov	di,2*NUMBER_GREYS		;Initialize blue index

enum_brush_10:
	mov	ax,wptr cs:brush_colors-2[di] 	;Get colour
	mov	wptr obj_area.lbColor[0],ax	
	xor	ah,ah
	mov	wptr obj_area.lbColor[2],ax
	call	call_client
	sub	di,2				;Out of red?
	jnz	enum_brush_10			;  No, continue


;	Now enumerate the hatched brushes.  When enumerating hatched
;	brushes, the background color is not enumerated.

	mov	obj_area.lbStyle, 2		;Set brush style
	mov	si,HS_DIAGCROSS 		;Initialize hatch index

enum_brush_40:
	mov	obj_area.lbHatch,si		;Set style
	xor	di,di
enum_brush_50:
	mov	ax, di
	xor	ah, ah
	mov	wptr obj_area.lbColor, di
	mov	wptr obj_area.lbColor + 2, ax
	call	call_client
;;;	xor	di,wptr 0FFFFh
	db	81h, 0F7h, 0FFh, 0FFh		;Overlong XOR DI
	jnz	enum_brush_50
	dec	si				;Set next hatch index
	jns	enum_brush_40			;For all hatch indexes
	jmp	enum_pen_30			;Done enumerating stuff

enum_brush endp
page
;--------------------------Private-Routine------------------------------;
; call_client
;
;   The client callback routine is called with the current
;   logical object in obj_area.
;
; Entry:
;	object in obj_area
; Returns:
;	AX = non-zero
; Error Returns:
;	jumps to exit_enum_obj if user aborts enumeration
; Registers Preserved:
;	SI,DI,DS,BP
; Registers Destroyed:
;	AX,BX,CX,DX,ES,FLAGS
; Calls:
;	[lp_callback_func] - user supplied callback procedure
; History:
;	Tue 17-Feb-1987 21:17:40 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;


assumes ds,nothing
assumes es,nothing


call_client	proc	near

	lea	ax,obj_area
	farPtr	ptr1,ss,ax
	cCall	lp_callback_func,<ptr1,lp_client_data>
	pop	bx			;Return address
	or	ax,ax
	jz	enum_pen_30		;Client is bailing out
	jmp	bx			

call_client	endp
page

page
;--------------------------Exported-Routine-----------------------------;
; WORD Inquire(lpCURSORINFO)
; CURSORINFO far *lpCURSORINFO; //pointer where cursor info goes
; 
; Information about the pointer is returned to the caller in the
; given buffer.  The number of bytes copied into lpCURSORINFO
; is returned.
;
; Warnings:
;	Destroys AX,CX,ES,FLAGS
; Effects:
;	none
; Calls:
;	none
; History:
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	Made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; WORD Inquire(lpCURSORINFO)
; CURSORINFO far *lpCURSORINFO; 	//pointer where cursor info goes
; {
;   *lpCURSORINFO = inquire_data;	//copy entire structure
;   return (sizeof(CURSORINFO));
; }
;-----------------------------------------------------------------------;
cProc	Inquire,<PUBLIC,FAR,WIN,PASCAL>,<si,di>

	parmD	lp_cursor_info		;Where to put the data

cBegin
	les	di,lp_cursor_info	;--> destination area
	assumes es,nothing

	mov	si,offset inquire_data
	mov	ax,size CURSORINFO	;Return code is # of bytes moved
	mov	cx,ax
	cld
	rep	movsb

cEnd	<nogen>
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4


rop0:	xor	al, al
rop0_:	ret

rop2:	not	al
	and	al, ah
rop2_:	ret
;
rop3:	not	al
rop3_:	ret
;
rop4:	not	ah
	and	al, ah
	not	ah
rop4_:	ret
;
ropa:	mov	al, ah
ropa_:	ret
;
rop5:	mov	al, ah
	not	al
rop5_:	ret
;
rop6:	xor	al, ah
rop6_:	ret
;
rop9:	xor	al, ah
	not	al
rop9_:	ret
;
rop8:	and	al, ah
rop8_:	ret
;
rop7:	and	al, ah
	not	al
rop7_:	ret
;
ropb:	not	al
	or	al, ah
ropb_:	ret
;
ropd:	not	ah
	or	al, ah
	not	ah
ropd_:	ret
;
rope:	or	al, ah
rope_:	ret
;
rop1:	or	al, ah
	not	al
rop1_:	ret
;
ropf:	mov	al, 0FFh
ropf_:	ret
;
ropc:	
ropc_:	ret
;
	public	rop_indexes
	public	rop_lengths

rop_indexes	label	word
	dw	offset rop0
	dw	offset rop1
	dw	offset rop2
	dw	offset rop3
	dw	offset rop4
	dw	offset rop5
	dw	offset rop6
	dw	offset rop7
	dw	offset rop8
	dw	offset rop9
	dw	offset ropa
	dw	offset ropb
	dw	offset ropc
	dw	offset ropd
	dw	offset rope
	dw	offset ropf

rop_lengths	label	byte
	db	rop0_-rop0
	db	rop1_-rop1
	db	rop2_-rop2
	db	rop3_-rop3
	db	rop4_-rop4
	db	rop5_-rop5
	db	rop6_-rop6
	db	rop7_-rop7
	db	rop8_-rop8
	db	rop9_-rop9
	db	ropa_-ropa
	db	ropb_-ropb
	db	ropc_-ropc
	db	ropd_-ropd
	db	rope_-rope
	db	ropf_-ropf

;--------------------------Exported-Routine-----------------------------;
; INT DeviceMode(hWnd,hInst,lpDeviceType,lpOutputFile)
; HWND	hWnd;
; HINST hInst;
; LPSTR lpDeviceType;
; LPSTR lpOutputFile;
; 
; This routine is a nop for all display drivers.  It returns -1 to
; show success, just to keep everyone happy.
;
; Warnings:
;	none
; Effects:
;	none
; Calls:
;	none
; History:
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; INT DeviceMode(hWnd,hInst,lpDeviceType,lpOutputFile)
; HWND	hWnd;
; HINST hInst;
; LPSTR lpDeviceType;
; LPSTR lpOutputFile;
; {
;   return (-1);
; }
;-----------------------------------------------------------------------;

	public	DeviceMode

cProc	DeviceMode,<FAR,PUBLIC,WIN,PASCAL>

	parmW	h_wnd			;Handle to window
	parmW	h_inst			;Handle to instance
	parmD	lp_device_type		;Pointer to device (e.g. "HP7470")
	parmD	lp_output_file		;Pointer to output file (e.g. COM1:)


cBegin

	mov	ax,-1			;Show success
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	12			;Return, popping parameters

cEnd	<nogen>

	public	Enable
page
;--------------------------Exported-Routine-----------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
;
; Enable - Enable Device
;
; The given device is either initialized or the GDI information
; for the given device is returned.
;
; If style=InquireInfo, then GDI is asking that the parameters
; passed be interpreted and the appropriate GDI information
; for the device be returned in lpDevice.
;
; If style=EnableDevice, then GDI is requesting that the device
; be initialized and lpDevice be initialized with whatever
; data is needed by the device.
;
; The three other pointers passed in will be the same for both
; calls, allowing for the device to request only the minimum
; required for a device that is supported.  These will be
; ASCIIZ strings or NULL pointers if no parameter was given.
; These strings are ignored by the display drvier.
;
; For the inquire function, the number of bytes of GDIINFO placed
; into lpDevice is returned.  For the enable function, non-zero is
; returned for success.  In both cases, zero is returned for an error.
;
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	PhysicalEnable
; History:
;  Mon 21-Sep-1987 00:20:57 -by-  **** ***** [*****]
; Added call to hook_int_2Fh
;
;  Wed 12-Aug-1987 17:16:37 -by-  **** ***** [*****]
; Made non-resident.
;
;  Tue 19-May-1987 22:01:34 -by-  *** ****** [******]
; Added code to modify GDI info table if EGA doesn't have enough
; memory to make use of save_screen_bitmap
;
;  Fri 26-Jun-1987 15:00:00 -by-  *** ****** [******]
; Removed code mentioned above and put it in EGAINIT.ASM, in an INIT
; segment.  This restores the integrity of the device-dependence levels
; within the Mondo Tree Structure of Death.
;
;  Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
; Initial version
;-----------------------------------------------------------------------;

;------------------------------Pseudo-Code------------------------------;
; INT Enable(lpDevice,style,lpDeviceType,lpOutputFile,lpStuff)
; DEVICE lpDevice;		//device block or GDIInfo destination
; INT	 style; 		//Style of initialization
; LPSTR  lpDeviceType;		//Device type (i.e FX80, HP7470, ...)
; LPSTR  lpOutputFile;		//DOS output file name (if applicable)
; LPSTR  lpStuff;		//Device specific information
; {
;   if (style == inquire)
;   {
;	*(GDIINFO)lpDevice = (GDIINFO)info_table_base; //copy GDIINFO
;	return (sizeof(GDIINFO));
;   }
;
;   *lpDevice = (DEVICE)physical_device;    //Initialize Physical device
;   hook_int_2Fh();
;   return(physical_enable(lpDevice));	    //Initialize hardware
; }
;-----------------------------------------------------------------------;


;	Define _cstods.  This location will contain our data segment value.
;	Since our data segment is a single fixed data segment, this will
;	work.  Interrupt code and some other routines will need access
;	to the data segment.


	org	$+1			;The data segment value will
_cstods label	word			;  be stuffed here and kept
	org	$-1			;  current by the kernel
	public	_cstods



	assumes ds,Data
	assumes es,nothing

cProc	Enable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device		;Physical device or GDIinfo destination
	parmW	style			;Style, Enable Device, or Inquire Info
	parmD	lp_device_type		;Device type (i.e FX80, HP7470, ...)
	parmD	lp_output_file		;DOS output file name (if applicable)
	parmD	lp_stuff		;Device specific information

cBegin
	mov	ax,cs			;Set up ds=cs
	mov	ds,ax
	assumes ds,Code

	cld
	les	di,lp_device		;--> device structure or GDIinfo dest.
	assumes es,nothing

	and	style,word ptr InquireInfo	;Is this the inquire function?

	jnz	inquire_gdi_info	;  Yes, return GDIinfo
	errnz	InquireInfo-00000001b
	errnz	EnableDevice-00000000b
	errnz	InfoContext-8000h	;Ignore infomation context flag

;	Initialize passed device block

	lea	si,physical_device	;DS:SI --> physical device to copy
	mov	cx,PHYS_DEVICE_SIZE	;Set move count
	rep	movsb
	assumes ds,Data

;;;	call	hook_int_2Fh		;Hook into multiplexed interrupt
	call	physical_enable 	;Enable device
	jmp	short exit_enable
page

;	inquire_gdi_info - Inquire Device Specific Information
;
;	The GDI device specific information is returned to the caller
;
;	The information is based on the three pointers passed in.
;	Normally this data would be interpreted and the correct
;	GDINFO returned.  This allows for dynamically returning
;	the info based on the specifics of the device actually
;	being used (i.e. a driver supporting two similar plotters
;	could return the extents of the actual plotter in use).
;
;	These parameters are ignored for display drivers.
;
;	Currently:
;		ES:DI --> where GDIINFO goes
;		DS    =   CS

inquire_gdi_info:
	lea	si,info_table_base
	mov	cx,size GDIINFO
	mov	ax,cx			;return size of GDIInfo
	rep	movsb

;;;	pop	ds
;;;	assumes ds,Data
;;;	mov	bx,ssb_mask
;;;	and	es:[di].dpRaster[-size GDIINFO],bx

exit_enable:
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	12h
cEnd	<nogen>
	

page
;--------------------------Exported-Routine-----------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
;
; The display driver's physical disable routine is called to disable
; graphics and enter a character mode of operation.
;
; Warnings:
;	Destroys AX,BX,CX,DX,ES,FLAGS
; Effects:
;	none
; Calls:
;	physical_disable
; History:
;	Tue 18-Aug-1987 18:06:47 -by-  **** ***** [*****]
;	Pass ES = Data to physical disable
;
;	Wed 12-Aug-1987 17:29:30 -by-  **** ***** [*****]
;	Made non-resident
;
;	Fri 16-Jan-1987 17:52:12 -by-  **** ***** [*****]
;	Initial version
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; INT Disable(lpPDevice)
; DEVICE lpPDevice;
; {
;   physical_disable(lpPDevice);	// Do all the work here
;   return(-1); 			// Show success
; }
;-----------------------------------------------------------------------;

	public	Disable

cProc	Disable,<FAR,PUBLIC,WIN,PASCAL>,<si,di>

	parmD	lp_device

cBegin

;;;	push	ds			;To break less drivers, pass
;;;	pop	es			;  DGROUP in ES instead of DS
;;;	assumes	es,Data

	lds	si,lp_device		;--> logical device
	assumes ds,nothing

;;;	push	es			;physical_disable can destroy ES
	call	physical_disable	;Restore device
;;;	pop	es			;need DGROUP in ES for restore_int_2Fh
	assumes	es,Data
;;;	call	restore_int_2Fh
	mov	ax,-1			;Show success
	
	pop	di
	pop	si
	sub	bp, 2
	mov	sp, bp
	pop	ds
	pop	bp
	dec	bp
	retf	4
cEnd	<nogen>



sEnd	Code

	ifdef	PUBDEFS
	include enum.pub
	endif

end
