	page	,132

;-----------------------------Module-Header-----------------------------;
; Module Name:  VIKFUNCS.ASM
;
;     Helper functions for the Viking I.
;
;-----------------------------------------------------------------------;


;


	include	cmacros.inc
	include	gdidefs.inc
	include	macros.mac
	include	vikingi.inc
	include	cursor.inc
	include	windefs.inc

sBegin	Data
	public	rdscr_flags, wrscr_flags

	externB	vik_busy
rdscr_flags	db	0
rdscr_rwp0	dw	0
rdscr_rwp1	dw	0
rdscr_count	dw	0
rdscr_bufaddr		dw	0

		db	16 dup(0)
rdscr_buf	db	256 dup(0)
		db	16 dup(0)	
wrscr_flags	db	0
wrscr_rwp0	dw	0
wrscr_rwp1	dw	0
wrscr_count	dw	0
wrscr_bufaddr	dw	0
W01BA		dw	0
		db	16 dup(0)
wrscr_buf	label	byte
configfile_buff db	256 dup(0)
		db	16 dup(0)
sEnd	Data


sBegin	Code

	assumes cs,Code

	externB bus_width
	externW	io_base
	externW	_cstods

	public	busy_xflush
	public	viking_xflush
	public	viking_flush
	public	flush_0_abort
	public	mkbusy
	public	endbusy
	public	viking_waitread
	public	X49EB
	public	RopFlags
	public	mirror_byte
	public	mirror_invert
	public	X53EB
	public	X5457
	public	X54E4
	public	X55C9
	public configfile_buff

busy_xflush	proc	near
	push	ds
	mov	ds, cs:_cstods
	assumes	ds,Data
	mov	vik_busy, 1
	pop	ds
busy_xflush	endp

viking_xflush	proc	near
	mov	dx, cs:io_base	
	xor	al, al
	out	dx, al
	add	dx, 2
	jmp	viking_flush
viking_xflush	endp

mkbusy	proc	near
	push	ds
	mov	ds, cs:_cstods
	assumes	ds,Data
	mov	vik_busy, 1
	pop	ds
	ret
mkbusy	endp
;
endbusy	proc	near
	push	ax
	push	dx
	push	ds
	mov	dx, cs:io_base
	add	dx, 2
	call	flush_0_abort
	mov	ds, cs:_cstods
	assumes	ds,Data
	mov	vik_busy, 0
	pop	ds
	pop	dx
	pop	ax
	ret
endbusy	endp
;
viking_flush	proc	near
	sub	dx, 2
viking_flush1:
	in	al, dx
	test	al, 84h	;Bit 7: Error
			;Bit 2: Read FIFO ready
	jnz	flush_1_abort
	rcr	al, 1	;Wait until write fifo is empty
	jnc	viking_flush1
	add	dx, 2
	ret
;
flush_0_abort: 
	sub	dx, 2
flush_0_abort1:
	in	al, dx
	test	al, 84h	;Bit 7: Error
			;Bit 2: Read FIFO ready
	jnz	flush_1_abort
	and	al, 23h	;Command ended with abort?
	cmp	al, 23h
	jnz	flush_0_abort1
	add	dx, 2
	ret
;
flush_1_abort:
	test	cs:bus_width, 1
	jz	flush_1_abort1
	mov	al, 2
	out	dx, al
	add	dx, 2
	in	ax, dx
	or	ax, 8000h
	out	dx, ax
	and	ax, 7FFFh
	out	dx, ax
	jmp	flush_1_abort2
;
flush_1_abort1:
	mov	al, 2
	out	dx, al
	add	dx, 2
	in	al, dx
	or	al, 80h	
	out	dx, al
	and	al, 7Fh
	out	dx, al
flush_1_abort2:
	sub	dx, 2
	xor	al, al
	out	dx, al
	add	dx, 2
	ret

viking_flush	endp

viking_waitread	proc	near
	sub	dx, 2
viking_waitread_1:
	in	al, dx
	test	al, 80h
	jnz	viking_waitread_2
	test	al, 4
	jz	viking_waitread_1
	add	dx, 2
	ret
;
viking_waitread_2:
	test	cs:bus_width, 1
	jz	viking_waitread_3
	mov	al, 2
	out	dx, al
	add	dx, 2
	in	ax, dx
	or	ax, 8000h
	out	dx, ax
	and	ax, 7FFFh
	out	dx, ax
	sub	dx, 2
	xor	al, al
	out	dx, al
	add	dx, 2
	mov	ax, VIKING_RD
	out	dx, ax
	sub	dx, 2
	jmp	short viking_waitread_1
;
viking_waitread_3:
	mov	al, 2
	out	dx, al
	add	dx, 2
	in	al, dx
	or	al, 80h
	out	dx, al
	and	al, 7Fh
	out	dx, al
	sub	dx, 2
	xor	al, al
	out	dx, al
	add	dx, 2
	mov	ax, VIKING_RD
	OUT_DX_AHAL
	sub	dx, 2
	jmp	short viking_waitread_1

viking_waitread	endp

X49EB	db	004h, 000h, 000h, 000h, 000h, 000h, 000h
RopFlags db	0
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 019h, 003h, 000h, 000h, 000h, 000h, 006h
	db	01ah, 003h, 012h, 000h, 000h, 000h, 000h, 006h
	db	019h, 003h, 000h, 000h, 000h, 000h, 000h, 004h
	db	013h, 003h, 019h, 003h, 000h, 000h, 000h, 006h
	db	012h, 019h, 003h, 000h, 000h, 000h, 000h, 006h
	db	002h, 01ah, 012h, 000h, 000h, 000h, 000h, 006h
	db	013h, 019h, 003h, 000h, 000h, 000h, 000h, 006h
	db	002h, 01ah, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 002h, 01ah, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	011h, 003h, 019h, 003h, 000h, 000h, 000h, 006h
	db	002h, 018h, 000h, 000h, 000h, 000h, 000h, 004h
	db	011h, 003h, 01ah, 000h, 000h, 000h, 000h, 006h
	db	011h, 003h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	011h, 01bh, 000h, 000h, 000h, 000h, 000h, 006h
	db	011h, 01ah, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	01bh, 011h, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 003h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 003h, 01ah, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 003h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 01bh, 000h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 01ah, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 003h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	003h, 01ah, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	003h, 000h, 000h, 000h, 000h, 000h, 000h, 000h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	01bh, 000h, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	01ah, 003h, 000h, 000h, 000h, 000h, 000h, 004h
	db	013h, 01ah, 000h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	013h, 000h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	013h, 01bh, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	013h, 003h, 01ah, 003h, 000h, 000h, 000h, 006h
	db	012h, 003h, 01ah, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	012h, 003h, 000h, 000h, 000h, 000h, 000h, 002h
	db	012h, 01bh, 000h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	012h, 01bh, 003h, 000h, 000h, 000h, 000h, 006h
	db	012h, 000h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	012h, 003h, 01ah, 003h, 000h, 000h, 000h, 006h
	db	013h, 003h, 01ah, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	013h, 003h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	013h, 01ah, 003h, 000h, 000h, 000h, 000h, 006h
	db	01ah, 000h, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	01bh, 003h, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 001h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	002h, 019h, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 003h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 01ah, 000h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 01bh, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 000h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 002h, 019h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 003h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	011h, 01ah, 000h, 000h, 000h, 000h, 000h, 006h
	db	011h, 01bh, 003h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	011h, 000h, 000h, 000h, 000h, 000h, 000h, 002h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	018h, 000h, 000h, 000h, 000h, 000h, 000h, 004h
	db	011h, 003h, 019h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 003h, 019h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	003h, 019h, 000h, 000h, 000h, 000h, 000h, 004h
	db	013h, 019h, 000h, 000h, 000h, 000h, 000h, 006h
	db	012h, 003h, 019h, 000h, 000h, 000h, 000h, 006h
	db	012h, 019h, 000h, 000h, 000h, 000h, 000h, 006h
	db	013h, 003h, 019h, 000h, 000h, 000h, 000h, 006h
	db	019h, 000h, 000h, 000h, 000h, 000h, 000h, 004h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	010h, 019h, 000h, 000h, 000h, 000h, 000h, 006h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	006h, 000h, 000h, 000h, 000h, 000h, 000h, 007h
	db	005h, 000h, 000h, 000h, 000h, 000h, 000h, 000h

mirror_byte label byte
	db	000h, 080h, 040h, 0c0h, 020h, 0a0h, 060h, 0e0h
	db	010h, 090h, 050h, 0d0h, 030h, 0b0h, 070h, 0f0h
	db	008h, 088h, 048h, 0c8h, 028h, 0a8h, 068h, 0e8h
	db	018h, 098h, 058h, 0d8h, 038h, 0b8h, 078h, 0f8h
	db	004h, 084h, 044h, 0c4h, 024h, 0a4h, 064h, 0e4h
	db	014h, 094h, 054h, 0d4h, 034h, 0b4h, 074h, 0f4h
	db	00ch, 08ch, 04ch, 0cch, 02ch, 0ach, 06ch, 0ech
	db	01ch, 09ch, 05ch, 0dch, 03ch, 0bch, 07ch, 0fch
	db	002h, 082h, 042h, 0c2h, 022h, 0a2h, 062h, 0e2h
	db	012h, 092h, 052h, 0d2h, 032h, 0b2h, 072h, 0f2h
	db	00ah, 08ah, 04ah, 0cah, 02ah, 0aah, 06ah, 0eah
	db	01ah, 09ah, 05ah, 0dah, 03ah, 0bah, 07ah, 0fah
	db	006h, 086h, 046h, 0c6h, 026h, 0a6h, 066h, 0e6h
	db	016h, 096h, 056h, 0d6h, 036h, 0b6h, 076h, 0f6h
	db	00eh, 08eh, 04eh, 0ceh, 02eh, 0aeh, 06eh, 0eeh
	db	01eh, 09eh, 05eh, 0deh, 03eh, 0beh, 07eh, 0feh
	db	001h, 081h, 041h, 0c1h, 021h, 0a1h, 061h, 0e1h
	db	011h, 091h, 051h, 0d1h, 031h, 0b1h, 071h, 0f1h
	db	009h, 089h, 049h, 0c9h, 029h, 0a9h, 069h, 0e9h
	db	019h, 099h, 059h, 0d9h, 039h, 0b9h, 079h, 0f9h
	db	005h, 085h, 045h, 0c5h, 025h, 0a5h, 065h, 0e5h
	db	015h, 095h, 055h, 0d5h, 035h, 0b5h, 075h, 0f5h
	db	00dh, 08dh, 04dh, 0cdh, 02dh, 0adh, 06dh, 0edh
	db	01dh, 09dh, 05dh, 0ddh, 03dh, 0bdh, 07dh, 0fdh
	db	003h, 083h, 043h, 0c3h, 023h, 0a3h, 063h, 0e3h
	db	013h, 093h, 053h, 0d3h, 033h, 0b3h, 073h, 0f3h
	db	00bh, 08bh, 04bh, 0cbh, 02bh, 0abh, 06bh, 0ebh
	db	01bh, 09bh, 05bh, 0dbh, 03bh, 0bbh, 07bh, 0fbh
	db	007h, 087h, 047h, 0c7h, 027h, 0a7h, 067h, 0e7h
	db	017h, 097h, 057h, 0d7h, 037h, 0b7h, 077h, 0f7h
	db	00fh, 08fh, 04fh, 0cfh, 02fh, 0afh, 06fh, 0efh
	db	01fh, 09fh, 05fh, 0dfh, 03fh, 0bfh, 07fh, 0ffh
mirror_invert label byte
	db	0ffh, 07fh, 0bfh, 03fh, 0dfh, 05fh, 09fh, 01fh
	db	0efh, 06fh, 0afh, 02fh, 0cfh, 04fh, 08fh, 00fh
	db	0f7h, 077h, 0b7h, 037h, 0d7h, 057h, 097h, 017h
	db	0e7h, 067h, 0a7h, 027h, 0c7h, 047h, 087h, 007h
	db	0fbh, 07bh, 0bbh, 03bh, 0dbh, 05bh, 09bh, 01bh
	db	0ebh, 06bh, 0abh, 02bh, 0cbh, 04bh, 08bh, 00bh
	db	0f3h, 073h, 0b3h, 033h, 0d3h, 053h, 093h, 013h
	db	0e3h, 063h, 0a3h, 023h, 0c3h, 043h, 083h, 003h
	db	0fdh, 07dh, 0bdh, 03dh, 0ddh, 05dh, 09dh, 01dh
	db	0edh, 06dh, 0adh, 02dh, 0cdh, 04dh, 08dh, 00dh
	db	0f5h, 075h, 0b5h, 035h, 0d5h, 055h, 095h, 015h
	db	0e5h, 065h, 0a5h, 025h, 0c5h, 045h, 085h, 005h
	db	0f9h, 079h, 0b9h, 039h, 0d9h, 059h, 099h, 019h
	db	0e9h, 069h, 0a9h, 029h, 0c9h, 049h, 089h, 009h
	db	0f1h, 071h, 0b1h, 031h, 0d1h, 051h, 091h, 011h
	db	0e1h, 061h, 0a1h, 021h, 0c1h, 041h, 081h, 001h
	db	0feh, 07eh, 0beh, 03eh, 0deh, 05eh, 09eh, 01eh
	db	0eeh, 06eh, 0aeh, 02eh, 0ceh, 04eh, 08eh, 00eh
	db	0f6h, 076h, 0b6h, 036h, 0d6h, 056h, 096h, 016h
	db	0e6h, 066h, 0a6h, 026h, 0c6h, 046h, 086h, 006h
	db	0fah, 07ah, 0bah, 03ah, 0dah, 05ah, 09ah, 01ah
	db	0eah, 06ah, 0aah, 02ah, 0cah, 04ah, 08ah, 00ah
	db	0f2h, 072h, 0b2h, 032h, 0d2h, 052h, 092h, 012h
	db	0e2h, 062h, 0a2h, 022h, 0c2h, 042h, 082h, 002h
	db	0fch, 07ch, 0bch, 03ch, 0dch, 05ch, 09ch, 01ch
	db	0ech, 06ch, 0ach, 02ch, 0cch, 04ch, 08ch, 00ch
	db	0f4h, 074h, 0b4h, 034h, 0d4h, 054h, 094h, 014h
	db	0e4h, 064h, 0a4h, 024h, 0c4h, 044h, 084h, 004h
	db	0f8h, 078h, 0b8h, 038h, 0d8h, 058h, 098h, 018h
	db	0e8h, 068h, 0a8h, 028h, 0c8h, 048h, 088h, 008h
	db	0f0h, 070h, 0b0h, 030h, 0d0h, 050h, 090h, 010h
	db	0e0h, 060h, 0a0h, 020h, 0c0h, 040h, 080h, 000h

X53EB	proc	near
	add	cx, 2
	mov	bx, ds
	mov	ds, cs:_cstods
	mov	rdscr_flags, al
	call	X54C9	
	mov	rdscr_rwp0, bx
	mov	rdscr_rwp1, ax
	mov	bx, cx
	shr	bx, 1
	inc	bx
	mov	rdscr_count, bx
	test	rdscr_flags, 1
	jz	X543E
	inc	rdscr_count
	mov	bx, cx
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	and	rdscr_rwp1, 0F800h
	and	ax, 7FFh
	sub	ax, bx
	jc	X542F
	or	rdscr_rwp1, ax
X542F:	mov	ax, si
	and	ax, 0FFh
	sub	al, cl
	jnc	X5440
	mov	ax, 0
	jmp	X5440

X543E:	mov	ax, si
X5440:	and	ax, 0FEh
	mov	bx, offset rdscr_buf
	inc	bx
;	and	bx, wptr 0FFFEh	;Word-align
	dw	0E381h
	dw	0FFFEh
	add	ax, bx
	mov	rdscr_bufaddr, ax
	and	si, 0FFh
	add	si, bx
	ret

X53EB	endp

X5457	proc	near
	add	cx, 2
	mov	bx, ds
	mov	ds, cs:_cstods
	assumes ds,Data
	mov	wrscr_flags, al
	call	X54C9
	mov	wrscr_rwp0, bx
	mov	wrscr_rwp1, ax
	mov	bx, cx
	shr	bx, 1
	inc	bx
	mov	wrscr_count, bx
	test	wrscr_flags, 1
	jz	X54AA
	inc	wrscr_count
	mov	bx, cx
	shl	bx, 1
	shl	bx, 1
	shl	bx, 1
	and	wrscr_rwp1, 0F800h
	and	ax, 7FFh
	sub	ax, bx
	jc	X549B
	or	wrscr_rwp1, ax
X549B:	mov	ax, si
	and	ax, 0FFh
	sub	al, cl
	jnc	X54AC
	mov	ax, 0
	jmp	X54AC
;
X54AA:	mov	ax, si
X54AC:	and	ax, 0FEh
	mov	bx, offset wrscr_buf
	inc	bx
;	and	bx, wptr 0FFFEh
	dw	0E381h
	dw	0FFFEh
	add	ax, bx
	mov	wrscr_bufaddr, ax
	and	si, 0FFh
	add	si, bx
	mov	W01BA, 0
	ret
X5457	endp

X54C9	proc	near
	mov	ax, si
	rol	ax, 1
	rol	ax, 1
	rol	ax, 1
	mov	bh, al
	and	bh, 7
	shl	bl, 1
	shl	bl, 1
	shl	bl, 1
	or	bl, bh
	xor	bh, bh
	and	ax, 0FFF8h
	ret
X54C9	endp

X54E4	proc	far
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	pushf
	cld
	mov	ax, cs:_cstods
	mov	es, ax
	mov	ds, ax
	mov	di, rdscr_bufaddr
	mov	bx, offset mirror_byte
	mov	cx, rdscr_count
	mov	si, VIKING_RD
	mov	dx, cs:io_base
	add	dx, 2
	call	viking_flush
	test	cs:bus_width, 1
	jz	X554B
	WPR16	VIKING_RWP1, rdscr_rwp1
	WPR16	VIKING_RWP0, rdscr_rwp0
	mov	ax, si
	out	dx, ax	;Send 'read' command
X552A:	sub	dx, 2
X552D:	in	al, dx
	test	al, 4	;Wait for result
	jz	X552D
	add	dx, 2
	mov	ax, si
	out	dx, ax
	in	ax, dx
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	stosw
	loop	X552A
	call	viking_waitread
	in	ax, dx
	jmp	X5599
;
X554B:	
	WPR8	VIKING_RWP1, rdscr_rwp1
	WPR8	VIKING_RWP0, rdscr_rwp0
	xchg	cx, si
	OUT_DX_CHCL
X5577:	sub	dx, 2
X557A:	in	al, dx
	test	al, 4	;Wait for result
	jz	X557A
	add	dx, 2
	OUT_DX_CHCL
	in	al, dx
	xlat	byte ptr cs:[bx]
	mov	ah, al
	in	al, dx
	xlat	byte ptr cs:[bx]
	stosw
	dec	si
	jnz	X5577
	call	viking_waitread
	in	al, dx
	in	al, dx
X5599:	test	rdscr_flags, 2
	jnz	X55AE
	add	rdscr_rwp1, 800h
	adc	rdscr_rwp0, 0
	jmp	X55B9
;
X55AE:	sub	rdscr_rwp1, 800h
	sbb	rdscr_rwp0, 0
X55B9:	POPFF
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	retf

X54E4	endp

X55C9	proc	far
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	pushf
	cld
	mov	ax, cs:_cstods
	mov	ds, ax
	mov	es, ax
	mov	dx, cs:io_base
	add	dx, 2
	call	viking_flush
	mov	bx, offset mirror_byte
	call	viking_setrwp
	cmp	W01BA, 0
	jnz	X55F6
	jmp	X5676

X55F6:	test	cs:bus_width, 1
	jz	X5623
	mov	ax, VIKING_DWT
	out	dx, ax
	mov	ax, cx
	dec	ax
	out	dx, ax
	xor	ax, ax
	out	dx, ax
X5609:	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	X5609
	lodsw
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	out	dx, ax
	loop	X5609
	jmp	X5650
;
X5623:	mov	ax, VIKING_DWT
	OUT_DX_AHAL
	dec	cx
	OUT_DX_CHCL
	inc	cx
	xor	al, al
	out	dx, al	
	out	dx, al	
X5638:	sub	dx, 2
	in	al, dx
	add	dx, 2
	rcr	al, 1
	jnc	X5638
	lodsw
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	mov	al, ah
	xlat	byte ptr cs:[bx]
	out	dx, al
	loop	X5638
X5650:	call	viking_flush
	test	wrscr_flags, 2
	jnz	X5668
	add	wrscr_rwp1, 800h
	adc	wrscr_rwp0, 0
	jmp	X5673
;
X5668:	sub	wrscr_rwp1, 800h
	sbb	wrscr_rwp0, 0
X5673:	call	viking_setrwp
X5676:	mov	di, si
	mov	si, VIKING_RD
	test	cs:bus_width, 1
	jz	X56A7
	mov	ax, si
	out	dx, ax
X5686:	sub	dx, 2
X5689:	in	al, dx
	test	al, 4
	jz	X5689
	add	dx, 2
	mov	ax, si
	out	dx, ax
	in	ax, dx
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	xlat	byte ptr cs:[bx]
	xchg	al, ah
	stosw
	loop	X5686
	call	viking_waitread
	in	ax, dx
	jmp	X56D1
;
X56A7:	xchg	cx, si
	OUT_DX_CHCL
X56AF:	sub	dx, 2
X56B2:	in	al, dx
	test	al, 4
	jz	X56B2
	add	dx, 2
	OUT_DX_CHCL
	in	al, dx
	xlat	byte ptr cs:[bx]
	mov	ah, al
	in	al, dx
	xlat	byte ptr cs:[bx]
	stosw
	dec	si
	jnz	X56AF
	call	viking_waitread
	in	al, dx
	in	al, dx
X56D1:	inc	W01BA	
	POPFF
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	retf

X55C9	endp

viking_setrwp	proc	near
	mov	si, wrscr_bufaddr
	mov	cx, wrscr_count
	call	viking_flush
	test	cs:bus_width, 1
	jz	X570B
	WPR16	VIKING_RWP1, wrscr_rwp1
	WPR16	VIKING_RWP0, wrscr_rwp0
	jmp	viking_flush
;
X570B:	WPR8	VIKING_RWP1, wrscr_rwp1
	WPR8	VIKING_RWP0, wrscr_rwp0
	jmp	viking_flush

viking_setrwp	endp
	
sEnd	Code

	end

