        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.ASM
;
;   This module contains functions and definitions specific to
;   the IBM CGA Monochrome Display Driver.
;
; Created: 22-Feb-1987
; Author:  **** ***** [*****]
;
; Copyright (c) 1984-1987 Microsoft Corporation
;
; Exported Functions:	none
;
; Public Functions:	physical_enable
;			physical_disable
;
; Public Data:
;		PHYS_DEVICE_SIZE		info_table_base
;		BW_THRESHOLD			physical_device
;		COLOR_FORMAT			interlace_adjust
;		SCREEN_W_BYTES			rot_bit_tbl
;		SCREEN_WIDTH			color_table
;		SCREEN_HEIGHT			ScreenSelector
;		COLOR_TBL_SIZE			BlueMoonSeg_colo_table
;		Y_SHIFT_COUNT			PixelSeg_interlace_adjust
;		EVEN_SCAN_INC			LineSeg_interlace_adjust
;		ODD_SCAN_INC			ScanlineSeg_interlace_adjust
;		TOGGLE_EVEN_ODD 		BlueMoonSeg_interlace_adjust
;		EVEN_SCAN_INC_D
;		ODD_SCAN_INC_D
;		TOGGLE_EVEN_ODD_D
;		EVEN_INC_LESS_ODD_INC
;
;		HYPOTENUSE
;		Y_MAJOR_DIST
;		X_MAJOR_DIST
;		Y_MINOR_DIST
;		X_MINOR_DIST
;		MAX_STYLE_ERR
;
;		 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
;		 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
;		 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
;		 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
;		D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
;		D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
;		D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
;		D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
;		CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
;		CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
;		DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
;		DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;


incDevice = 1				;Include control for gdidefs.inc

	.xlist
	include cmacros.inc
	include	cursor.inc
	include gdidefs.inc
	include display.inc
	include macros.mac
	include vikingi.inc
	.list


	public	PHYS_DEVICE_SIZE	;Number of bytes in physical device
	public	BW_THRESHOLD		;Black/white threshold
	public	COLOR_FORMAT		;Color format
	public	SCREEN_W_BYTES		;Screen width in bytes
	public	SCREEN_WIDTH		;Screen width in pixels
	public	SCREEN_HEIGHT		;Screen height in scans
	public	COLOR_TBL_SIZE		;Number of entries in color table
	public	ScreenSelector		;Segment of Regen RAM

	public	physical_enable 	;Enable routine
	public	physical_disable	;Disable

	public	physical_device 	;Physical device descriptor
	public	info_table_base 	;GDIInfo table base address

;	public	Y_SHIFT_COUNT
	public	ODD_SCAN_INC
	public	EVEN_SCAN_INC
	public	TOGGLE_EVEN_ODD
	public	ODD_SCAN_INC_D
	public	EVEN_SCAN_INC_D
	public	TOGGLE_EVEN_ODD_D
	public	EVEN_INC_LESS_ODD_INC

	public	HYPOTENUSE
	public	Y_MAJOR_DIST
	public	X_MAJOR_DIST
	public	Y_MINOR_DIST
	public	X_MINOR_DIST
	public	MAX_STYLE_ERR

	public	rot_bit_tbl

	public	 H_HATCH_BR_0, H_HATCH_BR_1, H_HATCH_BR_2, H_HATCH_BR_3
	public	 H_HATCH_BR_4, H_HATCH_BR_5, H_HATCH_BR_6, H_HATCH_BR_7
	public	 V_HATCH_BR_0, V_HATCH_BR_1, V_HATCH_BR_2, V_HATCH_BR_3
	public	 V_HATCH_BR_4, V_HATCH_BR_5, V_HATCH_BR_6, V_HATCH_BR_7
	public	D1_HATCH_BR_0,D1_HATCH_BR_1,D1_HATCH_BR_2,D1_HATCH_BR_3
	public	D1_HATCH_BR_4,D1_HATCH_BR_5,D1_HATCH_BR_6,D1_HATCH_BR_7
	public	D2_HATCH_BR_0,D2_HATCH_BR_1,D2_HATCH_BR_2,D2_HATCH_BR_3
	public	D2_HATCH_BR_4,D2_HATCH_BR_5,D2_HATCH_BR_6,D2_HATCH_BR_7
	public	CR_HATCH_BR_0,CR_HATCH_BR_1,CR_HATCH_BR_2,CR_HATCH_BR_3
	public	CR_HATCH_BR_4,CR_HATCH_BR_5,CR_HATCH_BR_6,CR_HATCH_BR_7
	public	DC_HATCH_BR_0,DC_HATCH_BR_1,DC_HATCH_BR_2,DC_HATCH_BR_3
	public	DC_HATCH_BR_4,DC_HATCH_BR_5,DC_HATCH_BR_6,DC_HATCH_BR_7






;-----------------------------------------------------------------------;
;	The hatched brush pattern definitions
;-----------------------------------------------------------------------;

H_HATCH_BR_0	equ	11111111b	;Horizontal Hatched brush
H_HATCH_BR_1	equ	11111111b
H_HATCH_BR_2	equ	11111111b
H_HATCH_BR_3	equ	11111111b
H_HATCH_BR_4	equ	00000000b
H_HATCH_BR_5	equ	11111111b
H_HATCH_BR_6	equ	11111111b
H_HATCH_BR_7	equ	11111111b

V_HATCH_BR_0	equ	11110111b	;Vertical Hatched brush
V_HATCH_BR_1	equ	11110111b
V_HATCH_BR_2	equ	11110111b
V_HATCH_BR_3	equ	11110111b
V_HATCH_BR_4	equ	11110111b
V_HATCH_BR_5	equ	11110111b
V_HATCH_BR_6	equ	11110111b
V_HATCH_BR_7	equ	11110111b

D1_HATCH_BR_0	equ	01111111b	;\ diagonal brush
D1_HATCH_BR_1	equ	10111111b
D1_HATCH_BR_2	equ	11011111b
D1_HATCH_BR_3	equ	11101111b
D1_HATCH_BR_4	equ	11110111b
D1_HATCH_BR_5	equ	11111011b
D1_HATCH_BR_6	equ	11111101b
D1_HATCH_BR_7	equ	11111110b

D2_HATCH_BR_0	equ	11111110b	;/ diagonal hatched brush
D2_HATCH_BR_1	equ	11111101b
D2_HATCH_BR_2	equ	11111011b
D2_HATCH_BR_3	equ	11110111b
D2_HATCH_BR_4	equ	11101111b
D2_HATCH_BR_5	equ	11011111b
D2_HATCH_BR_6	equ	10111111b
D2_HATCH_BR_7	equ	01111111b

CR_HATCH_BR_0	equ	11110111b	;+ hatched brush
CR_HATCH_BR_1	equ	11110111b
CR_HATCH_BR_2	equ	11110111b
CR_HATCH_BR_3	equ	11110111b
CR_HATCH_BR_4	equ	00000000b
CR_HATCH_BR_5	equ	11110111b
CR_HATCH_BR_6	equ	11110111b
CR_HATCH_BR_7	equ	11110111b

DC_HATCH_BR_0	equ	01111110b	;X hatched brush
DC_HATCH_BR_1	equ	10111101b
DC_HATCH_BR_2	equ	11011011b
DC_HATCH_BR_3	equ	11100111b
DC_HATCH_BR_4	equ	11100111b
DC_HATCH_BR_5	equ	11011011b
DC_HATCH_BR_6	equ	10111101b
DC_HATCH_BR_7	equ	01111110b




;-----------------------------------------------------------------------;
;	Line style definitions for the EGA Card
;
;	Since the style update code in the line DDA checks for a sign,
;	the values chosen for distances, HYPOTENUSE, and MAX_STYLE_ERR
;	must not be bigger than 127+min(X_MAJOR_DIST,Y_MAJOR_DIST).  If
;	this condition is met, then the sign bit will always be cleared
;	on the first subtraction after every add-back.
;-----------------------------------------------------------------------;


HYPOTENUSE	=	65		;Distance moving X and Y
Y_MAJOR_DIST	=	47		;Distance moving Y only
X_MAJOR_DIST	=	45		;Distance moving X only
Y_MINOR_DIST	=	HYPOTENUSE-X_MAJOR_DIST
X_MINOR_DIST	=	HYPOTENUSE-Y_MAJOR_DIST
MAX_STYLE_ERR	=	HYPOTENUSE*2	;Max error before updating
					;  rotating bit mask



;-----------------------------------------------------------------------;
;	The black/white threshold is used to determine the split
;	between black and white when summing an RGB Triplet
;-----------------------------------------------------------------------;


BW_THRESHOLD	equ	(3*0FFh)/2
page

;	The odd row increment is the value used when incrementing from
;	an odd scan line to an even scan line, with an increasing Y.
;
;	The even row increment is the value used when incrementing from
;	an even scan line to an odd scan line, with an increasing Y.
;
;	The even-odd toggle value is the XOR mask used to toggle the
;	odd row increment to the next even row for an increasing Y.


EVEN_SCAN_INC		equ	02000h
ODD_SCAN_INC		equ	0E050h
TOGGLE_EVEN_ODD		equ	0C050h
EVEN_INC_LESS_ODD_INC	equ	EVEN_SCAN_INC-ODD_SCAN_INC


;	Same as above, but going down.

EVEN_SCAN_INC_D		equ	01FB0h
ODD_SCAN_INC_D		equ	0E000h
TOGGLE_EVEN_ODD_D	equ	0FFB0h

page

sBegin	Code
assumes cs,Code


SCREEN_W_BYTES	equ	SCAN_BYTES*1	;Screen width in bytes
COLOR_FORMAT	equ	0101h


;-----------------------------------------------------------------------;
;	PhysDeviceSize is the number of bytes that the enable routine
;	is to copy into the passed PDevice block before calling the
;	physical_enable routine.  For this driver, the length is the
;	size of the bitmap structure.
;-----------------------------------------------------------------------;

PHYS_DEVICE_SIZE equ	size BITMAP



;-----------------------------------------------------------------------;
;	Allocate the physical device block for the EGA Card.
;	For this driver, physical devices will be in the same format
;	as a normal bitmap descriptor.	This is very convienient since
;	it simplifies the structures that the code must work with.
;
;	The bmWidthPlanes field will be set to zero to simplify some
;	of the three plane code.  By setting it to zero, it can be
;	added to a memory bitmap pointer without changing the pointer.
;	This allows the code to add this in regardless of the type of
;	the device.
;
;	The actual physical block will have some extra bytes stuffed on
;	the end (IntPhysDevice structure), but only the following is static
;-----------------------------------------------------------------------;

ScreenSelector	equ	0E000H


;	The following constants keep the parameter list to BITMAP within
;	view on an editing display 80 chars wide.

SCRSEL		equ	ScreenSelector
P		equ	 COLOR_FORMAT AND 000FFh	;# color planes
B		equ	(COLOR_FORMAT AND 0FF00h) SHR 8	;# bits per pixel
H		equ	SCREEN_HEIGHT			;new display height
W		equ	SCREEN_WIDTH			;display width, pels
WB		equ	SCREEN_W_BYTES			;display width, bytes

physical_device BITMAP <SCRSEL,W,H,WB,P,B,0E0000000H,03C000h,0,0,0,0,0,0>

;-----------------------------------------------------------------------;
;	The GDIInfo data Structure.  The specifics of the Hercules
;	mode are passed to GDI via this structure.
;-----------------------------------------------------------------------;


info_table_base label byte


	dw	100h			;Version = 1.00
	errnz	dpVersion

	dw	DT_RASDISPLAY		;Device classification
	errnz	dpTechnology-dpVersion-2

	dw	350			;Horizontal size in millimeters
	errnz	dpHorzSize-dpTechnology-2

	dw	270			;Vertical size in millimeters
	errnz	dpVertSize-dpHorzSize-2

	dw	SCREEN_WIDTH		;Horizontal width in pixels
	errnz	dpHorzRes-dpVertSize-2

	dw	SCREEN_HEIGHT		;Vertical width in pixels
	errnz	dpVertRes-dpHorzRes-2

	dw	1			;Number of bits per pixel
	errnz	dpBitsPixel-dpVertRes-2

	dw	1			;Number of planes
	errnz	dpPlanes-dpBitsPixel-2

	dw	65+6+6			;Number of brushes the device has
	errnz	dpNumBrushes-dpPlanes-2 ;  (Show lots of brushes)

	dw	10			;Number of pens the device has
	errnz	dpNumPens-dpNumBrushes-2;  (2 colors * 5 styles)

	dw	0			;Reserved

	dw	0			;Number of fonts the device has
	errnz	dpNumFonts-dpNumPens-4

	dw	2			;Number of colors in color table
	errnz	dpNumColors-dpNumFonts-2

	dw	size int_phys_device	;Size required for device descriptor
	errnz	dpDEVICEsize-dpNumColors-2

	dw	CC_NONE 		;Curves capabilities
	errnz	dpCurves-dpDEVICEsize-2

	dw	LC_POLYLINE+LC_STYLED	;Line capabilities
	errnz	dpLines-dpCurves-2

	dw	PC_SCANLINE		;Polygonal capabilities
	errnz	dpPolygonals-dpLines-2

	dw	TC_CP_STROKE+TC_RA_ABLE ;Text capabilities
	errnz	dpText-dpPolygonals-2

	dw	CP_NONE 		;Clipping capabilities
	errnz	dpClip-dpText-2

					;BitBlt capabilities
;;;	dw	RC_BITBLT+RC_BITMAP64+RC_GDI20_OUTPUT+RC_SAVEBITMAP
	dw	RC_BITBLT		;WIN1 can only do RC_BITBLT
	errnz	dpRaster-dpClip-2

	dw	X_MAJOR_DIST		;Distance moving X only
	errnz	dpAspectX-dpRaster-2

	dw	Y_MAJOR_DIST		;Distance moving Y only
	errnz	dpAspectY-dpAspectX-2

	dw	HYPOTENUSE		;Distance moving X and Y
	errnz	dpAspectXY-dpAspectY-2

	dw	MAX_STYLE_ERR		;Length of segment for line styles
	errnz	dpStyleLen-dpAspectXY-2


	errnz	dpMLoWin-dpStyleLen-2	;Metric  Lo res WinX,WinY,VptX,VptY
	dw	3500			;  HorzSize * 10
	dw	2400			;  VertSize * 10
	dw	1280			;  HorizRes
	dw	-960			;  -VertRes


	errnz	dpMHiWin-dpMLoWin-8	;Metric  Hi res WinX,WinY,VptX,VptY
	dw	35000			;  HorzSize * 100
	dw	24000			;  VertSize * 100
	dw	1280			;  HorizRes
	dw	-960			;  -VertRes


	errnz	dpELoWin-dpMHiWin-8	;English Lo res WinX,WinY,VptX,VptY
	dw	273			;  HorzSize * 1000 scaled(/225)
	dw	141			;  VertSize * 1000 scaled(/200)
	dw	254			;  HorizRes * 254  scaled(/225)
	dw	-127			;  -VertRes * 254  scaled(/200)


	errnz	dpEHiWin-dpELoWin-8	;English Hi res WinX,WinY,VptX,VptY
	dw	2734			;  HorzSize * 10000 scaled(/225)
	dw	1406			;  VertSize * 10000 scaled(/400)
	dw	254			;  HorizRes * 254   scaled(/225)
	dw	-127			;  -VertRes * 254   scaled(/400)


	errnz	dpTwpWin-dpEHiWin-8	;Twips		WinX,WinY,VptX,VptY
	dw	3938			;  HorzSize * 14400 scaled(/1000)
	dw	2025			;  VertSize * 14400 scaled(/400)
	dw	254			;  HorizRes * 254   scaled(/1000)
	dw	-127			;  -VertRes * 254   scaled(/400)


	dw	93			;Logical Pixels/inch in X
	errnz	dpLogPixelsX-dpTwpWin-8

	dw	89			;Logical Pixels/inch in Y
	errnz	dpLogPixelsY-dpLogPixelsX-2

	dw	DC_IgnoreDFNP		;dpDCManage
	errnz	dpDCManage-dpLogPixelsY-2

	dw	0			;Reserved fields
	dw	0
	dw	0
	dw	0
	dw	0


	errnz	<(offset $)-(offset info_table_base)-(size GDIINFO)>

;;; WIN1 -- was in pixel.asm in win2
rot_bit_tbl     label   byte
                db      10000000b       ;Table to map bit index into
                db      01000000b       ;  a bit mask 
                db      00100000b 
                db      00010000b
                db      00001000b 
                db      00000100b
                db      00000010b
                db      00000001b
page
;	Constants and macro for changing the screen mode of the IBM/PC display

SET_MODE	equ	0
READ_MODE	equ	15
TEXT_MODE	equ	3
GRAPHICS_MODE	equ	6

video_io	macro	func,arg
	mov	ah,func
	ifnb	<arg>
		mov	al,arg
	endif
	int	10h
endm
page

;---------------------------Public-Routine------------------------------;
; physical_enable
;
;   EGA 640x350 graphics mode is enabled.
;
; Entry:
;	ES:DI --> ipd_format in our pDevice
;	DS:    =  Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	AX = 0
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	externB	option_t
	externB	bus_width
	externW	io_base
	externW	_cstods

	assumes ds,Data
	assumes es,nothing

physical_enable proc near

	video_io READ_MODE		;Get current mode
	stosb				;and save it

	video_io SET_MODE, GRAPHICS_MODE ;Set CGA mono graphics

	push	ds
	mov	ds, _cstods
	assumes ds, Data
	call	load_config		;Returns DX = I/O base
	add	dx, 4
	mov	es, _cstods
	assumes es, Data
	pop	ds
	in	al, dx
	mov	es:X0000, al
	mov	ch, 10h
	mov	al, 8
	test	cs:option_t, 1
	jnz	physical_enable_10
	mov	al, 68h
physical_enable_10:
	or	al, ch
	out	dx, al
	mov	bx, 1000
physical_enable_20:
	dec	bx
	jnz	physical_enable_20
	or	al, 1
	out	dx, al
	sub	dx, 4
	mov	al, 2
	out	dx, al
	add	dx, 2
	mov	ax, 55AAh	;See if we can access the card with
	out	dx, ax		;16-bit I/O instructions
	in	ax, dx
	add	dx, 2
	cmp	ax, 55AAh
	jz	physical_enable_30
	mov	ch, 0
physical_enable_30:
	mov	al, 8
	test	cs:option_t, 1
	jnz	physical_enable_40
	mov	al, 68h
physical_enable_40:
	or	al, ch
	out	dx, al
	mov	bx, 1000
physical_enable_50:
	dec	bx
	jnz	physical_enable_50
	or	al, 1
	out	dx, al
	mov	bx, offset bus_width
	mov	byte ptr cs:[bx],0
	test	ch, 0FFh
	jz	physical_enable_60
	mov	byte ptr cs:[bx],1
physical_enable_60:
	sub	dx, 2
	mov	bx, cs
	mov	ds, bx
	lea	si, viking_init
physical_enable_70:
	cmp	word ptr [si], -1
	jz	physical_enable_80
	call	viking_setreg
	add	si, 4
	jmp	short physical_enable_70
;
physical_enable_80:
	add	si, 2
	cmp	word ptr [si], -1
	jz	physical_enable_90
	call	viking_w_fifo
physical_enable_90:
	sub	dx, 2
physical_enable_100:
	in	al, dx
	and	al, 23h
	cmp	al, 23h
	jnz	physical_enable_100
	add	dx, 4
	mov	al, 49h
	test	cs:option_t, 1
	jnz	physical_enable_110
	mov	al, 49h		;Pointless!	
physical_enable_110:
	or	al, ch
	out	dx, al
	sub	dx, 2
	mov	bx, 8
	test	ch, 0FFh
	jnz	physical_enable_120
	mov	bx, 3
physical_enable_120:
	xor	ax, ax 			;Quite a big intermission
physical_enable_130:
	dec	ax
	jnz	physical_enable_130
	dec	bx
	jnz	physical_enable_120
	mov	ax, 40h
	mov	es, ax
	test	byte ptr es:17h, 10h	;Scroll lock active?
	jz	physical_enable_150
	lea	si, X0371
	call	viking_w_fifo
physical_enable_140:
	test	byte ptr es:17h, 10h	;Scroll lock active?
	jnz	physical_enable_140
	lea	si, X0341
	call	viking_w_fifo
physical_enable_150:
	mov	al, 1
	ret

physical_enable endp

viking_init	label	word
	dw	2, 8000h	; Command/control - set Abort
	dw	4, 0		; Operation mode to 0
	dw	6, 0C003h	; Display control
	dw	82h, 3302h      ; Hsync
	dw	84h, 2049       ; Horizontal display
	dw	86h, 1000       ; Vsync
	dw	88h, 9475       ; Vertical display
	dw	8Ah, 960        ; Split screen width
	dw	8Ch, 0
	dw	8Eh, 0
	dw	90h, 0AA55h     ; Blink control
	dw	92h, 0          ; Horizontal window display
	dw	94h, 0          ; Vertical window display
	dw	96h, 0
	dw	98h, 330Bh      ; Graphic cursor
	dw	9Ah, 25h
	dw	9Ch, 3E8h
	dw	0C0h, 0F00h     ; Upper area
	dw	0C2h, 80h
	dw	0C4h, 0
	dw	0C6h, 0
	dw	0C8h, 0F00h          ; Base area
	dw	0CAh, 8080h
	dw	0CCh, 0
	dw	0CEh, 0
	dw	0D0h, 0F00h          ; Lower area
	dw	0D2h, 80h
	dw	0D4h, 0
	dw	0D6h, 0
	dw	0D8h, 0F00h          ; Window area
	dw	0DAh, 80h
	dw	0DCh, 0
	dw	0DEh, 0
	dw	0E8h, 8801h          ; Cursor definition
	dw	0EAh, 0              ; Zoom factor
	dw	2, 0                 ; Command/control - bring it out of ABORT
	dw	4, 0C048h            ; Operation mode
	dw	0E0h, 0              ; Block cursor
	dw	0E2h, 0
	dw	0E4h, 0
	dw	0E6h, 0
	dw	0CAh, 80h
	dw	-1
;
; Initial commands to send to the FIFO
;
	dw	2, VIKING_WPR + VIKING_MASK, 0FFFFh
	dw	2, VIKING_WPR + VIKING_PRC0, 0
	dw	2, VIKING_WPR + VIKING_PRC1, 0
	dw	2, VIKING_WPR + VIKING_PRC2, 0F0F0h
	dw	2, VIKING_WPR + VIKING_ADR0, 0	;xmin = 0
	dw	2, VIKING_WPR + VIKING_ADR1, 0	;ymin = 0
	dw	2, VIKING_WPR + VIKING_ADR2, SCREEN_WIDTH-1
	dw	2, VIKING_WPR + VIKING_ADR3, SCREEN_HEIGHT-1
	dw	2, VIKING_WPR + VIKING_RWP0, 4000h
	dw	2, VIKING_WPR + VIKING_RWP1, 0
	dw	12h, 1800h, 10h, 16 dup (-1)
	dw	3, 400h, 401Dh, 0F800h
X0341	dw	2, VIKING_WPR + VIKING_RWP0, 4000h
	dw	2, VIKING_WPR + VIKING_RWP1, 0
	dw	4, 5800h, 0, 7Fh, 3FFh
	dw	2, VIKING_WPR + VIKING_CL0, 0
	dw	2, VIKING_WPR + VIKING_CL1, 0FFFFh
	dw	2, VIKING_WPR + VIKING_CCMP, 0
	dw	2, VIKING_WPR + VIKING_EDG, -1
	dw	-1
X0371	dw	12h, 1800h, 10h, 3E1Eh, 222h, 222h, 1E1Eh, 222h, 222h, 3E1Eh
	dw		0, 1C3Eh, 2208h, 2208h, 3E08h, 2208h, 2208h, 2208h, 0
	dw	2, VIKING_WPR + VIKING_PRC0, 0
	dw	2, VIKING_WPR + VIKING_PRC1, 0
	dw	2, VIKING_WPR + VIKING_PRC2, 77F3h
	dw	3, VIKING_AMOVE, 512, 512
	dw	3, 0C400h, 03Fh, 0FFC1h
	dw	2, 805h, 8000h
	dw	2, 806h, 8000h
	dw	2, 807h, 0F7F3h
	dw	3, 8000h, 240h, 200h
	dw	3, 0C400h, 3Fh, 0FFC1h
	dw	18, 1800h, 10h, 800h, 0C00h, 800h, 800h, 800h, 800h, 3E00h, 0
	dw		800h, 0C00h, 800h, 800h, 800h, 800h, 3E08h, 0
	dw	2, 805h, 0h
	dw	2, 806h, 0h
	dw	2, 807h, 77F3h
	dw	3, VIKING_AMOVE, 640, 512
	dw	3, 0C400h, 3Fh, 0FFC1h
	dw	2, 805h, 8000h
	dw	2, 806h, 8000h
	dw	2, 807h, 0F7F3h
	dw	3, 8000h, 2C0h, 200h
	dw	3, 0C400h, 3Fh, 0FFC1h
	dw	-1
	
page

;---------------------------Public-Routine------------------------------;
; physical_disable
;
;   EGA 640x350 graphics mode is exited.  The previous mode of the
;   adapter is restored.
;
; Entry:
;	DS:SI --> int_phys_device
;	ES:    =  Data
; Returns:
;	AX = non-zero to show success
; Error Returns:
;	None
; Registers Preserved:
;	BP
; Registers Destroyed:
;	AX,BX,CX,DX,SI,DI,ES,DS,FLAGS
; Calls:
;	INT 10h
; History:
;	Tue 18-Aug-1987 18:09:00 -by-  **** ***** [*****]
;
;	Thu 26-Feb-1987 13:45:58 -by-  **** ***** [*****]
;	Created.
;-----------------------------------------------------------------------;


;------------------------------Pseudo-Code------------------------------;
; {
; }
;-----------------------------------------------------------------------;

	assumes ds,nothing
	assumes es,Data

physical_disable proc near

	mov	al,[si].ipd_format	
	mov	ah,0		
	int	10h
	mov	dx, cs:io_base
	add	dx, 2
	mov	ch, cs:bus_width
	mov	bx, cs
	mov	ds, bx
	lea	si, X0489
	cmp	word ptr [si], -1
	jz	physical_disable_10
	call	viking_w_fifo
physical_disable_10:
	add	dx, 2
	mov	al, 10h
	test	ch, 0FFh
	jnz	physical_disable_20
	xor	al, al
physical_disable_20:
	mov	ah, 29h
	test	cs:option_t, 1
	jnz	physical_disable_30
	mov	ah, 29h		;Pointless
physical_disable_30:
	or	al, ah
	out	dx, al
	mov	al, 1
	ret
	
physical_disable endp

X0489	dw	2, 80Ch, 4000h
	dw	2, 80Dh, 0
	dw	4, 5800h, 0, 7Fh, 3FFh
	dw	2, 800h, 0
	dw	2, 801h, -1
	dw	2, 802h, 0
	dw	2, 803h, -1
	dw	-1

page

load_config	proc	near
	mov	dx, cs:io_base
	or	dx, dx
	jz	load_config_1
	ret
;
load_config_1:
	mov	ah, 19h	;Get current drive
	int	21h
	mov	bx, offset config_filename
	add	al, 'A'
	mov	[bx], al
	mov	dx, bx
	mov	ah, 3Dh	;Open config file
	mov	al, 0
	int	21h
	jnc	load_config_2
load_config_default:
	mov	dx, 3E8h
	mov	cs:io_base, dx
	mov	cs:option_t, 1
	ret
;
load_config_2:
	mov	dx, ax
	xor	cx, cx
	mov	ah, 1
load_config_3:
	call	fgetc
	cmp	al, 0FFh	;End of file?
	jnz	load_config_4
	jmp	load_config_eof
;
load_config_4:
	cmp	al, 'P'
	jz	load_config_p
	cmp	al, 'p'
	jz	load_config_p
	cmp	al, 'T'
	jz	load_config_t
	cmp	al, 't'
	jz	load_config_t
load_config_5:
	xor	ah, ah
	cmp	al, 0Ah
	jz	load_config_6
	cmp	al, 0Dh
	jnz	load_config_3
load_config_6:
	mov	ah, 1
	jmp	short load_config_3
;
load_config_p:
	or	ah, ah
	jz	load_config_3
	xor	di, di
	xor	si, si
load_config_p1:
	call	fgetc
	cmp	al, 0FFh
	jz	load_config_eof
	cmp	al, '0'
	jl	load_config_p9
	cmp	al, 'f'
	jg	load_config_p9
	cmp	al, '9'			;Handle digits 0-9
	jg	load_config_p2
	sub	al, '0'
	jmp	short load_config_p4
	nop
load_config_p2:
	cmp	al, 'A'			;Handle digits A-F
	jl	load_config_p9
	cmp	al, 'F'
	jg	load_config_p3
	sub	al, 37h
	jmp	short load_config_p4
	nop
load_config_p3:
	cmp	al, 'a'			;Handle digits a-f
	jl	load_config_p9
	sub	al, 57h
load_config_p4:
	shl	di, 1	
	shl	di, 1	
	shl	di, 1	
	shl	di, 1	
	push	ax
	xor	ah, ah
	or	di, ax
	pop	ax
	inc	si	
	jmp	short load_config_p1
;
; We have built a hex number in DI. SI = number of digits
;
load_config_p9:
	or	si, si
	jz	load_config_5	;No hex digits
	cmp	si, 4
	jg	load_config_5	;Too many hex digits
	or	di, di
	jz	load_config_5	;0 is not a valid value
	mov	cs:io_base, di
	jmp	short load_config_5
;
; Option T found
;
load_config_t:
	or	ah, ah
	jnz	load_config_t1
	jmp	load_config_3
;
load_config_t1:
	call	fgetc
	cmp	al, 0FFh
	jz	load_config_eof
	cmp	al, 'A'		;Option must be A, B or C
	jl	load_config_5
	cmp	al, 'C'
	jg	load_config_5
	jz	load_config_t2
	mov	cs:option_t,0	;TA and TB set option_t to 0
	jmp	load_config_5
;
load_config_t2:
	mov	cs:option_t,1	;TA and TB set option_t to 0
	jmp	load_config_5
;
load_config_eof:
	mov	bx, dx
	mov	ah, 3Eh
	int	21h
	mov	dx, cs:io_base	;Was a valid configuration read?
	or	dx, dx
	jnz	load_config_99
	jmp	load_config_default	;If not, revert to defaults
;
load_config_99:
	ret
load_config	endp

fgetc	proc	near
	jcxz	fgetc_1	;See if there is something in the buffer 
	mov	al, [bx]
	inc	bx	;If so, return it
	dec	cx
	ret
;
; If not, refill the buffer
;
fgetc_1:
	push	ax
	mov	bx, dx
	mov	cx, 80h
	mov	dx, offset configfile_buff
	mov	ah, 3Fh
	int	21h
	mov	cx, ax
	pop	ax
	xchg	bx, dx
	jc	fgetc_2
	or	cx, cx
	jnz	fgetc
fgetc_2:
	mov	al, -1
	ret

fgetc	endp

sEnd	Code
page

sBegin	Data
	externB	configfile_buff	
sEnd	Data

sBegin	Code
assumes cs,Code


;-----------------------------------------------------------------------;
;	This is the same physical device structure as defined above
;	except that the number of scan lines has been increased to
;	encompass shadow memory.  We have to do this for the restore
;	operation of the SaveScreenBitmap function, because BitBLT
;	clips the source to the device extents,	meaning that the entire
;	saved rectangle would be lost.
;
;	To fake out BitBLT, add 410 to the y coordinate to get from active
;	to shadow memory.  This transformation causes the shadow mem copy
;	to be slightly offset from A8000h as compared to the original from
;	A0000h, but there is enough unused RAM at the end of shadow mem to
;	take the slop, and it's fast.
;
;	(8000h bytes per bank of RAM)/ (80 bytes per scan line) =
;		409 scan lines + 48 bytes extra  -->  offset of 410 scans
;
;	New vertical dimension of EGA = 350 + 410 = 760.
;-----------------------------------------------------------------------;

;;;WIN1 not present here
SSB_EXTRA_SCANS	equ	410
;;;NH		equ	SCREEN_HEIGHT + SSB_EXTRA_SCANS	;new display height
;;;
;;;ssb_device BITMAP <SCRSEL,W,NH,WB,P,B,0A0000000H,0,0,0,0,0,0,0>
ssb_device	label	byte

;-----------------------------------------------------------------------;
;	Palette contains the palette values for the EGA card
;	to give the desired colors.  The planes have been
;	changed from the normal EGA plane definition to be
;	C0 = red, C1 = green, C2 = blue.  The intensity bit
;	will be set for all the colors.
;-----------------------------------------------------------------------;

;;; WIN1 moved higher up
;;;Code_palette label	byte
;;;
;;;	db	00h			;Black
;;;	db	3Ch			;Red
;;;	db	3Ah			;Green
;;;	db	3Eh			;Yellow
;;;	db	39h			;Blue
;;;	db	3Dh			;Magenta
;;;	db	3Bh			;Cyan
;;;	db	3Fh			;White
;;;	db	00h			;Black
;;;	db	3Ch			;Red
;;;	db	3Ah			;Green
;;;	db	3Eh			;Yellow
;;;	db	39h			;Blue
;;;	db	3Dh			;Magenta
;;;	db	3Bh			;Cyan
;;;	db	3Fh			;White
;;;	db	0			;Overscan will be black

sEnd	Code

sBegin	Data
X0000		db	0
config_filename	db	'C:\VIKINGI.CFG',0
sEnd	Data

page

;-----------------------------------------------------------------------;
;	Color Table contains the color table definition.  The color
;	table is used for the GetColorTable Escape function and for
;	pen and brush enumeration.
;
;	This table must match the palette register values issued to
;	the EGA palette registers to get the colors in the color table.
;
;	The table is also used to take the color index which is
;	created for a GetPixel and turn it into a color which
;	sum_RGB_colors_alt can deal with.
;-----------------------------------------------------------------------;

sBegin	Code


viking_setreg	proc	near
	sub	dx,2 		;-> register select
	mov	ax, [si]	;Register number
	out	dx, al
	or	ch, ch		;8-bit bus
	jz	viking_setreg8
	add	dx, 2		;-> register data
	mov	ax, [si+2]	;Value
	out	dx, ax
	ret
;
viking_setreg8:
	mov	ah, al
	add	dx, 2		;-> register data
	mov	al, [si+3]	;Value (low)
	out	dx, al
	or	ah,ah		;Do we need to select register+1?
	jle	viking_setreg9
	mov	al, ah		;Looks like we do
	inc	al		
	sub	dx, 2
	out	dx, al		;Select register +1
	add	dx, 2
viking_setreg9:
	mov	al, [si+2]	;Value (high)
	out	dx, al
	ret
viking_setreg	endp

viking_abort	proc	near
	sub	dx, 2		;-> register select
	mov	al, 2		;command control register
	out	dx, al
	add	dx, 2
	or	bh,bh		;Need to use 8-bit I/O?
	jz	viking_abort_8
	in	ax, dx
	or	ax, 8000h	;Set ABORT
	out	dx, ax
	and	ax, 7FFFh	;And clear it
	out	dx, ax
	ret
;
viking_abort_8:
	in	al, dx
	or	al,80h
	out	dx, al
	and	al, 7Fh
	out	dx, al
	ret
viking_abort	endp

viking_w_fifo		proc	near
	mov	bh, ch	;Bus width
	cld
	xor	al, al
	sub	dx, 2
	out	dx, al	;-> register select
viking_w_fifo_1:
	in	al, dx
	test	al, 8Ch	;Bit 7: Error
			;Bit 3: Read FIFO full
			;Bit 2: Read FIFO ready
	jnz	viking_w_fifo_abort
	test	al, 20h	;Bit 5: Ready for commnad?
	jz	viking_w_fifo_1	;No, wait until it is
	lodsw		;Length of command to write
	mov	cx, ax
	or	ax, ax
	jg	viking_w_fifo_3
	mov	ax, 1
viking_w_fifo_end:
	mov	ch, bh	;Restore bus width
	add	dx, 2
	ret
;
viking_w_fifo_2:
	test	al, 8Ch	;Bit 7: Error
			;Bit 3: Read FIFO full
			;Bit 2: Read FIFO ready
	jnz	viking_w_fifo_abort
viking_w_fifo_3:
	in	al, dx
	test	al, 2	;Bit 1: Write FIFO ready?
	jz	viking_w_fifo_2
	or	bh, bh
	jz	viking_w_fifo_4
	lodsw		;Word to write
	add	dx, 2
	out	dx, ax	;Write to the FIFO
	sub	dx, 2
	loop	viking_w_fifo_3
	jmp	short viking_w_fifo_1
;
viking_w_fifo_4:
	lodsw
	add	dx, 2
	xchg	al, ah	;Send the word one byte at a time
	out	dx, al
	mov	al, ah
	out	dx, al
	sub	dx, 2
	loop	viking_w_fifo_3
	jmp	short viking_w_fifo_1
;
viking_w_fifo_abort:
	add	dx, 2
	call	viking_abort
	mov	ax, 0
	jmp	viking_w_fifo_end

viking_w_fifo		endp

sEnd	Code


COLOR_TBL_SIZE	equ	2		;2 entries in the table

	public	snipflg
snipflg	label	byte
end
