        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.INC
;
; This file contains a handful of constants used by the CGA driver.
;
; Created: 27-Dec-2025
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;


STEPBACK	equ	07FA6h		;8000h - 5Ah

Y_STEP		equ	2000h

; The access code for the HD63484 is pretty verbose, so I'm going to use
; macros to try and clarify what's happening.

;
; This is used to simulate a 16-bit write to the card over an 8-bit ISA 
; bus:
;
OUT_DX_AHAL	macro
	xchg	al, ah
	out	dx, al
	mov	al, ah
	out	dx, al
	endm
;
OUT_DX_BHBL	macro
	mov	al, bh
	out	dx, al
	mov	al, bl
	out	dx, al
	endm
;
OUT_DX_CHCL	macro
	mov	al, ch
	out	dx, al
	mov	al, cl
	out	dx, al
	endm
;
; Viking commands

;
; Viking commands
;
VIKING_WPR	equ	00800h	;Write parameter register
VIKING_RPR	equ	00C00h	;Read parameter register
VIKING_WPTN	equ	01800h	;Write pattern
VIKING_DRD	equ	02400h
VIKING_DWT	equ	02800h
VIKING_DMOD	equ	02C00h	;
VIKING_RD	equ	04400h	;Data read
VIKING_WT	equ	04800h	;Data write
VIKING_MOD	equ	04C00h	;Data modify
VIKING_ARCT	equ	05000h	;Absolute rectangle
VIKING_RRCT	equ	05400h	;Relative rectangle
VIKING_APLL	equ	05800h
VIKING_RPLL	equ	05C00h
VIKING_SCPY	equ	07000h
VIKING_AMOVE	equ	08000h	;Absolute move
VIKING_RMOVE	equ	08400h	;Relative move
VIKING_AFRCT	equ	0C000h	;Absolute filled rectangle?
VIKING_RFRCT	equ	0C400h	;Relative filled rectangle?
VIKING_PAINT	equ	0C800h	;Paint
VIKING_AGCPY	equ	0E000h	;Absolute rectangle copy

;
; Viking parameter registers
;
VIKING_CL0	equ	00h	;Colour 0
VIKING_CL1	equ	01h	;Colour 1
VIKING_CCMP	equ	02h	;Colour compare
VIKING_EDG	equ	03h	;Edge colour
VIKING_MASK	equ	04h	;Mask
VIKING_PRC0	equ	05h	;Pattern RAM control
VIKING_PRC1	equ	06h
VIKING_PRC2	equ	07h
VIKING_ADR0	equ	08h	;Area definition (xmin)
VIKING_ADR1	equ	09h	;Area definition (xmax)
VIKING_ADR2	equ	0Ah	;Area definition (ymin)
VIKING_ADR3	equ	0Bh	;Area definition (ymax)
VIKING_RWP0	equ	0Ch	;Read/write pointer high
VIKING_RWP1	equ	0Dh	;Read/write pointer low
VIKING_DP0	equ	10h	;Drawing pointer high
VIKING_DP1	equ	11h	;Drawing pointer low
VIKING_CPX	equ	12h	;Current pointer X
VIKING_CPY	equ	13h	;Current pointer Y

;
; This wraps the HD63484 command WPR (write parameter register) on a
; 16-bit ISA bus...
;
WPR16	macro	reg, value
	mov	ax, (reg AND 1fh) OR VIKING_WPR
	out	dx, ax
	mov	ax, value
	out	dx, ax
	endm
;
; And this does the same on an 8-bit ISA bus.
;
WPR8	macro	reg, value
	mov	ax, (reg AND 1fh) OR VIKING_WPR
	OUT_DX_AHAL
	mov	ax, value
	OUT_DX_AHAL
	endm
;
; Absolute move
;
AMOVE16	macro	x,y
	mov	ax, VIKING_AMOVE
	out	dx, ax
	mov	ax, x
	out	dx, ax
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	out	dx, ax
	endm

AMOVE8	macro	x,y
	mov	ax, 8000h
	OUT_DX_AHAL
	mov	ax, x
	OUT_DX_AHAL
	mov	ax, SCREEN_HEIGHT-1
	sub	ax, y
	OUT_DX_AHAL
	endm




;	EGA Register Definitions.
;
;	The following definitions are the EGA registers and values
;	used by this driver.  All other registers are set up when
;	the EGA is placed into graphics mode and never altered
;	afterwards.
;
;	All unspecified bits in the following registers must be 0.


EGA_BASE	equ	300h		;Base address of the EGA (3xx)



;	Sequencer Registers Used

SEQ_ADDR	equ	0C4h		;Sequencer Address Register
SEQ_DATA	equ	0C5h		;Sequencer Data    Register

SEQ_MAP_MASK	equ	02h		;Write Plane Enable Mask
MM_C0		equ	00000001b	;  C0 plane enable
MM_C1		equ	00000010b	;  C1 plane enable
MM_C2		equ	00000100b	;  C2 plane enable
MM_C3		equ	00001000b	;  C3 plane enable
MM_ALL		equ	00001111b	;  All planes



;	Graphics Controller Registers Used

GRAF_ADDR	equ	0CEh		;Graphics Controller Address Register
GRAF_DATA	equ	0CFh		;Graphics Controller Data    Register

GRAF_SET_RESET	equ	00h		;  Set/Reset Plane Color
GRAF_ENAB_SR	equ	01h		;  Set/Reset Enable
GRAF_COL_COMP	equ	02h		;  Color Compare Register

GRAF_DATA_ROT	equ	03h		;  Data Rotate Register
DR_ROT_CNT	equ	00000111b	;    Data Rotate Count
DR_SET		equ	00000000b	;    Data Unmodified
DR_AND		equ	00001000b	;    Data ANDed with latches
DR_OR		equ	00010000b	;    Data ORed	with latches
DR_XOR		equ	00011000b	;    Data XORed with latches

GRAF_READ_MAP	equ	04h		;  Read Map Select Register
RM_C0		equ	00000000b	;    Read C0 plane
RM_C1		equ	00000001b	;    Read C1 plane
RM_C2		equ	00000010b	;    Read C2 plane
RM_C3		equ	00000011b	;    Read C3 plane

GRAF_MODE	equ	05h		;  Mode Register
M_PROC_WRITE	equ	00000000b	;    Write processor data rotated
M_LATCH_WRITE	equ	00000001b	;    Write latched data
M_COLOR_WRITE	equ	00000010b	;    Write processor data as color
M_AND_WRITE	equ	00000011b	;    Write (procdata AND bitmask)
M_DATA_READ	equ	00000000b	;    Read selected plane
M_COLOR_READ	equ	00001000b	;    Read color compare

GRAF_CDC	equ	07h		;  Color Don't Care Register
GRAF_BIT_MASK	equ	08h		;  Bit Mask Register

