        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	CGA.INC
;
; This file contains a handful of constants used by the CGA driver.
;
; Created: 27-Dec-2025
; Author:  John Elliott [seasip.webmaster@gmail.com]
;
; Exported Functions:	none
;
; Public Functions:	none
;
; Public Data:		none
;
; General Description:
;
; Restrictions:
;


Y_STEP		equ	0A0h	;160 bytes / line
STEPBACK	equ	0FF60h 	;-160 bytes


;	Wy700 Register Definitios

WY700_TOP_L	equ	03DDh	;Top scanline address (low byte)
WY700_TOP_H	equ	03DEh	;Top scanline address (high byte)
WY700_CONTROL	equ	03DFh	;Control register

WY700_DEFCTL	equ	0C8h	;Value to write to control register to
				;select graphics mode

;	EGA Register Definitions.
;
;	The following definitions are the EGA registers and values
;	used by this driver.  All other registers are set up when
;	the EGA is placed into graphics mode and never altered
;	afterwards.
;
;	All unspecified bits in the following registers must be 0.


EGA_BASE	equ	300h		;Base address of the EGA (3xx)



;	Sequencer Registers Used

SEQ_ADDR	equ	0C4h		;Sequencer Address Register
SEQ_DATA	equ	0C5h		;Sequencer Data    Register

SEQ_MAP_MASK	equ	02h		;Write Plane Enable Mask
MM_C0		equ	00000001b	;  C0 plane enable
MM_C1		equ	00000010b	;  C1 plane enable
MM_C2		equ	00000100b	;  C2 plane enable
MM_C3		equ	00001000b	;  C3 plane enable
MM_ALL		equ	00001111b	;  All planes



;	Graphics Controller Registers Used

GRAF_ADDR	equ	0CEh		;Graphics Controller Address Register
GRAF_DATA	equ	0CFh		;Graphics Controller Data    Register

GRAF_SET_RESET	equ	00h		;  Set/Reset Plane Color
GRAF_ENAB_SR	equ	01h		;  Set/Reset Enable
GRAF_COL_COMP	equ	02h		;  Color Compare Register

GRAF_DATA_ROT	equ	03h		;  Data Rotate Register
DR_ROT_CNT	equ	00000111b	;    Data Rotate Count
DR_SET		equ	00000000b	;    Data Unmodified
DR_AND		equ	00001000b	;    Data ANDed with latches
DR_OR		equ	00010000b	;    Data ORed	with latches
DR_XOR		equ	00011000b	;    Data XORed with latches

GRAF_READ_MAP	equ	04h		;  Read Map Select Register
RM_C0		equ	00000000b	;    Read C0 plane
RM_C1		equ	00000001b	;    Read C1 plane
RM_C2		equ	00000010b	;    Read C2 plane
RM_C3		equ	00000011b	;    Read C3 plane

GRAF_MODE	equ	05h		;  Mode Register
M_PROC_WRITE	equ	00000000b	;    Write processor data rotated
M_LATCH_WRITE	equ	00000001b	;    Write latched data
M_COLOR_WRITE	equ	00000010b	;    Write processor data as color
M_AND_WRITE	equ	00000011b	;    Write (procdata AND bitmask)
M_DATA_READ	equ	00000000b	;    Read selected plane
M_COLOR_READ	equ	00001000b	;    Read color compare

GRAF_CDC	equ	07h		;  Color Don't Care Register
GRAF_BIT_MASK	equ	08h		;  Bit Mask Register

